/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.DayOfTheWeek;
import com.amazonaws.services.quicksight.model.transform.AssetOptionsMarshaller;
import java.io.Serializable;

public class AssetOptions
implements Serializable,
Cloneable,
StructuredPojo {
    private String timezone;
    private String weekStart;

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public AssetOptions withTimezone(String timezone) {
        this.setTimezone(timezone);
        return this;
    }

    public void setWeekStart(String weekStart) {
        this.weekStart = weekStart;
    }

    public String getWeekStart() {
        return this.weekStart;
    }

    public AssetOptions withWeekStart(String weekStart) {
        this.setWeekStart(weekStart);
        return this;
    }

    public AssetOptions withWeekStart(DayOfTheWeek weekStart) {
        this.weekStart = weekStart.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTimezone() != null) {
            sb.append("Timezone: ").append(this.getTimezone()).append(",");
        }
        if (this.getWeekStart() != null) {
            sb.append("WeekStart: ").append(this.getWeekStart());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetOptions)) {
            return false;
        }
        AssetOptions other = (AssetOptions)obj;
        if (other.getTimezone() == null ^ this.getTimezone() == null) {
            return false;
        }
        if (other.getTimezone() != null && !other.getTimezone().equals(this.getTimezone())) {
            return false;
        }
        if (other.getWeekStart() == null ^ this.getWeekStart() == null) {
            return false;
        }
        return other.getWeekStart() == null || other.getWeekStart().equals(this.getWeekStart());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTimezone() == null ? 0 : this.getTimezone().hashCode());
        hashCode = 31 * hashCode + (this.getWeekStart() == null ? 0 : this.getWeekStart().hashCode());
        return hashCode;
    }

    public AssetOptions clone() {
        try {
            return (AssetOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AssetOptionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

