/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.AxisDisplayOptions;
import com.amazonaws.services.quicksight.model.ChartAxisLabelOptions;
import com.amazonaws.services.quicksight.model.ContributionAnalysisDefault;
import com.amazonaws.services.quicksight.model.DataLabelOptions;
import com.amazonaws.services.quicksight.model.ForecastConfiguration;
import com.amazonaws.services.quicksight.model.LegendOptions;
import com.amazonaws.services.quicksight.model.LineChartDefaultSeriesSettings;
import com.amazonaws.services.quicksight.model.LineChartFieldWells;
import com.amazonaws.services.quicksight.model.LineChartSortConfiguration;
import com.amazonaws.services.quicksight.model.LineChartType;
import com.amazonaws.services.quicksight.model.LineSeriesAxisDisplayOptions;
import com.amazonaws.services.quicksight.model.ReferenceLine;
import com.amazonaws.services.quicksight.model.SeriesItem;
import com.amazonaws.services.quicksight.model.SmallMultiplesOptions;
import com.amazonaws.services.quicksight.model.TooltipOptions;
import com.amazonaws.services.quicksight.model.VisualPalette;
import com.amazonaws.services.quicksight.model.transform.LineChartConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LineChartConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private LineChartFieldWells fieldWells;
    private LineChartSortConfiguration sortConfiguration;
    private List<ForecastConfiguration> forecastConfigurations;
    private String type;
    private SmallMultiplesOptions smallMultiplesOptions;
    private AxisDisplayOptions xAxisDisplayOptions;
    private ChartAxisLabelOptions xAxisLabelOptions;
    private LineSeriesAxisDisplayOptions primaryYAxisDisplayOptions;
    private ChartAxisLabelOptions primaryYAxisLabelOptions;
    private LineSeriesAxisDisplayOptions secondaryYAxisDisplayOptions;
    private ChartAxisLabelOptions secondaryYAxisLabelOptions;
    private LineChartDefaultSeriesSettings defaultSeriesSettings;
    private List<SeriesItem> series;
    private LegendOptions legend;
    private DataLabelOptions dataLabels;
    private List<ReferenceLine> referenceLines;
    private TooltipOptions tooltip;
    private List<ContributionAnalysisDefault> contributionAnalysisDefaults;
    private VisualPalette visualPalette;

    public void setFieldWells(LineChartFieldWells fieldWells) {
        this.fieldWells = fieldWells;
    }

    public LineChartFieldWells getFieldWells() {
        return this.fieldWells;
    }

    public LineChartConfiguration withFieldWells(LineChartFieldWells fieldWells) {
        this.setFieldWells(fieldWells);
        return this;
    }

    public void setSortConfiguration(LineChartSortConfiguration sortConfiguration) {
        this.sortConfiguration = sortConfiguration;
    }

    public LineChartSortConfiguration getSortConfiguration() {
        return this.sortConfiguration;
    }

    public LineChartConfiguration withSortConfiguration(LineChartSortConfiguration sortConfiguration) {
        this.setSortConfiguration(sortConfiguration);
        return this;
    }

    public List<ForecastConfiguration> getForecastConfigurations() {
        return this.forecastConfigurations;
    }

    public void setForecastConfigurations(Collection<ForecastConfiguration> forecastConfigurations) {
        if (forecastConfigurations == null) {
            this.forecastConfigurations = null;
            return;
        }
        this.forecastConfigurations = new ArrayList<ForecastConfiguration>(forecastConfigurations);
    }

    public LineChartConfiguration withForecastConfigurations(ForecastConfiguration ... forecastConfigurations) {
        if (this.forecastConfigurations == null) {
            this.setForecastConfigurations(new ArrayList<ForecastConfiguration>(forecastConfigurations.length));
        }
        for (ForecastConfiguration ele : forecastConfigurations) {
            this.forecastConfigurations.add(ele);
        }
        return this;
    }

    public LineChartConfiguration withForecastConfigurations(Collection<ForecastConfiguration> forecastConfigurations) {
        this.setForecastConfigurations(forecastConfigurations);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public LineChartConfiguration withType(String type) {
        this.setType(type);
        return this;
    }

    public LineChartConfiguration withType(LineChartType type) {
        this.type = type.toString();
        return this;
    }

    public void setSmallMultiplesOptions(SmallMultiplesOptions smallMultiplesOptions) {
        this.smallMultiplesOptions = smallMultiplesOptions;
    }

    public SmallMultiplesOptions getSmallMultiplesOptions() {
        return this.smallMultiplesOptions;
    }

    public LineChartConfiguration withSmallMultiplesOptions(SmallMultiplesOptions smallMultiplesOptions) {
        this.setSmallMultiplesOptions(smallMultiplesOptions);
        return this;
    }

    public void setXAxisDisplayOptions(AxisDisplayOptions xAxisDisplayOptions) {
        this.xAxisDisplayOptions = xAxisDisplayOptions;
    }

    public AxisDisplayOptions getXAxisDisplayOptions() {
        return this.xAxisDisplayOptions;
    }

    public LineChartConfiguration withXAxisDisplayOptions(AxisDisplayOptions xAxisDisplayOptions) {
        this.setXAxisDisplayOptions(xAxisDisplayOptions);
        return this;
    }

    public void setXAxisLabelOptions(ChartAxisLabelOptions xAxisLabelOptions) {
        this.xAxisLabelOptions = xAxisLabelOptions;
    }

    public ChartAxisLabelOptions getXAxisLabelOptions() {
        return this.xAxisLabelOptions;
    }

    public LineChartConfiguration withXAxisLabelOptions(ChartAxisLabelOptions xAxisLabelOptions) {
        this.setXAxisLabelOptions(xAxisLabelOptions);
        return this;
    }

    public void setPrimaryYAxisDisplayOptions(LineSeriesAxisDisplayOptions primaryYAxisDisplayOptions) {
        this.primaryYAxisDisplayOptions = primaryYAxisDisplayOptions;
    }

    public LineSeriesAxisDisplayOptions getPrimaryYAxisDisplayOptions() {
        return this.primaryYAxisDisplayOptions;
    }

    public LineChartConfiguration withPrimaryYAxisDisplayOptions(LineSeriesAxisDisplayOptions primaryYAxisDisplayOptions) {
        this.setPrimaryYAxisDisplayOptions(primaryYAxisDisplayOptions);
        return this;
    }

    public void setPrimaryYAxisLabelOptions(ChartAxisLabelOptions primaryYAxisLabelOptions) {
        this.primaryYAxisLabelOptions = primaryYAxisLabelOptions;
    }

    public ChartAxisLabelOptions getPrimaryYAxisLabelOptions() {
        return this.primaryYAxisLabelOptions;
    }

    public LineChartConfiguration withPrimaryYAxisLabelOptions(ChartAxisLabelOptions primaryYAxisLabelOptions) {
        this.setPrimaryYAxisLabelOptions(primaryYAxisLabelOptions);
        return this;
    }

    public void setSecondaryYAxisDisplayOptions(LineSeriesAxisDisplayOptions secondaryYAxisDisplayOptions) {
        this.secondaryYAxisDisplayOptions = secondaryYAxisDisplayOptions;
    }

    public LineSeriesAxisDisplayOptions getSecondaryYAxisDisplayOptions() {
        return this.secondaryYAxisDisplayOptions;
    }

    public LineChartConfiguration withSecondaryYAxisDisplayOptions(LineSeriesAxisDisplayOptions secondaryYAxisDisplayOptions) {
        this.setSecondaryYAxisDisplayOptions(secondaryYAxisDisplayOptions);
        return this;
    }

    public void setSecondaryYAxisLabelOptions(ChartAxisLabelOptions secondaryYAxisLabelOptions) {
        this.secondaryYAxisLabelOptions = secondaryYAxisLabelOptions;
    }

    public ChartAxisLabelOptions getSecondaryYAxisLabelOptions() {
        return this.secondaryYAxisLabelOptions;
    }

    public LineChartConfiguration withSecondaryYAxisLabelOptions(ChartAxisLabelOptions secondaryYAxisLabelOptions) {
        this.setSecondaryYAxisLabelOptions(secondaryYAxisLabelOptions);
        return this;
    }

    public void setDefaultSeriesSettings(LineChartDefaultSeriesSettings defaultSeriesSettings) {
        this.defaultSeriesSettings = defaultSeriesSettings;
    }

    public LineChartDefaultSeriesSettings getDefaultSeriesSettings() {
        return this.defaultSeriesSettings;
    }

    public LineChartConfiguration withDefaultSeriesSettings(LineChartDefaultSeriesSettings defaultSeriesSettings) {
        this.setDefaultSeriesSettings(defaultSeriesSettings);
        return this;
    }

    public List<SeriesItem> getSeries() {
        return this.series;
    }

    public void setSeries(Collection<SeriesItem> series) {
        if (series == null) {
            this.series = null;
            return;
        }
        this.series = new ArrayList<SeriesItem>(series);
    }

    public LineChartConfiguration withSeries(SeriesItem ... series) {
        if (this.series == null) {
            this.setSeries(new ArrayList<SeriesItem>(series.length));
        }
        for (SeriesItem ele : series) {
            this.series.add(ele);
        }
        return this;
    }

    public LineChartConfiguration withSeries(Collection<SeriesItem> series) {
        this.setSeries(series);
        return this;
    }

    public void setLegend(LegendOptions legend) {
        this.legend = legend;
    }

    public LegendOptions getLegend() {
        return this.legend;
    }

    public LineChartConfiguration withLegend(LegendOptions legend) {
        this.setLegend(legend);
        return this;
    }

    public void setDataLabels(DataLabelOptions dataLabels) {
        this.dataLabels = dataLabels;
    }

    public DataLabelOptions getDataLabels() {
        return this.dataLabels;
    }

    public LineChartConfiguration withDataLabels(DataLabelOptions dataLabels) {
        this.setDataLabels(dataLabels);
        return this;
    }

    public List<ReferenceLine> getReferenceLines() {
        return this.referenceLines;
    }

    public void setReferenceLines(Collection<ReferenceLine> referenceLines) {
        if (referenceLines == null) {
            this.referenceLines = null;
            return;
        }
        this.referenceLines = new ArrayList<ReferenceLine>(referenceLines);
    }

    public LineChartConfiguration withReferenceLines(ReferenceLine ... referenceLines) {
        if (this.referenceLines == null) {
            this.setReferenceLines(new ArrayList<ReferenceLine>(referenceLines.length));
        }
        for (ReferenceLine ele : referenceLines) {
            this.referenceLines.add(ele);
        }
        return this;
    }

    public LineChartConfiguration withReferenceLines(Collection<ReferenceLine> referenceLines) {
        this.setReferenceLines(referenceLines);
        return this;
    }

    public void setTooltip(TooltipOptions tooltip) {
        this.tooltip = tooltip;
    }

    public TooltipOptions getTooltip() {
        return this.tooltip;
    }

    public LineChartConfiguration withTooltip(TooltipOptions tooltip) {
        this.setTooltip(tooltip);
        return this;
    }

    public List<ContributionAnalysisDefault> getContributionAnalysisDefaults() {
        return this.contributionAnalysisDefaults;
    }

    public void setContributionAnalysisDefaults(Collection<ContributionAnalysisDefault> contributionAnalysisDefaults) {
        if (contributionAnalysisDefaults == null) {
            this.contributionAnalysisDefaults = null;
            return;
        }
        this.contributionAnalysisDefaults = new ArrayList<ContributionAnalysisDefault>(contributionAnalysisDefaults);
    }

    public LineChartConfiguration withContributionAnalysisDefaults(ContributionAnalysisDefault ... contributionAnalysisDefaults) {
        if (this.contributionAnalysisDefaults == null) {
            this.setContributionAnalysisDefaults(new ArrayList<ContributionAnalysisDefault>(contributionAnalysisDefaults.length));
        }
        for (ContributionAnalysisDefault ele : contributionAnalysisDefaults) {
            this.contributionAnalysisDefaults.add(ele);
        }
        return this;
    }

    public LineChartConfiguration withContributionAnalysisDefaults(Collection<ContributionAnalysisDefault> contributionAnalysisDefaults) {
        this.setContributionAnalysisDefaults(contributionAnalysisDefaults);
        return this;
    }

    public void setVisualPalette(VisualPalette visualPalette) {
        this.visualPalette = visualPalette;
    }

    public VisualPalette getVisualPalette() {
        return this.visualPalette;
    }

    public LineChartConfiguration withVisualPalette(VisualPalette visualPalette) {
        this.setVisualPalette(visualPalette);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFieldWells() != null) {
            sb.append("FieldWells: ").append(this.getFieldWells()).append(",");
        }
        if (this.getSortConfiguration() != null) {
            sb.append("SortConfiguration: ").append(this.getSortConfiguration()).append(",");
        }
        if (this.getForecastConfigurations() != null) {
            sb.append("ForecastConfigurations: ").append(this.getForecastConfigurations()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getSmallMultiplesOptions() != null) {
            sb.append("SmallMultiplesOptions: ").append(this.getSmallMultiplesOptions()).append(",");
        }
        if (this.getXAxisDisplayOptions() != null) {
            sb.append("XAxisDisplayOptions: ").append(this.getXAxisDisplayOptions()).append(",");
        }
        if (this.getXAxisLabelOptions() != null) {
            sb.append("XAxisLabelOptions: ").append(this.getXAxisLabelOptions()).append(",");
        }
        if (this.getPrimaryYAxisDisplayOptions() != null) {
            sb.append("PrimaryYAxisDisplayOptions: ").append(this.getPrimaryYAxisDisplayOptions()).append(",");
        }
        if (this.getPrimaryYAxisLabelOptions() != null) {
            sb.append("PrimaryYAxisLabelOptions: ").append(this.getPrimaryYAxisLabelOptions()).append(",");
        }
        if (this.getSecondaryYAxisDisplayOptions() != null) {
            sb.append("SecondaryYAxisDisplayOptions: ").append(this.getSecondaryYAxisDisplayOptions()).append(",");
        }
        if (this.getSecondaryYAxisLabelOptions() != null) {
            sb.append("SecondaryYAxisLabelOptions: ").append(this.getSecondaryYAxisLabelOptions()).append(",");
        }
        if (this.getDefaultSeriesSettings() != null) {
            sb.append("DefaultSeriesSettings: ").append(this.getDefaultSeriesSettings()).append(",");
        }
        if (this.getSeries() != null) {
            sb.append("Series: ").append(this.getSeries()).append(",");
        }
        if (this.getLegend() != null) {
            sb.append("Legend: ").append(this.getLegend()).append(",");
        }
        if (this.getDataLabels() != null) {
            sb.append("DataLabels: ").append(this.getDataLabels()).append(",");
        }
        if (this.getReferenceLines() != null) {
            sb.append("ReferenceLines: ").append(this.getReferenceLines()).append(",");
        }
        if (this.getTooltip() != null) {
            sb.append("Tooltip: ").append(this.getTooltip()).append(",");
        }
        if (this.getContributionAnalysisDefaults() != null) {
            sb.append("ContributionAnalysisDefaults: ").append(this.getContributionAnalysisDefaults()).append(",");
        }
        if (this.getVisualPalette() != null) {
            sb.append("VisualPalette: ").append(this.getVisualPalette());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LineChartConfiguration)) {
            return false;
        }
        LineChartConfiguration other = (LineChartConfiguration)obj;
        if (other.getFieldWells() == null ^ this.getFieldWells() == null) {
            return false;
        }
        if (other.getFieldWells() != null && !other.getFieldWells().equals(this.getFieldWells())) {
            return false;
        }
        if (other.getSortConfiguration() == null ^ this.getSortConfiguration() == null) {
            return false;
        }
        if (other.getSortConfiguration() != null && !other.getSortConfiguration().equals(this.getSortConfiguration())) {
            return false;
        }
        if (other.getForecastConfigurations() == null ^ this.getForecastConfigurations() == null) {
            return false;
        }
        if (other.getForecastConfigurations() != null && !other.getForecastConfigurations().equals(this.getForecastConfigurations())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getSmallMultiplesOptions() == null ^ this.getSmallMultiplesOptions() == null) {
            return false;
        }
        if (other.getSmallMultiplesOptions() != null && !other.getSmallMultiplesOptions().equals(this.getSmallMultiplesOptions())) {
            return false;
        }
        if (other.getXAxisDisplayOptions() == null ^ this.getXAxisDisplayOptions() == null) {
            return false;
        }
        if (other.getXAxisDisplayOptions() != null && !other.getXAxisDisplayOptions().equals(this.getXAxisDisplayOptions())) {
            return false;
        }
        if (other.getXAxisLabelOptions() == null ^ this.getXAxisLabelOptions() == null) {
            return false;
        }
        if (other.getXAxisLabelOptions() != null && !other.getXAxisLabelOptions().equals(this.getXAxisLabelOptions())) {
            return false;
        }
        if (other.getPrimaryYAxisDisplayOptions() == null ^ this.getPrimaryYAxisDisplayOptions() == null) {
            return false;
        }
        if (other.getPrimaryYAxisDisplayOptions() != null && !other.getPrimaryYAxisDisplayOptions().equals(this.getPrimaryYAxisDisplayOptions())) {
            return false;
        }
        if (other.getPrimaryYAxisLabelOptions() == null ^ this.getPrimaryYAxisLabelOptions() == null) {
            return false;
        }
        if (other.getPrimaryYAxisLabelOptions() != null && !other.getPrimaryYAxisLabelOptions().equals(this.getPrimaryYAxisLabelOptions())) {
            return false;
        }
        if (other.getSecondaryYAxisDisplayOptions() == null ^ this.getSecondaryYAxisDisplayOptions() == null) {
            return false;
        }
        if (other.getSecondaryYAxisDisplayOptions() != null && !other.getSecondaryYAxisDisplayOptions().equals(this.getSecondaryYAxisDisplayOptions())) {
            return false;
        }
        if (other.getSecondaryYAxisLabelOptions() == null ^ this.getSecondaryYAxisLabelOptions() == null) {
            return false;
        }
        if (other.getSecondaryYAxisLabelOptions() != null && !other.getSecondaryYAxisLabelOptions().equals(this.getSecondaryYAxisLabelOptions())) {
            return false;
        }
        if (other.getDefaultSeriesSettings() == null ^ this.getDefaultSeriesSettings() == null) {
            return false;
        }
        if (other.getDefaultSeriesSettings() != null && !other.getDefaultSeriesSettings().equals(this.getDefaultSeriesSettings())) {
            return false;
        }
        if (other.getSeries() == null ^ this.getSeries() == null) {
            return false;
        }
        if (other.getSeries() != null && !other.getSeries().equals(this.getSeries())) {
            return false;
        }
        if (other.getLegend() == null ^ this.getLegend() == null) {
            return false;
        }
        if (other.getLegend() != null && !other.getLegend().equals(this.getLegend())) {
            return false;
        }
        if (other.getDataLabels() == null ^ this.getDataLabels() == null) {
            return false;
        }
        if (other.getDataLabels() != null && !other.getDataLabels().equals(this.getDataLabels())) {
            return false;
        }
        if (other.getReferenceLines() == null ^ this.getReferenceLines() == null) {
            return false;
        }
        if (other.getReferenceLines() != null && !other.getReferenceLines().equals(this.getReferenceLines())) {
            return false;
        }
        if (other.getTooltip() == null ^ this.getTooltip() == null) {
            return false;
        }
        if (other.getTooltip() != null && !other.getTooltip().equals(this.getTooltip())) {
            return false;
        }
        if (other.getContributionAnalysisDefaults() == null ^ this.getContributionAnalysisDefaults() == null) {
            return false;
        }
        if (other.getContributionAnalysisDefaults() != null && !other.getContributionAnalysisDefaults().equals(this.getContributionAnalysisDefaults())) {
            return false;
        }
        if (other.getVisualPalette() == null ^ this.getVisualPalette() == null) {
            return false;
        }
        return other.getVisualPalette() == null || other.getVisualPalette().equals(this.getVisualPalette());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFieldWells() == null ? 0 : this.getFieldWells().hashCode());
        hashCode = 31 * hashCode + (this.getSortConfiguration() == null ? 0 : this.getSortConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getForecastConfigurations() == null ? 0 : this.getForecastConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getSmallMultiplesOptions() == null ? 0 : this.getSmallMultiplesOptions().hashCode());
        hashCode = 31 * hashCode + (this.getXAxisDisplayOptions() == null ? 0 : this.getXAxisDisplayOptions().hashCode());
        hashCode = 31 * hashCode + (this.getXAxisLabelOptions() == null ? 0 : this.getXAxisLabelOptions().hashCode());
        hashCode = 31 * hashCode + (this.getPrimaryYAxisDisplayOptions() == null ? 0 : this.getPrimaryYAxisDisplayOptions().hashCode());
        hashCode = 31 * hashCode + (this.getPrimaryYAxisLabelOptions() == null ? 0 : this.getPrimaryYAxisLabelOptions().hashCode());
        hashCode = 31 * hashCode + (this.getSecondaryYAxisDisplayOptions() == null ? 0 : this.getSecondaryYAxisDisplayOptions().hashCode());
        hashCode = 31 * hashCode + (this.getSecondaryYAxisLabelOptions() == null ? 0 : this.getSecondaryYAxisLabelOptions().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultSeriesSettings() == null ? 0 : this.getDefaultSeriesSettings().hashCode());
        hashCode = 31 * hashCode + (this.getSeries() == null ? 0 : this.getSeries().hashCode());
        hashCode = 31 * hashCode + (this.getLegend() == null ? 0 : this.getLegend().hashCode());
        hashCode = 31 * hashCode + (this.getDataLabels() == null ? 0 : this.getDataLabels().hashCode());
        hashCode = 31 * hashCode + (this.getReferenceLines() == null ? 0 : this.getReferenceLines().hashCode());
        hashCode = 31 * hashCode + (this.getTooltip() == null ? 0 : this.getTooltip().hashCode());
        hashCode = 31 * hashCode + (this.getContributionAnalysisDefaults() == null ? 0 : this.getContributionAnalysisDefaults().hashCode());
        hashCode = 31 * hashCode + (this.getVisualPalette() == null ? 0 : this.getVisualPalette().hashCode());
        return hashCode;
    }

    public LineChartConfiguration clone() {
        try {
            return (LineChartConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LineChartConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

