/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.quicksight.model.AssetBundleImportSource;
import java.nio.ByteBuffer;

@SdkInternalApi
public class AssetBundleImportSourceMarshaller {
    private static final MarshallingInfo<ByteBuffer> BODY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Body").build();
    private static final MarshallingInfo<String> S3URI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Uri").build();
    private static final AssetBundleImportSourceMarshaller instance = new AssetBundleImportSourceMarshaller();

    public static AssetBundleImportSourceMarshaller getInstance() {
        return instance;
    }

    public void marshall(AssetBundleImportSource assetBundleImportSource, ProtocolMarshaller protocolMarshaller) {
        if (assetBundleImportSource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)assetBundleImportSource.getBody(), BODY_BINDING);
            protocolMarshaller.marshall((Object)assetBundleImportSource.getS3Uri(), S3URI_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

