/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.quicksight.model.AnalysisDefinition;
import com.amazonaws.services.quicksight.model.AnalysisSourceEntity;
import com.amazonaws.services.quicksight.model.Parameters;
import com.amazonaws.services.quicksight.model.ResourcePermission;
import com.amazonaws.services.quicksight.model.Tag;
import com.amazonaws.services.quicksight.model.ValidationStrategy;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateAnalysisRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String awsAccountId;
    private String analysisId;
    private String name;
    private Parameters parameters;
    private List<ResourcePermission> permissions;
    private AnalysisSourceEntity sourceEntity;
    private String themeArn;
    private List<Tag> tags;
    private AnalysisDefinition definition;
    private ValidationStrategy validationStrategy;

    public void setAwsAccountId(String awsAccountId) {
        this.awsAccountId = awsAccountId;
    }

    public String getAwsAccountId() {
        return this.awsAccountId;
    }

    public CreateAnalysisRequest withAwsAccountId(String awsAccountId) {
        this.setAwsAccountId(awsAccountId);
        return this;
    }

    public void setAnalysisId(String analysisId) {
        this.analysisId = analysisId;
    }

    public String getAnalysisId() {
        return this.analysisId;
    }

    public CreateAnalysisRequest withAnalysisId(String analysisId) {
        this.setAnalysisId(analysisId);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateAnalysisRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setParameters(Parameters parameters) {
        this.parameters = parameters;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public CreateAnalysisRequest withParameters(Parameters parameters) {
        this.setParameters(parameters);
        return this;
    }

    public List<ResourcePermission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Collection<ResourcePermission> permissions) {
        if (permissions == null) {
            this.permissions = null;
            return;
        }
        this.permissions = new ArrayList<ResourcePermission>(permissions);
    }

    public CreateAnalysisRequest withPermissions(ResourcePermission ... permissions) {
        if (this.permissions == null) {
            this.setPermissions(new ArrayList<ResourcePermission>(permissions.length));
        }
        for (ResourcePermission ele : permissions) {
            this.permissions.add(ele);
        }
        return this;
    }

    public CreateAnalysisRequest withPermissions(Collection<ResourcePermission> permissions) {
        this.setPermissions(permissions);
        return this;
    }

    public void setSourceEntity(AnalysisSourceEntity sourceEntity) {
        this.sourceEntity = sourceEntity;
    }

    public AnalysisSourceEntity getSourceEntity() {
        return this.sourceEntity;
    }

    public CreateAnalysisRequest withSourceEntity(AnalysisSourceEntity sourceEntity) {
        this.setSourceEntity(sourceEntity);
        return this;
    }

    public void setThemeArn(String themeArn) {
        this.themeArn = themeArn;
    }

    public String getThemeArn() {
        return this.themeArn;
    }

    public CreateAnalysisRequest withThemeArn(String themeArn) {
        this.setThemeArn(themeArn);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateAnalysisRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateAnalysisRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setDefinition(AnalysisDefinition definition) {
        this.definition = definition;
    }

    public AnalysisDefinition getDefinition() {
        return this.definition;
    }

    public CreateAnalysisRequest withDefinition(AnalysisDefinition definition) {
        this.setDefinition(definition);
        return this;
    }

    public void setValidationStrategy(ValidationStrategy validationStrategy) {
        this.validationStrategy = validationStrategy;
    }

    public ValidationStrategy getValidationStrategy() {
        return this.validationStrategy;
    }

    public CreateAnalysisRequest withValidationStrategy(ValidationStrategy validationStrategy) {
        this.setValidationStrategy(validationStrategy);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAwsAccountId() != null) {
            sb.append("AwsAccountId: ").append(this.getAwsAccountId()).append(",");
        }
        if (this.getAnalysisId() != null) {
            sb.append("AnalysisId: ").append(this.getAnalysisId()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters()).append(",");
        }
        if (this.getPermissions() != null) {
            sb.append("Permissions: ").append(this.getPermissions()).append(",");
        }
        if (this.getSourceEntity() != null) {
            sb.append("SourceEntity: ").append(this.getSourceEntity()).append(",");
        }
        if (this.getThemeArn() != null) {
            sb.append("ThemeArn: ").append(this.getThemeArn()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getDefinition() != null) {
            sb.append("Definition: ").append(this.getDefinition()).append(",");
        }
        if (this.getValidationStrategy() != null) {
            sb.append("ValidationStrategy: ").append(this.getValidationStrategy());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAnalysisRequest)) {
            return false;
        }
        CreateAnalysisRequest other = (CreateAnalysisRequest)obj;
        if (other.getAwsAccountId() == null ^ this.getAwsAccountId() == null) {
            return false;
        }
        if (other.getAwsAccountId() != null && !other.getAwsAccountId().equals(this.getAwsAccountId())) {
            return false;
        }
        if (other.getAnalysisId() == null ^ this.getAnalysisId() == null) {
            return false;
        }
        if (other.getAnalysisId() != null && !other.getAnalysisId().equals(this.getAnalysisId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !other.getParameters().equals(this.getParameters())) {
            return false;
        }
        if (other.getPermissions() == null ^ this.getPermissions() == null) {
            return false;
        }
        if (other.getPermissions() != null && !other.getPermissions().equals(this.getPermissions())) {
            return false;
        }
        if (other.getSourceEntity() == null ^ this.getSourceEntity() == null) {
            return false;
        }
        if (other.getSourceEntity() != null && !other.getSourceEntity().equals(this.getSourceEntity())) {
            return false;
        }
        if (other.getThemeArn() == null ^ this.getThemeArn() == null) {
            return false;
        }
        if (other.getThemeArn() != null && !other.getThemeArn().equals(this.getThemeArn())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getDefinition() == null ^ this.getDefinition() == null) {
            return false;
        }
        if (other.getDefinition() != null && !other.getDefinition().equals(this.getDefinition())) {
            return false;
        }
        if (other.getValidationStrategy() == null ^ this.getValidationStrategy() == null) {
            return false;
        }
        return other.getValidationStrategy() == null || other.getValidationStrategy().equals(this.getValidationStrategy());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAwsAccountId() == null ? 0 : this.getAwsAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getAnalysisId() == null ? 0 : this.getAnalysisId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        hashCode = 31 * hashCode + (this.getPermissions() == null ? 0 : this.getPermissions().hashCode());
        hashCode = 31 * hashCode + (this.getSourceEntity() == null ? 0 : this.getSourceEntity().hashCode());
        hashCode = 31 * hashCode + (this.getThemeArn() == null ? 0 : this.getThemeArn().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getDefinition() == null ? 0 : this.getDefinition().hashCode());
        hashCode = 31 * hashCode + (this.getValidationStrategy() == null ? 0 : this.getValidationStrategy().hashCode());
        return hashCode;
    }

    public CreateAnalysisRequest clone() {
        return (CreateAnalysisRequest)super.clone();
    }
}

