/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.CustomColor;
import com.amazonaws.services.quicksight.model.transform.ColorsConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ColorsConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private List<CustomColor> customColors;

    public List<CustomColor> getCustomColors() {
        return this.customColors;
    }

    public void setCustomColors(Collection<CustomColor> customColors) {
        if (customColors == null) {
            this.customColors = null;
            return;
        }
        this.customColors = new ArrayList<CustomColor>(customColors);
    }

    public ColorsConfiguration withCustomColors(CustomColor ... customColors) {
        if (this.customColors == null) {
            this.setCustomColors(new ArrayList<CustomColor>(customColors.length));
        }
        for (CustomColor ele : customColors) {
            this.customColors.add(ele);
        }
        return this;
    }

    public ColorsConfiguration withCustomColors(Collection<CustomColor> customColors) {
        this.setCustomColors(customColors);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCustomColors() != null) {
            sb.append("CustomColors: ").append(this.getCustomColors());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColorsConfiguration)) {
            return false;
        }
        ColorsConfiguration other = (ColorsConfiguration)obj;
        if (other.getCustomColors() == null ^ this.getCustomColors() == null) {
            return false;
        }
        return other.getCustomColors() == null || other.getCustomColors().equals(this.getCustomColors());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCustomColors() == null ? 0 : this.getCustomColors().hashCode());
        return hashCode;
    }

    public ColorsConfiguration clone() {
        try {
            return (ColorsConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ColorsConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

