/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.CategoryFilterMatchOperator;
import com.amazonaws.services.quicksight.model.CategoryFilterSelectAllOptions;
import com.amazonaws.services.quicksight.model.transform.FilterListConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FilterListConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String matchOperator;
    private List<String> categoryValues;
    private String selectAllOptions;

    public void setMatchOperator(String matchOperator) {
        this.matchOperator = matchOperator;
    }

    public String getMatchOperator() {
        return this.matchOperator;
    }

    public FilterListConfiguration withMatchOperator(String matchOperator) {
        this.setMatchOperator(matchOperator);
        return this;
    }

    public FilterListConfiguration withMatchOperator(CategoryFilterMatchOperator matchOperator) {
        this.matchOperator = matchOperator.toString();
        return this;
    }

    public List<String> getCategoryValues() {
        return this.categoryValues;
    }

    public void setCategoryValues(Collection<String> categoryValues) {
        if (categoryValues == null) {
            this.categoryValues = null;
            return;
        }
        this.categoryValues = new ArrayList<String>(categoryValues);
    }

    public FilterListConfiguration withCategoryValues(String ... categoryValues) {
        if (this.categoryValues == null) {
            this.setCategoryValues(new ArrayList<String>(categoryValues.length));
        }
        for (String ele : categoryValues) {
            this.categoryValues.add(ele);
        }
        return this;
    }

    public FilterListConfiguration withCategoryValues(Collection<String> categoryValues) {
        this.setCategoryValues(categoryValues);
        return this;
    }

    public void setSelectAllOptions(String selectAllOptions) {
        this.selectAllOptions = selectAllOptions;
    }

    public String getSelectAllOptions() {
        return this.selectAllOptions;
    }

    public FilterListConfiguration withSelectAllOptions(String selectAllOptions) {
        this.setSelectAllOptions(selectAllOptions);
        return this;
    }

    public FilterListConfiguration withSelectAllOptions(CategoryFilterSelectAllOptions selectAllOptions) {
        this.selectAllOptions = selectAllOptions.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMatchOperator() != null) {
            sb.append("MatchOperator: ").append(this.getMatchOperator()).append(",");
        }
        if (this.getCategoryValues() != null) {
            sb.append("CategoryValues: ").append(this.getCategoryValues()).append(",");
        }
        if (this.getSelectAllOptions() != null) {
            sb.append("SelectAllOptions: ").append(this.getSelectAllOptions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterListConfiguration)) {
            return false;
        }
        FilterListConfiguration other = (FilterListConfiguration)obj;
        if (other.getMatchOperator() == null ^ this.getMatchOperator() == null) {
            return false;
        }
        if (other.getMatchOperator() != null && !other.getMatchOperator().equals(this.getMatchOperator())) {
            return false;
        }
        if (other.getCategoryValues() == null ^ this.getCategoryValues() == null) {
            return false;
        }
        if (other.getCategoryValues() != null && !other.getCategoryValues().equals(this.getCategoryValues())) {
            return false;
        }
        if (other.getSelectAllOptions() == null ^ this.getSelectAllOptions() == null) {
            return false;
        }
        return other.getSelectAllOptions() == null || other.getSelectAllOptions().equals(this.getSelectAllOptions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMatchOperator() == null ? 0 : this.getMatchOperator().hashCode());
        hashCode = 31 * hashCode + (this.getCategoryValues() == null ? 0 : this.getCategoryValues().hashCode());
        hashCode = 31 * hashCode + (this.getSelectAllOptions() == null ? 0 : this.getSelectAllOptions().hashCode());
        return hashCode;
    }

    public FilterListConfiguration clone() {
        try {
            return (FilterListConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FilterListConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

