/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.AnalysisDefaults;
import com.amazonaws.services.quicksight.model.CalculatedField;
import com.amazonaws.services.quicksight.model.ColumnConfiguration;
import com.amazonaws.services.quicksight.model.DataSetConfiguration;
import com.amazonaws.services.quicksight.model.FilterGroup;
import com.amazonaws.services.quicksight.model.ParameterDeclaration;
import com.amazonaws.services.quicksight.model.SheetDefinition;
import com.amazonaws.services.quicksight.model.transform.TemplateVersionDefinitionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TemplateVersionDefinition
implements Serializable,
Cloneable,
StructuredPojo {
    private List<DataSetConfiguration> dataSetConfigurations;
    private List<SheetDefinition> sheets;
    private List<CalculatedField> calculatedFields;
    private List<ParameterDeclaration> parameterDeclarations;
    private List<FilterGroup> filterGroups;
    private List<ColumnConfiguration> columnConfigurations;
    private AnalysisDefaults analysisDefaults;

    public List<DataSetConfiguration> getDataSetConfigurations() {
        return this.dataSetConfigurations;
    }

    public void setDataSetConfigurations(Collection<DataSetConfiguration> dataSetConfigurations) {
        if (dataSetConfigurations == null) {
            this.dataSetConfigurations = null;
            return;
        }
        this.dataSetConfigurations = new ArrayList<DataSetConfiguration>(dataSetConfigurations);
    }

    public TemplateVersionDefinition withDataSetConfigurations(DataSetConfiguration ... dataSetConfigurations) {
        if (this.dataSetConfigurations == null) {
            this.setDataSetConfigurations(new ArrayList<DataSetConfiguration>(dataSetConfigurations.length));
        }
        for (DataSetConfiguration ele : dataSetConfigurations) {
            this.dataSetConfigurations.add(ele);
        }
        return this;
    }

    public TemplateVersionDefinition withDataSetConfigurations(Collection<DataSetConfiguration> dataSetConfigurations) {
        this.setDataSetConfigurations(dataSetConfigurations);
        return this;
    }

    public List<SheetDefinition> getSheets() {
        return this.sheets;
    }

    public void setSheets(Collection<SheetDefinition> sheets) {
        if (sheets == null) {
            this.sheets = null;
            return;
        }
        this.sheets = new ArrayList<SheetDefinition>(sheets);
    }

    public TemplateVersionDefinition withSheets(SheetDefinition ... sheets) {
        if (this.sheets == null) {
            this.setSheets(new ArrayList<SheetDefinition>(sheets.length));
        }
        for (SheetDefinition ele : sheets) {
            this.sheets.add(ele);
        }
        return this;
    }

    public TemplateVersionDefinition withSheets(Collection<SheetDefinition> sheets) {
        this.setSheets(sheets);
        return this;
    }

    public List<CalculatedField> getCalculatedFields() {
        return this.calculatedFields;
    }

    public void setCalculatedFields(Collection<CalculatedField> calculatedFields) {
        if (calculatedFields == null) {
            this.calculatedFields = null;
            return;
        }
        this.calculatedFields = new ArrayList<CalculatedField>(calculatedFields);
    }

    public TemplateVersionDefinition withCalculatedFields(CalculatedField ... calculatedFields) {
        if (this.calculatedFields == null) {
            this.setCalculatedFields(new ArrayList<CalculatedField>(calculatedFields.length));
        }
        for (CalculatedField ele : calculatedFields) {
            this.calculatedFields.add(ele);
        }
        return this;
    }

    public TemplateVersionDefinition withCalculatedFields(Collection<CalculatedField> calculatedFields) {
        this.setCalculatedFields(calculatedFields);
        return this;
    }

    public List<ParameterDeclaration> getParameterDeclarations() {
        return this.parameterDeclarations;
    }

    public void setParameterDeclarations(Collection<ParameterDeclaration> parameterDeclarations) {
        if (parameterDeclarations == null) {
            this.parameterDeclarations = null;
            return;
        }
        this.parameterDeclarations = new ArrayList<ParameterDeclaration>(parameterDeclarations);
    }

    public TemplateVersionDefinition withParameterDeclarations(ParameterDeclaration ... parameterDeclarations) {
        if (this.parameterDeclarations == null) {
            this.setParameterDeclarations(new ArrayList<ParameterDeclaration>(parameterDeclarations.length));
        }
        for (ParameterDeclaration ele : parameterDeclarations) {
            this.parameterDeclarations.add(ele);
        }
        return this;
    }

    public TemplateVersionDefinition withParameterDeclarations(Collection<ParameterDeclaration> parameterDeclarations) {
        this.setParameterDeclarations(parameterDeclarations);
        return this;
    }

    public List<FilterGroup> getFilterGroups() {
        return this.filterGroups;
    }

    public void setFilterGroups(Collection<FilterGroup> filterGroups) {
        if (filterGroups == null) {
            this.filterGroups = null;
            return;
        }
        this.filterGroups = new ArrayList<FilterGroup>(filterGroups);
    }

    public TemplateVersionDefinition withFilterGroups(FilterGroup ... filterGroups) {
        if (this.filterGroups == null) {
            this.setFilterGroups(new ArrayList<FilterGroup>(filterGroups.length));
        }
        for (FilterGroup ele : filterGroups) {
            this.filterGroups.add(ele);
        }
        return this;
    }

    public TemplateVersionDefinition withFilterGroups(Collection<FilterGroup> filterGroups) {
        this.setFilterGroups(filterGroups);
        return this;
    }

    public List<ColumnConfiguration> getColumnConfigurations() {
        return this.columnConfigurations;
    }

    public void setColumnConfigurations(Collection<ColumnConfiguration> columnConfigurations) {
        if (columnConfigurations == null) {
            this.columnConfigurations = null;
            return;
        }
        this.columnConfigurations = new ArrayList<ColumnConfiguration>(columnConfigurations);
    }

    public TemplateVersionDefinition withColumnConfigurations(ColumnConfiguration ... columnConfigurations) {
        if (this.columnConfigurations == null) {
            this.setColumnConfigurations(new ArrayList<ColumnConfiguration>(columnConfigurations.length));
        }
        for (ColumnConfiguration ele : columnConfigurations) {
            this.columnConfigurations.add(ele);
        }
        return this;
    }

    public TemplateVersionDefinition withColumnConfigurations(Collection<ColumnConfiguration> columnConfigurations) {
        this.setColumnConfigurations(columnConfigurations);
        return this;
    }

    public void setAnalysisDefaults(AnalysisDefaults analysisDefaults) {
        this.analysisDefaults = analysisDefaults;
    }

    public AnalysisDefaults getAnalysisDefaults() {
        return this.analysisDefaults;
    }

    public TemplateVersionDefinition withAnalysisDefaults(AnalysisDefaults analysisDefaults) {
        this.setAnalysisDefaults(analysisDefaults);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDataSetConfigurations() != null) {
            sb.append("DataSetConfigurations: ").append(this.getDataSetConfigurations()).append(",");
        }
        if (this.getSheets() != null) {
            sb.append("Sheets: ").append(this.getSheets()).append(",");
        }
        if (this.getCalculatedFields() != null) {
            sb.append("CalculatedFields: ").append(this.getCalculatedFields()).append(",");
        }
        if (this.getParameterDeclarations() != null) {
            sb.append("ParameterDeclarations: ").append(this.getParameterDeclarations()).append(",");
        }
        if (this.getFilterGroups() != null) {
            sb.append("FilterGroups: ").append(this.getFilterGroups()).append(",");
        }
        if (this.getColumnConfigurations() != null) {
            sb.append("ColumnConfigurations: ").append(this.getColumnConfigurations()).append(",");
        }
        if (this.getAnalysisDefaults() != null) {
            sb.append("AnalysisDefaults: ").append(this.getAnalysisDefaults());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateVersionDefinition)) {
            return false;
        }
        TemplateVersionDefinition other = (TemplateVersionDefinition)obj;
        if (other.getDataSetConfigurations() == null ^ this.getDataSetConfigurations() == null) {
            return false;
        }
        if (other.getDataSetConfigurations() != null && !other.getDataSetConfigurations().equals(this.getDataSetConfigurations())) {
            return false;
        }
        if (other.getSheets() == null ^ this.getSheets() == null) {
            return false;
        }
        if (other.getSheets() != null && !other.getSheets().equals(this.getSheets())) {
            return false;
        }
        if (other.getCalculatedFields() == null ^ this.getCalculatedFields() == null) {
            return false;
        }
        if (other.getCalculatedFields() != null && !other.getCalculatedFields().equals(this.getCalculatedFields())) {
            return false;
        }
        if (other.getParameterDeclarations() == null ^ this.getParameterDeclarations() == null) {
            return false;
        }
        if (other.getParameterDeclarations() != null && !other.getParameterDeclarations().equals(this.getParameterDeclarations())) {
            return false;
        }
        if (other.getFilterGroups() == null ^ this.getFilterGroups() == null) {
            return false;
        }
        if (other.getFilterGroups() != null && !other.getFilterGroups().equals(this.getFilterGroups())) {
            return false;
        }
        if (other.getColumnConfigurations() == null ^ this.getColumnConfigurations() == null) {
            return false;
        }
        if (other.getColumnConfigurations() != null && !other.getColumnConfigurations().equals(this.getColumnConfigurations())) {
            return false;
        }
        if (other.getAnalysisDefaults() == null ^ this.getAnalysisDefaults() == null) {
            return false;
        }
        return other.getAnalysisDefaults() == null || other.getAnalysisDefaults().equals(this.getAnalysisDefaults());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDataSetConfigurations() == null ? 0 : this.getDataSetConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getSheets() == null ? 0 : this.getSheets().hashCode());
        hashCode = 31 * hashCode + (this.getCalculatedFields() == null ? 0 : this.getCalculatedFields().hashCode());
        hashCode = 31 * hashCode + (this.getParameterDeclarations() == null ? 0 : this.getParameterDeclarations().hashCode());
        hashCode = 31 * hashCode + (this.getFilterGroups() == null ? 0 : this.getFilterGroups().hashCode());
        hashCode = 31 * hashCode + (this.getColumnConfigurations() == null ? 0 : this.getColumnConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getAnalysisDefaults() == null ? 0 : this.getAnalysisDefaults().hashCode());
        return hashCode;
    }

    public TemplateVersionDefinition clone() {
        try {
            return (TemplateVersionDefinition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TemplateVersionDefinitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

