/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.ColumnGroupSchema;
import com.amazonaws.services.quicksight.model.DataSetSchema;
import com.amazonaws.services.quicksight.model.transform.DataSetConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DataSetConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String placeholder;
    private DataSetSchema dataSetSchema;
    private List<ColumnGroupSchema> columnGroupSchemaList;

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public DataSetConfiguration withPlaceholder(String placeholder) {
        this.setPlaceholder(placeholder);
        return this;
    }

    public void setDataSetSchema(DataSetSchema dataSetSchema) {
        this.dataSetSchema = dataSetSchema;
    }

    public DataSetSchema getDataSetSchema() {
        return this.dataSetSchema;
    }

    public DataSetConfiguration withDataSetSchema(DataSetSchema dataSetSchema) {
        this.setDataSetSchema(dataSetSchema);
        return this;
    }

    public List<ColumnGroupSchema> getColumnGroupSchemaList() {
        return this.columnGroupSchemaList;
    }

    public void setColumnGroupSchemaList(Collection<ColumnGroupSchema> columnGroupSchemaList) {
        if (columnGroupSchemaList == null) {
            this.columnGroupSchemaList = null;
            return;
        }
        this.columnGroupSchemaList = new ArrayList<ColumnGroupSchema>(columnGroupSchemaList);
    }

    public DataSetConfiguration withColumnGroupSchemaList(ColumnGroupSchema ... columnGroupSchemaList) {
        if (this.columnGroupSchemaList == null) {
            this.setColumnGroupSchemaList(new ArrayList<ColumnGroupSchema>(columnGroupSchemaList.length));
        }
        for (ColumnGroupSchema ele : columnGroupSchemaList) {
            this.columnGroupSchemaList.add(ele);
        }
        return this;
    }

    public DataSetConfiguration withColumnGroupSchemaList(Collection<ColumnGroupSchema> columnGroupSchemaList) {
        this.setColumnGroupSchemaList(columnGroupSchemaList);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPlaceholder() != null) {
            sb.append("Placeholder: ").append(this.getPlaceholder()).append(",");
        }
        if (this.getDataSetSchema() != null) {
            sb.append("DataSetSchema: ").append(this.getDataSetSchema()).append(",");
        }
        if (this.getColumnGroupSchemaList() != null) {
            sb.append("ColumnGroupSchemaList: ").append(this.getColumnGroupSchemaList());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSetConfiguration)) {
            return false;
        }
        DataSetConfiguration other = (DataSetConfiguration)obj;
        if (other.getPlaceholder() == null ^ this.getPlaceholder() == null) {
            return false;
        }
        if (other.getPlaceholder() != null && !other.getPlaceholder().equals(this.getPlaceholder())) {
            return false;
        }
        if (other.getDataSetSchema() == null ^ this.getDataSetSchema() == null) {
            return false;
        }
        if (other.getDataSetSchema() != null && !other.getDataSetSchema().equals(this.getDataSetSchema())) {
            return false;
        }
        if (other.getColumnGroupSchemaList() == null ^ this.getColumnGroupSchemaList() == null) {
            return false;
        }
        return other.getColumnGroupSchemaList() == null || other.getColumnGroupSchemaList().equals(this.getColumnGroupSchemaList());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPlaceholder() == null ? 0 : this.getPlaceholder().hashCode());
        hashCode = 31 * hashCode + (this.getDataSetSchema() == null ? 0 : this.getDataSetSchema().hashCode());
        hashCode = 31 * hashCode + (this.getColumnGroupSchemaList() == null ? 0 : this.getColumnGroupSchemaList().hashCode());
        return hashCode;
    }

    public DataSetConfiguration clone() {
        try {
            return (DataSetConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DataSetConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

