/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.quicksight.model.TemplateVersion;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class TemplateVersionMarshaller {
    private static final MarshallingInfo<Date> CREATEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<List> ERRORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Errors").build();
    private static final MarshallingInfo<Long> VERSIONNUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VersionNumber").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<List> DATASETCONFIGURATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataSetConfigurations").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<String> SOURCEENTITYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceEntityArn").build();
    private static final TemplateVersionMarshaller instance = new TemplateVersionMarshaller();

    public static TemplateVersionMarshaller getInstance() {
        return instance;
    }

    public void marshall(TemplateVersion templateVersion, ProtocolMarshaller protocolMarshaller) {
        if (templateVersion == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)templateVersion.getCreatedTime(), CREATEDTIME_BINDING);
            protocolMarshaller.marshall(templateVersion.getErrors(), ERRORS_BINDING);
            protocolMarshaller.marshall((Object)templateVersion.getVersionNumber(), VERSIONNUMBER_BINDING);
            protocolMarshaller.marshall((Object)templateVersion.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall(templateVersion.getDataSetConfigurations(), DATASETCONFIGURATIONS_BINDING);
            protocolMarshaller.marshall((Object)templateVersion.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)templateVersion.getSourceEntityArn(), SOURCEENTITYARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

