/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.qconnect.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.qconnect.model.Document;

@SdkInternalApi
public class DocumentMarshaller {
    private static final MarshallingInfo<StructuredPojo> CONTENTREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("contentReference").build();
    private static final MarshallingInfo<StructuredPojo> EXCERPT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("excerpt").build();
    private static final MarshallingInfo<StructuredPojo> TITLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("title").build();
    private static final DocumentMarshaller instance = new DocumentMarshaller();

    public static DocumentMarshaller getInstance() {
        return instance;
    }

    public void marshall(Document document, ProtocolMarshaller protocolMarshaller) {
        if (document == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)document.getContentReference(), CONTENTREFERENCE_BINDING);
            protocolMarshaller.marshall((Object)document.getExcerpt(), EXCERPT_BINDING);
            protocolMarshaller.marshall((Object)document.getTitle(), TITLE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

