/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.qbusiness.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.qbusiness.model.Message;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class MessageMarshaller {
    private static final MarshallingInfo<String> MESSAGEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("messageId").build();
    private static final MarshallingInfo<String> BODY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("body").build();
    private static final MarshallingInfo<Date> TIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("time").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").build();
    private static final MarshallingInfo<List> ATTACHMENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("attachments").build();
    private static final MarshallingInfo<List> SOURCEATTRIBUTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sourceAttribution").build();
    private static final MarshallingInfo<StructuredPojo> ACTIONREVIEW_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("actionReview").build();
    private static final MessageMarshaller instance = new MessageMarshaller();

    public static MessageMarshaller getInstance() {
        return instance;
    }

    public void marshall(Message message, ProtocolMarshaller protocolMarshaller) {
        if (message == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)message.getMessageId(), MESSAGEID_BINDING);
            protocolMarshaller.marshall((Object)message.getBody(), BODY_BINDING);
            protocolMarshaller.marshall((Object)message.getTime(), TIME_BINDING);
            protocolMarshaller.marshall((Object)message.getType(), TYPE_BINDING);
            protocolMarshaller.marshall(message.getAttachments(), ATTACHMENTS_BINDING);
            protocolMarshaller.marshall(message.getSourceAttribution(), SOURCEATTRIBUTION_BINDING);
            protocolMarshaller.marshall((Object)message.getActionReview(), ACTIONREVIEW_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

