/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.qbusiness.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.qbusiness.model.DocumentAttributeValue;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class DocumentAttributeValueMarshaller {
    private static final MarshallingInfo<String> STRINGVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stringValue").build();
    private static final MarshallingInfo<List> STRINGLISTVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stringListValue").build();
    private static final MarshallingInfo<Long> LONGVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("longValue").build();
    private static final MarshallingInfo<Date> DATEVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dateValue").timestampFormat("unixTimestamp").build();
    private static final DocumentAttributeValueMarshaller instance = new DocumentAttributeValueMarshaller();

    public static DocumentAttributeValueMarshaller getInstance() {
        return instance;
    }

    public void marshall(DocumentAttributeValue documentAttributeValue, ProtocolMarshaller protocolMarshaller) {
        if (documentAttributeValue == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)documentAttributeValue.getStringValue(), STRINGVALUE_BINDING);
            protocolMarshaller.marshall(documentAttributeValue.getStringListValue(), STRINGLISTVALUE_BINDING);
            protocolMarshaller.marshall((Object)documentAttributeValue.getLongValue(), LONGVALUE_BINDING);
            protocolMarshaller.marshall((Object)documentAttributeValue.getDateValue(), DATEVALUE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

