/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.qbusiness.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.qbusiness.model.DataSource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListDataSourcesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<DataSource> dataSources;
    private String nextToken;

    public List<DataSource> getDataSources() {
        return this.dataSources;
    }

    public void setDataSources(Collection<DataSource> dataSources) {
        if (dataSources == null) {
            this.dataSources = null;
            return;
        }
        this.dataSources = new ArrayList<DataSource>(dataSources);
    }

    public ListDataSourcesResult withDataSources(DataSource ... dataSources) {
        if (this.dataSources == null) {
            this.setDataSources(new ArrayList<DataSource>(dataSources.length));
        }
        for (DataSource ele : dataSources) {
            this.dataSources.add(ele);
        }
        return this;
    }

    public ListDataSourcesResult withDataSources(Collection<DataSource> dataSources) {
        this.setDataSources(dataSources);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListDataSourcesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDataSources() != null) {
            sb.append("DataSources: ").append(this.getDataSources()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataSourcesResult)) {
            return false;
        }
        ListDataSourcesResult other = (ListDataSourcesResult)obj;
        if (other.getDataSources() == null ^ this.getDataSources() == null) {
            return false;
        }
        if (other.getDataSources() != null && !other.getDataSources().equals(this.getDataSources())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDataSources() == null ? 0 : this.getDataSources().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListDataSourcesResult clone() {
        try {
            return (ListDataSourcesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

