/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.proton.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.proton.model.SyncBlocker;
import com.amazonaws.services.proton.model.transform.ServiceSyncBlockerSummaryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ServiceSyncBlockerSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private List<SyncBlocker> latestBlockers;
    private String serviceInstanceName;
    private String serviceName;

    public List<SyncBlocker> getLatestBlockers() {
        return this.latestBlockers;
    }

    public void setLatestBlockers(Collection<SyncBlocker> latestBlockers) {
        if (latestBlockers == null) {
            this.latestBlockers = null;
            return;
        }
        this.latestBlockers = new ArrayList<SyncBlocker>(latestBlockers);
    }

    public ServiceSyncBlockerSummary withLatestBlockers(SyncBlocker ... latestBlockers) {
        if (this.latestBlockers == null) {
            this.setLatestBlockers(new ArrayList<SyncBlocker>(latestBlockers.length));
        }
        for (SyncBlocker ele : latestBlockers) {
            this.latestBlockers.add(ele);
        }
        return this;
    }

    public ServiceSyncBlockerSummary withLatestBlockers(Collection<SyncBlocker> latestBlockers) {
        this.setLatestBlockers(latestBlockers);
        return this;
    }

    public void setServiceInstanceName(String serviceInstanceName) {
        this.serviceInstanceName = serviceInstanceName;
    }

    public String getServiceInstanceName() {
        return this.serviceInstanceName;
    }

    public ServiceSyncBlockerSummary withServiceInstanceName(String serviceInstanceName) {
        this.setServiceInstanceName(serviceInstanceName);
        return this;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public ServiceSyncBlockerSummary withServiceName(String serviceName) {
        this.setServiceName(serviceName);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLatestBlockers() != null) {
            sb.append("LatestBlockers: ").append(this.getLatestBlockers()).append(",");
        }
        if (this.getServiceInstanceName() != null) {
            sb.append("ServiceInstanceName: ").append(this.getServiceInstanceName()).append(",");
        }
        if (this.getServiceName() != null) {
            sb.append("ServiceName: ").append(this.getServiceName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceSyncBlockerSummary)) {
            return false;
        }
        ServiceSyncBlockerSummary other = (ServiceSyncBlockerSummary)obj;
        if (other.getLatestBlockers() == null ^ this.getLatestBlockers() == null) {
            return false;
        }
        if (other.getLatestBlockers() != null && !other.getLatestBlockers().equals(this.getLatestBlockers())) {
            return false;
        }
        if (other.getServiceInstanceName() == null ^ this.getServiceInstanceName() == null) {
            return false;
        }
        if (other.getServiceInstanceName() != null && !other.getServiceInstanceName().equals(this.getServiceInstanceName())) {
            return false;
        }
        if (other.getServiceName() == null ^ this.getServiceName() == null) {
            return false;
        }
        return other.getServiceName() == null || other.getServiceName().equals(this.getServiceName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLatestBlockers() == null ? 0 : this.getLatestBlockers().hashCode());
        hashCode = 31 * hashCode + (this.getServiceInstanceName() == null ? 0 : this.getServiceInstanceName().hashCode());
        hashCode = 31 * hashCode + (this.getServiceName() == null ? 0 : this.getServiceName().hashCode());
        return hashCode;
    }

    public ServiceSyncBlockerSummary clone() {
        try {
            return (ServiceSyncBlockerSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ServiceSyncBlockerSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

