/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.proton.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.proton.model.RepositorySummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListRepositoriesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<RepositorySummary> repositories;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListRepositoriesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<RepositorySummary> getRepositories() {
        return this.repositories;
    }

    public void setRepositories(Collection<RepositorySummary> repositories) {
        if (repositories == null) {
            this.repositories = null;
            return;
        }
        this.repositories = new ArrayList<RepositorySummary>(repositories);
    }

    public ListRepositoriesResult withRepositories(RepositorySummary ... repositories) {
        if (this.repositories == null) {
            this.setRepositories(new ArrayList<RepositorySummary>(repositories.length));
        }
        for (RepositorySummary ele : repositories) {
            this.repositories.add(ele);
        }
        return this;
    }

    public ListRepositoriesResult withRepositories(Collection<RepositorySummary> repositories) {
        this.setRepositories(repositories);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getRepositories() != null) {
            sb.append("Repositories: ").append(this.getRepositories());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRepositoriesResult)) {
            return false;
        }
        ListRepositoriesResult other = (ListRepositoriesResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getRepositories() == null ^ this.getRepositories() == null) {
            return false;
        }
        return other.getRepositories() == null || other.getRepositories().equals(this.getRepositories());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getRepositories() == null ? 0 : this.getRepositories().hashCode());
        return hashCode;
    }

    public ListRepositoriesResult clone() {
        try {
            return (ListRepositoriesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

