/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.prometheus;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.prometheus.AmazonPrometheus;
import com.amazonaws.services.prometheus.AmazonPrometheusClientBuilder;
import com.amazonaws.services.prometheus.model.AmazonPrometheusException;
import com.amazonaws.services.prometheus.model.CreateAlertManagerDefinitionRequest;
import com.amazonaws.services.prometheus.model.CreateAlertManagerDefinitionResult;
import com.amazonaws.services.prometheus.model.CreateLoggingConfigurationRequest;
import com.amazonaws.services.prometheus.model.CreateLoggingConfigurationResult;
import com.amazonaws.services.prometheus.model.CreateRuleGroupsNamespaceRequest;
import com.amazonaws.services.prometheus.model.CreateRuleGroupsNamespaceResult;
import com.amazonaws.services.prometheus.model.CreateWorkspaceRequest;
import com.amazonaws.services.prometheus.model.CreateWorkspaceResult;
import com.amazonaws.services.prometheus.model.DeleteAlertManagerDefinitionRequest;
import com.amazonaws.services.prometheus.model.DeleteAlertManagerDefinitionResult;
import com.amazonaws.services.prometheus.model.DeleteLoggingConfigurationRequest;
import com.amazonaws.services.prometheus.model.DeleteLoggingConfigurationResult;
import com.amazonaws.services.prometheus.model.DeleteRuleGroupsNamespaceRequest;
import com.amazonaws.services.prometheus.model.DeleteRuleGroupsNamespaceResult;
import com.amazonaws.services.prometheus.model.DeleteWorkspaceRequest;
import com.amazonaws.services.prometheus.model.DeleteWorkspaceResult;
import com.amazonaws.services.prometheus.model.DescribeAlertManagerDefinitionRequest;
import com.amazonaws.services.prometheus.model.DescribeAlertManagerDefinitionResult;
import com.amazonaws.services.prometheus.model.DescribeLoggingConfigurationRequest;
import com.amazonaws.services.prometheus.model.DescribeLoggingConfigurationResult;
import com.amazonaws.services.prometheus.model.DescribeRuleGroupsNamespaceRequest;
import com.amazonaws.services.prometheus.model.DescribeRuleGroupsNamespaceResult;
import com.amazonaws.services.prometheus.model.DescribeWorkspaceRequest;
import com.amazonaws.services.prometheus.model.DescribeWorkspaceResult;
import com.amazonaws.services.prometheus.model.ListRuleGroupsNamespacesRequest;
import com.amazonaws.services.prometheus.model.ListRuleGroupsNamespacesResult;
import com.amazonaws.services.prometheus.model.ListTagsForResourceRequest;
import com.amazonaws.services.prometheus.model.ListTagsForResourceResult;
import com.amazonaws.services.prometheus.model.ListWorkspacesRequest;
import com.amazonaws.services.prometheus.model.ListWorkspacesResult;
import com.amazonaws.services.prometheus.model.PutAlertManagerDefinitionRequest;
import com.amazonaws.services.prometheus.model.PutAlertManagerDefinitionResult;
import com.amazonaws.services.prometheus.model.PutRuleGroupsNamespaceRequest;
import com.amazonaws.services.prometheus.model.PutRuleGroupsNamespaceResult;
import com.amazonaws.services.prometheus.model.TagResourceRequest;
import com.amazonaws.services.prometheus.model.TagResourceResult;
import com.amazonaws.services.prometheus.model.UntagResourceRequest;
import com.amazonaws.services.prometheus.model.UntagResourceResult;
import com.amazonaws.services.prometheus.model.UpdateLoggingConfigurationRequest;
import com.amazonaws.services.prometheus.model.UpdateLoggingConfigurationResult;
import com.amazonaws.services.prometheus.model.UpdateWorkspaceAliasRequest;
import com.amazonaws.services.prometheus.model.UpdateWorkspaceAliasResult;
import com.amazonaws.services.prometheus.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.prometheus.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.prometheus.model.transform.CreateAlertManagerDefinitionRequestProtocolMarshaller;
import com.amazonaws.services.prometheus.model.transform.CreateAlertManagerDefinitionResultJsonUnmarshaller;
import com.amazonaws.services.prometheus.model.transform.CreateLoggingConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.prometheus.model.transform.CreateLoggingConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.prometheus.model.transform.CreateRuleGroupsNamespaceRequestProtocolMarshaller;
import com.amazonaws.services.prometheus.model.transform.CreateRuleGroupsNamespaceResultJsonUnmarshaller;
import com.amazonaws.services.prometheus.model.transform.CreateWorkspaceRequestProtocolMarshaller;
import com.amazonaws.services.prometheus.model.transform.CreateWorkspaceResultJsonUnmarshaller;
import com.amazonaws.services.prometheus.model.transform.DeleteAlertManagerDefinitionRequestProtocolMarshaller;
import com.amazonaws.services.prometheus.model.transform.DeleteAlertManagerDefinitionResultJsonUnmarshaller;
import com.amazonaws.services.prometheus.model.transform.DeleteLoggingConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.prometheus.model.transform.DeleteLoggingConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.prometheus.model.transform.DeleteRuleGroupsNamespaceRequestProtocolMarshaller;
import com.amazonaws.services.prometheus.model.transform.DeleteRuleGroupsNamespaceResultJsonUnmarshaller;
import com.amazonaws.services.prometheus.model.transform.DeleteWorkspaceRequestProtocolMarshaller;
import com.amazonaws.services.prometheus.model.transform.DeleteWorkspaceResultJsonUnmarshaller;
import com.amazonaws.services.prometheus.model.transform.DescribeAlertManagerDefinitionRequestProtocolMarshaller;
import com.amazonaws.services.prometheus.model.transform.DescribeAlertManagerDefinitionResultJsonUnmarshaller;
import com.amazonaws.services.prometheus.model.transform.DescribeLoggingConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.prometheus.model.transform.DescribeLoggingConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.prometheus.model.transform.DescribeRuleGroupsNamespaceRequestProtocolMarshaller;
import com.amazonaws.services.prometheus.model.transform.DescribeRuleGroupsNamespaceResultJsonUnmarshaller;
import com.amazonaws.services.prometheus.model.transform.DescribeWorkspaceRequestProtocolMarshaller;
import com.amazonaws.services.prometheus.model.transform.DescribeWorkspaceResultJsonUnmarshaller;
import com.amazonaws.services.prometheus.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.prometheus.model.transform.ListRuleGroupsNamespacesRequestProtocolMarshaller;
import com.amazonaws.services.prometheus.model.transform.ListRuleGroupsNamespacesResultJsonUnmarshaller;
import com.amazonaws.services.prometheus.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.prometheus.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.prometheus.model.transform.ListWorkspacesRequestProtocolMarshaller;
import com.amazonaws.services.prometheus.model.transform.ListWorkspacesResultJsonUnmarshaller;
import com.amazonaws.services.prometheus.model.transform.PutAlertManagerDefinitionRequestProtocolMarshaller;
import com.amazonaws.services.prometheus.model.transform.PutAlertManagerDefinitionResultJsonUnmarshaller;
import com.amazonaws.services.prometheus.model.transform.PutRuleGroupsNamespaceRequestProtocolMarshaller;
import com.amazonaws.services.prometheus.model.transform.PutRuleGroupsNamespaceResultJsonUnmarshaller;
import com.amazonaws.services.prometheus.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.prometheus.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.prometheus.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.prometheus.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.prometheus.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.prometheus.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.prometheus.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.prometheus.model.transform.UpdateLoggingConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.prometheus.model.transform.UpdateLoggingConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.prometheus.model.transform.UpdateWorkspaceAliasRequestProtocolMarshaller;
import com.amazonaws.services.prometheus.model.transform.UpdateWorkspaceAliasResultJsonUnmarshaller;
import com.amazonaws.services.prometheus.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.services.prometheus.waiters.AmazonPrometheusWaiters;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonPrometheusClient
extends AmazonWebServiceClient
implements AmazonPrometheus {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonPrometheus.class);
    private static final String DEFAULT_SIGNING_NAME = "aps";
    private volatile AmazonPrometheusWaiters waiters;
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonPrometheusException.class));

    public static AmazonPrometheusClientBuilder builder() {
        return AmazonPrometheusClientBuilder.standard();
    }

    AmazonPrometheusClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonPrometheusClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("aps.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/prometheus/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/prometheus/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateAlertManagerDefinitionResult createAlertManagerDefinition(CreateAlertManagerDefinitionRequest request) {
        request = (CreateAlertManagerDefinitionRequest)this.beforeClientExecution(request);
        return this.executeCreateAlertManagerDefinition(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateAlertManagerDefinitionResult executeCreateAlertManagerDefinition(CreateAlertManagerDefinitionRequest createAlertManagerDefinitionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createAlertManagerDefinitionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateAlertManagerDefinitionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateAlertManagerDefinitionRequestProtocolMarshaller(protocolFactory).marshall((CreateAlertManagerDefinitionRequest)super.beforeMarshalling((AmazonWebServiceRequest)createAlertManagerDefinitionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"amp");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateAlertManagerDefinition");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateAlertManagerDefinitionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateAlertManagerDefinitionResult createAlertManagerDefinitionResult = (CreateAlertManagerDefinitionResult)response.getAwsResponse();
            return createAlertManagerDefinitionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateLoggingConfigurationResult createLoggingConfiguration(CreateLoggingConfigurationRequest request) {
        request = (CreateLoggingConfigurationRequest)this.beforeClientExecution(request);
        return this.executeCreateLoggingConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateLoggingConfigurationResult executeCreateLoggingConfiguration(CreateLoggingConfigurationRequest createLoggingConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createLoggingConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateLoggingConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateLoggingConfigurationRequestProtocolMarshaller(protocolFactory).marshall((CreateLoggingConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)createLoggingConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"amp");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateLoggingConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateLoggingConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateLoggingConfigurationResult createLoggingConfigurationResult = (CreateLoggingConfigurationResult)response.getAwsResponse();
            return createLoggingConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateRuleGroupsNamespaceResult createRuleGroupsNamespace(CreateRuleGroupsNamespaceRequest request) {
        request = (CreateRuleGroupsNamespaceRequest)this.beforeClientExecution(request);
        return this.executeCreateRuleGroupsNamespace(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateRuleGroupsNamespaceResult executeCreateRuleGroupsNamespace(CreateRuleGroupsNamespaceRequest createRuleGroupsNamespaceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createRuleGroupsNamespaceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateRuleGroupsNamespaceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateRuleGroupsNamespaceRequestProtocolMarshaller(protocolFactory).marshall((CreateRuleGroupsNamespaceRequest)super.beforeMarshalling((AmazonWebServiceRequest)createRuleGroupsNamespaceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"amp");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateRuleGroupsNamespace");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateRuleGroupsNamespaceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateRuleGroupsNamespaceResult createRuleGroupsNamespaceResult = (CreateRuleGroupsNamespaceResult)response.getAwsResponse();
            return createRuleGroupsNamespaceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateWorkspaceResult createWorkspace(CreateWorkspaceRequest request) {
        request = (CreateWorkspaceRequest)this.beforeClientExecution(request);
        return this.executeCreateWorkspace(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateWorkspaceResult executeCreateWorkspace(CreateWorkspaceRequest createWorkspaceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createWorkspaceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateWorkspaceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateWorkspaceRequestProtocolMarshaller(protocolFactory).marshall((CreateWorkspaceRequest)super.beforeMarshalling((AmazonWebServiceRequest)createWorkspaceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"amp");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateWorkspace");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateWorkspaceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateWorkspaceResult createWorkspaceResult = (CreateWorkspaceResult)response.getAwsResponse();
            return createWorkspaceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteAlertManagerDefinitionResult deleteAlertManagerDefinition(DeleteAlertManagerDefinitionRequest request) {
        request = (DeleteAlertManagerDefinitionRequest)this.beforeClientExecution(request);
        return this.executeDeleteAlertManagerDefinition(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteAlertManagerDefinitionResult executeDeleteAlertManagerDefinition(DeleteAlertManagerDefinitionRequest deleteAlertManagerDefinitionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAlertManagerDefinitionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteAlertManagerDefinitionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteAlertManagerDefinitionRequestProtocolMarshaller(protocolFactory).marshall((DeleteAlertManagerDefinitionRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteAlertManagerDefinitionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"amp");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteAlertManagerDefinition");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteAlertManagerDefinitionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteAlertManagerDefinitionResult deleteAlertManagerDefinitionResult = (DeleteAlertManagerDefinitionResult)response.getAwsResponse();
            return deleteAlertManagerDefinitionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteLoggingConfigurationResult deleteLoggingConfiguration(DeleteLoggingConfigurationRequest request) {
        request = (DeleteLoggingConfigurationRequest)this.beforeClientExecution(request);
        return this.executeDeleteLoggingConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteLoggingConfigurationResult executeDeleteLoggingConfiguration(DeleteLoggingConfigurationRequest deleteLoggingConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteLoggingConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteLoggingConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteLoggingConfigurationRequestProtocolMarshaller(protocolFactory).marshall((DeleteLoggingConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteLoggingConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"amp");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteLoggingConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteLoggingConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteLoggingConfigurationResult deleteLoggingConfigurationResult = (DeleteLoggingConfigurationResult)response.getAwsResponse();
            return deleteLoggingConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteRuleGroupsNamespaceResult deleteRuleGroupsNamespace(DeleteRuleGroupsNamespaceRequest request) {
        request = (DeleteRuleGroupsNamespaceRequest)this.beforeClientExecution(request);
        return this.executeDeleteRuleGroupsNamespace(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteRuleGroupsNamespaceResult executeDeleteRuleGroupsNamespace(DeleteRuleGroupsNamespaceRequest deleteRuleGroupsNamespaceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteRuleGroupsNamespaceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteRuleGroupsNamespaceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteRuleGroupsNamespaceRequestProtocolMarshaller(protocolFactory).marshall((DeleteRuleGroupsNamespaceRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteRuleGroupsNamespaceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"amp");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteRuleGroupsNamespace");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteRuleGroupsNamespaceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteRuleGroupsNamespaceResult deleteRuleGroupsNamespaceResult = (DeleteRuleGroupsNamespaceResult)response.getAwsResponse();
            return deleteRuleGroupsNamespaceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteWorkspaceResult deleteWorkspace(DeleteWorkspaceRequest request) {
        request = (DeleteWorkspaceRequest)this.beforeClientExecution(request);
        return this.executeDeleteWorkspace(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteWorkspaceResult executeDeleteWorkspace(DeleteWorkspaceRequest deleteWorkspaceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteWorkspaceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteWorkspaceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteWorkspaceRequestProtocolMarshaller(protocolFactory).marshall((DeleteWorkspaceRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteWorkspaceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"amp");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteWorkspace");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteWorkspaceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteWorkspaceResult deleteWorkspaceResult = (DeleteWorkspaceResult)response.getAwsResponse();
            return deleteWorkspaceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeAlertManagerDefinitionResult describeAlertManagerDefinition(DescribeAlertManagerDefinitionRequest request) {
        request = (DescribeAlertManagerDefinitionRequest)this.beforeClientExecution(request);
        return this.executeDescribeAlertManagerDefinition(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeAlertManagerDefinitionResult executeDescribeAlertManagerDefinition(DescribeAlertManagerDefinitionRequest describeAlertManagerDefinitionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAlertManagerDefinitionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAlertManagerDefinitionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAlertManagerDefinitionRequestProtocolMarshaller(protocolFactory).marshall((DescribeAlertManagerDefinitionRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeAlertManagerDefinitionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"amp");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeAlertManagerDefinition");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeAlertManagerDefinitionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeAlertManagerDefinitionResult describeAlertManagerDefinitionResult = (DescribeAlertManagerDefinitionResult)response.getAwsResponse();
            return describeAlertManagerDefinitionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeLoggingConfigurationResult describeLoggingConfiguration(DescribeLoggingConfigurationRequest request) {
        request = (DescribeLoggingConfigurationRequest)this.beforeClientExecution(request);
        return this.executeDescribeLoggingConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeLoggingConfigurationResult executeDescribeLoggingConfiguration(DescribeLoggingConfigurationRequest describeLoggingConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeLoggingConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeLoggingConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeLoggingConfigurationRequestProtocolMarshaller(protocolFactory).marshall((DescribeLoggingConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeLoggingConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"amp");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeLoggingConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeLoggingConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeLoggingConfigurationResult describeLoggingConfigurationResult = (DescribeLoggingConfigurationResult)response.getAwsResponse();
            return describeLoggingConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeRuleGroupsNamespaceResult describeRuleGroupsNamespace(DescribeRuleGroupsNamespaceRequest request) {
        request = (DescribeRuleGroupsNamespaceRequest)this.beforeClientExecution(request);
        return this.executeDescribeRuleGroupsNamespace(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeRuleGroupsNamespaceResult executeDescribeRuleGroupsNamespace(DescribeRuleGroupsNamespaceRequest describeRuleGroupsNamespaceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeRuleGroupsNamespaceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeRuleGroupsNamespaceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeRuleGroupsNamespaceRequestProtocolMarshaller(protocolFactory).marshall((DescribeRuleGroupsNamespaceRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeRuleGroupsNamespaceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"amp");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeRuleGroupsNamespace");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeRuleGroupsNamespaceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeRuleGroupsNamespaceResult describeRuleGroupsNamespaceResult = (DescribeRuleGroupsNamespaceResult)response.getAwsResponse();
            return describeRuleGroupsNamespaceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeWorkspaceResult describeWorkspace(DescribeWorkspaceRequest request) {
        request = (DescribeWorkspaceRequest)this.beforeClientExecution(request);
        return this.executeDescribeWorkspace(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeWorkspaceResult executeDescribeWorkspace(DescribeWorkspaceRequest describeWorkspaceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeWorkspaceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeWorkspaceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeWorkspaceRequestProtocolMarshaller(protocolFactory).marshall((DescribeWorkspaceRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeWorkspaceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"amp");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeWorkspace");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeWorkspaceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeWorkspaceResult describeWorkspaceResult = (DescribeWorkspaceResult)response.getAwsResponse();
            return describeWorkspaceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListRuleGroupsNamespacesResult listRuleGroupsNamespaces(ListRuleGroupsNamespacesRequest request) {
        request = (ListRuleGroupsNamespacesRequest)this.beforeClientExecution(request);
        return this.executeListRuleGroupsNamespaces(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListRuleGroupsNamespacesResult executeListRuleGroupsNamespaces(ListRuleGroupsNamespacesRequest listRuleGroupsNamespacesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listRuleGroupsNamespacesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListRuleGroupsNamespacesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListRuleGroupsNamespacesRequestProtocolMarshaller(protocolFactory).marshall((ListRuleGroupsNamespacesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listRuleGroupsNamespacesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"amp");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListRuleGroupsNamespaces");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListRuleGroupsNamespacesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListRuleGroupsNamespacesResult listRuleGroupsNamespacesResult = (ListRuleGroupsNamespacesResult)response.getAwsResponse();
            return listRuleGroupsNamespacesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"amp");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListWorkspacesResult listWorkspaces(ListWorkspacesRequest request) {
        request = (ListWorkspacesRequest)this.beforeClientExecution(request);
        return this.executeListWorkspaces(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListWorkspacesResult executeListWorkspaces(ListWorkspacesRequest listWorkspacesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listWorkspacesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListWorkspacesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListWorkspacesRequestProtocolMarshaller(protocolFactory).marshall((ListWorkspacesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listWorkspacesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"amp");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListWorkspaces");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListWorkspacesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListWorkspacesResult listWorkspacesResult = (ListWorkspacesResult)response.getAwsResponse();
            return listWorkspacesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutAlertManagerDefinitionResult putAlertManagerDefinition(PutAlertManagerDefinitionRequest request) {
        request = (PutAlertManagerDefinitionRequest)this.beforeClientExecution(request);
        return this.executePutAlertManagerDefinition(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutAlertManagerDefinitionResult executePutAlertManagerDefinition(PutAlertManagerDefinitionRequest putAlertManagerDefinitionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putAlertManagerDefinitionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutAlertManagerDefinitionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutAlertManagerDefinitionRequestProtocolMarshaller(protocolFactory).marshall((PutAlertManagerDefinitionRequest)super.beforeMarshalling((AmazonWebServiceRequest)putAlertManagerDefinitionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"amp");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutAlertManagerDefinition");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutAlertManagerDefinitionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutAlertManagerDefinitionResult putAlertManagerDefinitionResult = (PutAlertManagerDefinitionResult)response.getAwsResponse();
            return putAlertManagerDefinitionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutRuleGroupsNamespaceResult putRuleGroupsNamespace(PutRuleGroupsNamespaceRequest request) {
        request = (PutRuleGroupsNamespaceRequest)this.beforeClientExecution(request);
        return this.executePutRuleGroupsNamespace(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutRuleGroupsNamespaceResult executePutRuleGroupsNamespace(PutRuleGroupsNamespaceRequest putRuleGroupsNamespaceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putRuleGroupsNamespaceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutRuleGroupsNamespaceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutRuleGroupsNamespaceRequestProtocolMarshaller(protocolFactory).marshall((PutRuleGroupsNamespaceRequest)super.beforeMarshalling((AmazonWebServiceRequest)putRuleGroupsNamespaceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"amp");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutRuleGroupsNamespace");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutRuleGroupsNamespaceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutRuleGroupsNamespaceResult putRuleGroupsNamespaceResult = (PutRuleGroupsNamespaceResult)response.getAwsResponse();
            return putRuleGroupsNamespaceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"amp");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"amp");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateLoggingConfigurationResult updateLoggingConfiguration(UpdateLoggingConfigurationRequest request) {
        request = (UpdateLoggingConfigurationRequest)this.beforeClientExecution(request);
        return this.executeUpdateLoggingConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateLoggingConfigurationResult executeUpdateLoggingConfiguration(UpdateLoggingConfigurationRequest updateLoggingConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateLoggingConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateLoggingConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateLoggingConfigurationRequestProtocolMarshaller(protocolFactory).marshall((UpdateLoggingConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateLoggingConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"amp");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateLoggingConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateLoggingConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateLoggingConfigurationResult updateLoggingConfigurationResult = (UpdateLoggingConfigurationResult)response.getAwsResponse();
            return updateLoggingConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateWorkspaceAliasResult updateWorkspaceAlias(UpdateWorkspaceAliasRequest request) {
        request = (UpdateWorkspaceAliasRequest)this.beforeClientExecution(request);
        return this.executeUpdateWorkspaceAlias(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateWorkspaceAliasResult executeUpdateWorkspaceAlias(UpdateWorkspaceAliasRequest updateWorkspaceAliasRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateWorkspaceAliasRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateWorkspaceAliasRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateWorkspaceAliasRequestProtocolMarshaller(protocolFactory).marshall((UpdateWorkspaceAliasRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateWorkspaceAliasRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"amp");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateWorkspaceAlias");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateWorkspaceAliasResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateWorkspaceAliasResult updateWorkspaceAliasResult = (UpdateWorkspaceAliasResult)response.getAwsResponse();
            return updateWorkspaceAliasResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AmazonPrometheusWaiters waiters() {
        if (this.waiters == null) {
            AmazonPrometheusClient amazonPrometheusClient = this;
            synchronized (amazonPrometheusClient) {
                if (this.waiters == null) {
                    this.waiters = new AmazonPrometheusWaiters(this);
                }
            }
        }
        return this.waiters;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.waiters != null) {
            this.waiters.shutdown();
        }
    }
}

