/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.prometheus.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * <p>
 * Represents the output of a DescribeLoggingConfiguration operation.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/DescribeLoggingConfiguration" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DescribeLoggingConfigurationResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * Metadata object containing information about the logging configuration of a workspace.
     * </p>
     */
    private LoggingConfigurationMetadata loggingConfiguration;

    /**
     * <p>
     * Metadata object containing information about the logging configuration of a workspace.
     * </p>
     * 
     * @param loggingConfiguration
     *        Metadata object containing information about the logging configuration of a workspace.
     */

    public void setLoggingConfiguration(LoggingConfigurationMetadata loggingConfiguration) {
        this.loggingConfiguration = loggingConfiguration;
    }

    /**
     * <p>
     * Metadata object containing information about the logging configuration of a workspace.
     * </p>
     * 
     * @return Metadata object containing information about the logging configuration of a workspace.
     */

    public LoggingConfigurationMetadata getLoggingConfiguration() {
        return this.loggingConfiguration;
    }

    /**
     * <p>
     * Metadata object containing information about the logging configuration of a workspace.
     * </p>
     * 
     * @param loggingConfiguration
     *        Metadata object containing information about the logging configuration of a workspace.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeLoggingConfigurationResult withLoggingConfiguration(LoggingConfigurationMetadata loggingConfiguration) {
        setLoggingConfiguration(loggingConfiguration);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getLoggingConfiguration() != null)
            sb.append("LoggingConfiguration: ").append(getLoggingConfiguration());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DescribeLoggingConfigurationResult == false)
            return false;
        DescribeLoggingConfigurationResult other = (DescribeLoggingConfigurationResult) obj;
        if (other.getLoggingConfiguration() == null ^ this.getLoggingConfiguration() == null)
            return false;
        if (other.getLoggingConfiguration() != null && other.getLoggingConfiguration().equals(this.getLoggingConfiguration()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getLoggingConfiguration() == null) ? 0 : getLoggingConfiguration().hashCode());
        return hashCode;
    }

    @Override
    public DescribeLoggingConfigurationResult clone() {
        try {
            return (DescribeLoggingConfigurationResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
