/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pinpoint.model.EndpointTypesElement;
import com.amazonaws.services.pinpoint.model.transform.CustomDeliveryConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CustomDeliveryConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String deliveryUri;
    private List<String> endpointTypes;

    public void setDeliveryUri(String deliveryUri) {
        this.deliveryUri = deliveryUri;
    }

    public String getDeliveryUri() {
        return this.deliveryUri;
    }

    public CustomDeliveryConfiguration withDeliveryUri(String deliveryUri) {
        this.setDeliveryUri(deliveryUri);
        return this;
    }

    public List<String> getEndpointTypes() {
        return this.endpointTypes;
    }

    public void setEndpointTypes(Collection<String> endpointTypes) {
        if (endpointTypes == null) {
            this.endpointTypes = null;
            return;
        }
        this.endpointTypes = new ArrayList<String>(endpointTypes);
    }

    public CustomDeliveryConfiguration withEndpointTypes(String ... endpointTypes) {
        if (this.endpointTypes == null) {
            this.setEndpointTypes(new ArrayList<String>(endpointTypes.length));
        }
        for (String ele : endpointTypes) {
            this.endpointTypes.add(ele);
        }
        return this;
    }

    public CustomDeliveryConfiguration withEndpointTypes(Collection<String> endpointTypes) {
        this.setEndpointTypes(endpointTypes);
        return this;
    }

    public CustomDeliveryConfiguration withEndpointTypes(EndpointTypesElement ... endpointTypes) {
        ArrayList<String> endpointTypesCopy = new ArrayList<String>(endpointTypes.length);
        for (EndpointTypesElement value : endpointTypes) {
            endpointTypesCopy.add(value.toString());
        }
        if (this.getEndpointTypes() == null) {
            this.setEndpointTypes(endpointTypesCopy);
        } else {
            this.getEndpointTypes().addAll(endpointTypesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDeliveryUri() != null) {
            sb.append("DeliveryUri: ").append(this.getDeliveryUri()).append(",");
        }
        if (this.getEndpointTypes() != null) {
            sb.append("EndpointTypes: ").append(this.getEndpointTypes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomDeliveryConfiguration)) {
            return false;
        }
        CustomDeliveryConfiguration other = (CustomDeliveryConfiguration)obj;
        if (other.getDeliveryUri() == null ^ this.getDeliveryUri() == null) {
            return false;
        }
        if (other.getDeliveryUri() != null && !other.getDeliveryUri().equals(this.getDeliveryUri())) {
            return false;
        }
        if (other.getEndpointTypes() == null ^ this.getEndpointTypes() == null) {
            return false;
        }
        return other.getEndpointTypes() == null || other.getEndpointTypes().equals(this.getEndpointTypes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDeliveryUri() == null ? 0 : this.getDeliveryUri().hashCode());
        hashCode = 31 * hashCode + (this.getEndpointTypes() == null ? 0 : this.getEndpointTypes().hashCode());
        return hashCode;
    }

    public CustomDeliveryConfiguration clone() {
        try {
            return (CustomDeliveryConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CustomDeliveryConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

