/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pinpoint.model.MultiConditionalBranch;
import com.amazonaws.services.pinpoint.model.WaitTime;
import com.amazonaws.services.pinpoint.model.transform.MultiConditionalSplitActivityMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MultiConditionalSplitActivity
implements Serializable,
Cloneable,
StructuredPojo {
    private List<MultiConditionalBranch> branches;
    private String defaultActivity;
    private WaitTime evaluationWaitTime;

    public List<MultiConditionalBranch> getBranches() {
        return this.branches;
    }

    public void setBranches(Collection<MultiConditionalBranch> branches) {
        if (branches == null) {
            this.branches = null;
            return;
        }
        this.branches = new ArrayList<MultiConditionalBranch>(branches);
    }

    public MultiConditionalSplitActivity withBranches(MultiConditionalBranch ... branches) {
        if (this.branches == null) {
            this.setBranches(new ArrayList<MultiConditionalBranch>(branches.length));
        }
        for (MultiConditionalBranch ele : branches) {
            this.branches.add(ele);
        }
        return this;
    }

    public MultiConditionalSplitActivity withBranches(Collection<MultiConditionalBranch> branches) {
        this.setBranches(branches);
        return this;
    }

    public void setDefaultActivity(String defaultActivity) {
        this.defaultActivity = defaultActivity;
    }

    public String getDefaultActivity() {
        return this.defaultActivity;
    }

    public MultiConditionalSplitActivity withDefaultActivity(String defaultActivity) {
        this.setDefaultActivity(defaultActivity);
        return this;
    }

    public void setEvaluationWaitTime(WaitTime evaluationWaitTime) {
        this.evaluationWaitTime = evaluationWaitTime;
    }

    public WaitTime getEvaluationWaitTime() {
        return this.evaluationWaitTime;
    }

    public MultiConditionalSplitActivity withEvaluationWaitTime(WaitTime evaluationWaitTime) {
        this.setEvaluationWaitTime(evaluationWaitTime);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBranches() != null) {
            sb.append("Branches: ").append(this.getBranches()).append(",");
        }
        if (this.getDefaultActivity() != null) {
            sb.append("DefaultActivity: ").append(this.getDefaultActivity()).append(",");
        }
        if (this.getEvaluationWaitTime() != null) {
            sb.append("EvaluationWaitTime: ").append(this.getEvaluationWaitTime());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiConditionalSplitActivity)) {
            return false;
        }
        MultiConditionalSplitActivity other = (MultiConditionalSplitActivity)obj;
        if (other.getBranches() == null ^ this.getBranches() == null) {
            return false;
        }
        if (other.getBranches() != null && !other.getBranches().equals(this.getBranches())) {
            return false;
        }
        if (other.getDefaultActivity() == null ^ this.getDefaultActivity() == null) {
            return false;
        }
        if (other.getDefaultActivity() != null && !other.getDefaultActivity().equals(this.getDefaultActivity())) {
            return false;
        }
        if (other.getEvaluationWaitTime() == null ^ this.getEvaluationWaitTime() == null) {
            return false;
        }
        return other.getEvaluationWaitTime() == null || other.getEvaluationWaitTime().equals(this.getEvaluationWaitTime());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBranches() == null ? 0 : this.getBranches().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultActivity() == null ? 0 : this.getDefaultActivity().hashCode());
        hashCode = 31 * hashCode + (this.getEvaluationWaitTime() == null ? 0 : this.getEvaluationWaitTime().hashCode());
        return hashCode;
    }

    public MultiConditionalSplitActivity clone() {
        try {
            return (MultiConditionalSplitActivity)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MultiConditionalSplitActivityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

