/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pinpoint.model.Operator;
import com.amazonaws.services.pinpoint.model.SimpleCondition;
import com.amazonaws.services.pinpoint.model.transform.ConditionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Condition
implements Serializable,
Cloneable,
StructuredPojo {
    private List<SimpleCondition> conditions;
    private String operator;

    public List<SimpleCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(Collection<SimpleCondition> conditions) {
        if (conditions == null) {
            this.conditions = null;
            return;
        }
        this.conditions = new ArrayList<SimpleCondition>(conditions);
    }

    public Condition withConditions(SimpleCondition ... conditions) {
        if (this.conditions == null) {
            this.setConditions(new ArrayList<SimpleCondition>(conditions.length));
        }
        for (SimpleCondition ele : conditions) {
            this.conditions.add(ele);
        }
        return this;
    }

    public Condition withConditions(Collection<SimpleCondition> conditions) {
        this.setConditions(conditions);
        return this;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String getOperator() {
        return this.operator;
    }

    public Condition withOperator(String operator) {
        this.setOperator(operator);
        return this;
    }

    public Condition withOperator(Operator operator) {
        this.operator = operator.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getConditions() != null) {
            sb.append("Conditions: ").append(this.getConditions()).append(",");
        }
        if (this.getOperator() != null) {
            sb.append("Operator: ").append(this.getOperator());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Condition)) {
            return false;
        }
        Condition other = (Condition)obj;
        if (other.getConditions() == null ^ this.getConditions() == null) {
            return false;
        }
        if (other.getConditions() != null && !other.getConditions().equals(this.getConditions())) {
            return false;
        }
        if (other.getOperator() == null ^ this.getOperator() == null) {
            return false;
        }
        return other.getOperator() == null || other.getOperator().equals(this.getOperator());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getConditions() == null ? 0 : this.getConditions().hashCode());
        hashCode = 31 * hashCode + (this.getOperator() == null ? 0 : this.getOperator().hashCode());
        return hashCode;
    }

    public Condition clone() {
        try {
            return (Condition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConditionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

