/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.pinpoint.model.UpdateApplicationSettingsRequest;
import com.amazonaws.services.pinpoint.model.WriteApplicationSettingsRequest;
import com.amazonaws.services.pinpoint.model.transform.CampaignLimitsJsonMarshaller;
import com.amazonaws.services.pinpoint.model.transform.QuietTimeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class UpdateApplicationSettingsRequestMarshaller
implements Marshaller<Request<UpdateApplicationSettingsRequest>, UpdateApplicationSettingsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public UpdateApplicationSettingsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<UpdateApplicationSettingsRequest> marshall(UpdateApplicationSettingsRequest updateApplicationSettingsRequest) {
        if (updateApplicationSettingsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateApplicationSettingsRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/v1/apps/{application-id}/settings";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "application-id", updateApplicationSettingsRequest.getApplicationId());
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            WriteApplicationSettingsRequest writeApplicationSettingsRequest = updateApplicationSettingsRequest.getWriteApplicationSettingsRequest();
            if (writeApplicationSettingsRequest != null) {
                jsonGenerator.writeStartObject();
                if (writeApplicationSettingsRequest.getLimits() != null) {
                    jsonGenerator.writeFieldName("Limits");
                    CampaignLimitsJsonMarshaller.getInstance().marshall(writeApplicationSettingsRequest.getLimits(), jsonGenerator);
                }
                if (writeApplicationSettingsRequest.getQuietTime() != null) {
                    jsonGenerator.writeFieldName("QuietTime");
                    QuietTimeJsonMarshaller.getInstance().marshall(writeApplicationSettingsRequest.getQuietTime(), jsonGenerator);
                }
                jsonGenerator.writeEndObject();
            }
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

