/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.pinpoint.model.GetCampaignVersionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetCampaignVersionRequestMarshaller
implements Marshaller<Request<GetCampaignVersionRequest>, GetCampaignVersionRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetCampaignVersionRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetCampaignVersionRequest> marshall(GetCampaignVersionRequest getCampaignVersionRequest) {
        if (getCampaignVersionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getCampaignVersionRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/v1/apps/{application-id}/campaigns/{campaign-id}/versions/{version}";
        uriResourcePath = uriResourcePath.replace("{application-id}", getCampaignVersionRequest.getApplicationId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)getCampaignVersionRequest.getApplicationId()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{campaign-id}", getCampaignVersionRequest.getCampaignId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)getCampaignVersionRequest.getCampaignId()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{version}", getCampaignVersionRequest.getVersion() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)getCampaignVersionRequest.getVersion()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

