/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pi.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pi.model.ContextType;
import com.amazonaws.services.pi.model.Data;
import com.amazonaws.services.pi.model.Recommendation;
import com.amazonaws.services.pi.model.Severity;
import com.amazonaws.services.pi.model.transform.InsightMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Insight
implements Serializable,
Cloneable,
StructuredPojo {
    private String insightId;
    private String insightType;
    private String context;
    private Date startTime;
    private Date endTime;
    private String severity;
    private List<Insight> supportingInsights;
    private String description;
    private List<Recommendation> recommendations;
    private List<Data> insightData;
    private List<Data> baselineData;

    public void setInsightId(String insightId) {
        this.insightId = insightId;
    }

    public String getInsightId() {
        return this.insightId;
    }

    public Insight withInsightId(String insightId) {
        this.setInsightId(insightId);
        return this;
    }

    public void setInsightType(String insightType) {
        this.insightType = insightType;
    }

    public String getInsightType() {
        return this.insightType;
    }

    public Insight withInsightType(String insightType) {
        this.setInsightType(insightType);
        return this;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getContext() {
        return this.context;
    }

    public Insight withContext(String context) {
        this.setContext(context);
        return this;
    }

    public Insight withContext(ContextType context) {
        this.context = context.toString();
        return this;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Insight withStartTime(Date startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public Insight withEndTime(Date endTime) {
        this.setEndTime(endTime);
        return this;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public String getSeverity() {
        return this.severity;
    }

    public Insight withSeverity(String severity) {
        this.setSeverity(severity);
        return this;
    }

    public Insight withSeverity(Severity severity) {
        this.severity = severity.toString();
        return this;
    }

    public List<Insight> getSupportingInsights() {
        return this.supportingInsights;
    }

    public void setSupportingInsights(Collection<Insight> supportingInsights) {
        if (supportingInsights == null) {
            this.supportingInsights = null;
            return;
        }
        this.supportingInsights = new ArrayList<Insight>(supportingInsights);
    }

    public Insight withSupportingInsights(Insight ... supportingInsights) {
        if (this.supportingInsights == null) {
            this.setSupportingInsights(new ArrayList<Insight>(supportingInsights.length));
        }
        for (Insight ele : supportingInsights) {
            this.supportingInsights.add(ele);
        }
        return this;
    }

    public Insight withSupportingInsights(Collection<Insight> supportingInsights) {
        this.setSupportingInsights(supportingInsights);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Insight withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<Recommendation> getRecommendations() {
        return this.recommendations;
    }

    public void setRecommendations(Collection<Recommendation> recommendations) {
        if (recommendations == null) {
            this.recommendations = null;
            return;
        }
        this.recommendations = new ArrayList<Recommendation>(recommendations);
    }

    public Insight withRecommendations(Recommendation ... recommendations) {
        if (this.recommendations == null) {
            this.setRecommendations(new ArrayList<Recommendation>(recommendations.length));
        }
        for (Recommendation ele : recommendations) {
            this.recommendations.add(ele);
        }
        return this;
    }

    public Insight withRecommendations(Collection<Recommendation> recommendations) {
        this.setRecommendations(recommendations);
        return this;
    }

    public List<Data> getInsightData() {
        return this.insightData;
    }

    public void setInsightData(Collection<Data> insightData) {
        if (insightData == null) {
            this.insightData = null;
            return;
        }
        this.insightData = new ArrayList<Data>(insightData);
    }

    public Insight withInsightData(Data ... insightData) {
        if (this.insightData == null) {
            this.setInsightData(new ArrayList<Data>(insightData.length));
        }
        for (Data ele : insightData) {
            this.insightData.add(ele);
        }
        return this;
    }

    public Insight withInsightData(Collection<Data> insightData) {
        this.setInsightData(insightData);
        return this;
    }

    public List<Data> getBaselineData() {
        return this.baselineData;
    }

    public void setBaselineData(Collection<Data> baselineData) {
        if (baselineData == null) {
            this.baselineData = null;
            return;
        }
        this.baselineData = new ArrayList<Data>(baselineData);
    }

    public Insight withBaselineData(Data ... baselineData) {
        if (this.baselineData == null) {
            this.setBaselineData(new ArrayList<Data>(baselineData.length));
        }
        for (Data ele : baselineData) {
            this.baselineData.add(ele);
        }
        return this;
    }

    public Insight withBaselineData(Collection<Data> baselineData) {
        this.setBaselineData(baselineData);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInsightId() != null) {
            sb.append("InsightId: ").append(this.getInsightId()).append(",");
        }
        if (this.getInsightType() != null) {
            sb.append("InsightType: ").append(this.getInsightType()).append(",");
        }
        if (this.getContext() != null) {
            sb.append("Context: ").append(this.getContext()).append(",");
        }
        if (this.getStartTime() != null) {
            sb.append("StartTime: ").append(this.getStartTime()).append(",");
        }
        if (this.getEndTime() != null) {
            sb.append("EndTime: ").append(this.getEndTime()).append(",");
        }
        if (this.getSeverity() != null) {
            sb.append("Severity: ").append(this.getSeverity()).append(",");
        }
        if (this.getSupportingInsights() != null) {
            sb.append("SupportingInsights: ").append(this.getSupportingInsights()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getRecommendations() != null) {
            sb.append("Recommendations: ").append(this.getRecommendations()).append(",");
        }
        if (this.getInsightData() != null) {
            sb.append("InsightData: ").append(this.getInsightData()).append(",");
        }
        if (this.getBaselineData() != null) {
            sb.append("BaselineData: ").append(this.getBaselineData());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Insight)) {
            return false;
        }
        Insight other = (Insight)obj;
        if (other.getInsightId() == null ^ this.getInsightId() == null) {
            return false;
        }
        if (other.getInsightId() != null && !other.getInsightId().equals(this.getInsightId())) {
            return false;
        }
        if (other.getInsightType() == null ^ this.getInsightType() == null) {
            return false;
        }
        if (other.getInsightType() != null && !other.getInsightType().equals(this.getInsightType())) {
            return false;
        }
        if (other.getContext() == null ^ this.getContext() == null) {
            return false;
        }
        if (other.getContext() != null && !other.getContext().equals(this.getContext())) {
            return false;
        }
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getEndTime() == null ^ this.getEndTime() == null) {
            return false;
        }
        if (other.getEndTime() != null && !other.getEndTime().equals(this.getEndTime())) {
            return false;
        }
        if (other.getSeverity() == null ^ this.getSeverity() == null) {
            return false;
        }
        if (other.getSeverity() != null && !other.getSeverity().equals(this.getSeverity())) {
            return false;
        }
        if (other.getSupportingInsights() == null ^ this.getSupportingInsights() == null) {
            return false;
        }
        if (other.getSupportingInsights() != null && !other.getSupportingInsights().equals(this.getSupportingInsights())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getRecommendations() == null ^ this.getRecommendations() == null) {
            return false;
        }
        if (other.getRecommendations() != null && !other.getRecommendations().equals(this.getRecommendations())) {
            return false;
        }
        if (other.getInsightData() == null ^ this.getInsightData() == null) {
            return false;
        }
        if (other.getInsightData() != null && !other.getInsightData().equals(this.getInsightData())) {
            return false;
        }
        if (other.getBaselineData() == null ^ this.getBaselineData() == null) {
            return false;
        }
        return other.getBaselineData() == null || other.getBaselineData().equals(this.getBaselineData());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInsightId() == null ? 0 : this.getInsightId().hashCode());
        hashCode = 31 * hashCode + (this.getInsightType() == null ? 0 : this.getInsightType().hashCode());
        hashCode = 31 * hashCode + (this.getContext() == null ? 0 : this.getContext().hashCode());
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getEndTime() == null ? 0 : this.getEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getSeverity() == null ? 0 : this.getSeverity().hashCode());
        hashCode = 31 * hashCode + (this.getSupportingInsights() == null ? 0 : this.getSupportingInsights().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getRecommendations() == null ? 0 : this.getRecommendations().hashCode());
        hashCode = 31 * hashCode + (this.getInsightData() == null ? 0 : this.getInsightData().hashCode());
        hashCode = 31 * hashCode + (this.getBaselineData() == null ? 0 : this.getBaselineData().hashCode());
        return hashCode;
    }

    public Insight clone() {
        try {
            return (Insight)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InsightMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

