/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.personalize;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.personalize.AmazonPersonalizeAsync;
import com.amazonaws.services.personalize.AmazonPersonalizeAsyncClientBuilder;
import com.amazonaws.services.personalize.AmazonPersonalizeClient;
import com.amazonaws.services.personalize.model.CreateBatchInferenceJobRequest;
import com.amazonaws.services.personalize.model.CreateBatchInferenceJobResult;
import com.amazonaws.services.personalize.model.CreateCampaignRequest;
import com.amazonaws.services.personalize.model.CreateCampaignResult;
import com.amazonaws.services.personalize.model.CreateDatasetGroupRequest;
import com.amazonaws.services.personalize.model.CreateDatasetGroupResult;
import com.amazonaws.services.personalize.model.CreateDatasetImportJobRequest;
import com.amazonaws.services.personalize.model.CreateDatasetImportJobResult;
import com.amazonaws.services.personalize.model.CreateDatasetRequest;
import com.amazonaws.services.personalize.model.CreateDatasetResult;
import com.amazonaws.services.personalize.model.CreateEventTrackerRequest;
import com.amazonaws.services.personalize.model.CreateEventTrackerResult;
import com.amazonaws.services.personalize.model.CreateFilterRequest;
import com.amazonaws.services.personalize.model.CreateFilterResult;
import com.amazonaws.services.personalize.model.CreateSchemaRequest;
import com.amazonaws.services.personalize.model.CreateSchemaResult;
import com.amazonaws.services.personalize.model.CreateSolutionRequest;
import com.amazonaws.services.personalize.model.CreateSolutionResult;
import com.amazonaws.services.personalize.model.CreateSolutionVersionRequest;
import com.amazonaws.services.personalize.model.CreateSolutionVersionResult;
import com.amazonaws.services.personalize.model.DeleteCampaignRequest;
import com.amazonaws.services.personalize.model.DeleteCampaignResult;
import com.amazonaws.services.personalize.model.DeleteDatasetGroupRequest;
import com.amazonaws.services.personalize.model.DeleteDatasetGroupResult;
import com.amazonaws.services.personalize.model.DeleteDatasetRequest;
import com.amazonaws.services.personalize.model.DeleteDatasetResult;
import com.amazonaws.services.personalize.model.DeleteEventTrackerRequest;
import com.amazonaws.services.personalize.model.DeleteEventTrackerResult;
import com.amazonaws.services.personalize.model.DeleteFilterRequest;
import com.amazonaws.services.personalize.model.DeleteFilterResult;
import com.amazonaws.services.personalize.model.DeleteSchemaRequest;
import com.amazonaws.services.personalize.model.DeleteSchemaResult;
import com.amazonaws.services.personalize.model.DeleteSolutionRequest;
import com.amazonaws.services.personalize.model.DeleteSolutionResult;
import com.amazonaws.services.personalize.model.DescribeAlgorithmRequest;
import com.amazonaws.services.personalize.model.DescribeAlgorithmResult;
import com.amazonaws.services.personalize.model.DescribeBatchInferenceJobRequest;
import com.amazonaws.services.personalize.model.DescribeBatchInferenceJobResult;
import com.amazonaws.services.personalize.model.DescribeCampaignRequest;
import com.amazonaws.services.personalize.model.DescribeCampaignResult;
import com.amazonaws.services.personalize.model.DescribeDatasetGroupRequest;
import com.amazonaws.services.personalize.model.DescribeDatasetGroupResult;
import com.amazonaws.services.personalize.model.DescribeDatasetImportJobRequest;
import com.amazonaws.services.personalize.model.DescribeDatasetImportJobResult;
import com.amazonaws.services.personalize.model.DescribeDatasetRequest;
import com.amazonaws.services.personalize.model.DescribeDatasetResult;
import com.amazonaws.services.personalize.model.DescribeEventTrackerRequest;
import com.amazonaws.services.personalize.model.DescribeEventTrackerResult;
import com.amazonaws.services.personalize.model.DescribeFeatureTransformationRequest;
import com.amazonaws.services.personalize.model.DescribeFeatureTransformationResult;
import com.amazonaws.services.personalize.model.DescribeFilterRequest;
import com.amazonaws.services.personalize.model.DescribeFilterResult;
import com.amazonaws.services.personalize.model.DescribeRecipeRequest;
import com.amazonaws.services.personalize.model.DescribeRecipeResult;
import com.amazonaws.services.personalize.model.DescribeSchemaRequest;
import com.amazonaws.services.personalize.model.DescribeSchemaResult;
import com.amazonaws.services.personalize.model.DescribeSolutionRequest;
import com.amazonaws.services.personalize.model.DescribeSolutionResult;
import com.amazonaws.services.personalize.model.DescribeSolutionVersionRequest;
import com.amazonaws.services.personalize.model.DescribeSolutionVersionResult;
import com.amazonaws.services.personalize.model.GetSolutionMetricsRequest;
import com.amazonaws.services.personalize.model.GetSolutionMetricsResult;
import com.amazonaws.services.personalize.model.ListBatchInferenceJobsRequest;
import com.amazonaws.services.personalize.model.ListBatchInferenceJobsResult;
import com.amazonaws.services.personalize.model.ListCampaignsRequest;
import com.amazonaws.services.personalize.model.ListCampaignsResult;
import com.amazonaws.services.personalize.model.ListDatasetGroupsRequest;
import com.amazonaws.services.personalize.model.ListDatasetGroupsResult;
import com.amazonaws.services.personalize.model.ListDatasetImportJobsRequest;
import com.amazonaws.services.personalize.model.ListDatasetImportJobsResult;
import com.amazonaws.services.personalize.model.ListDatasetsRequest;
import com.amazonaws.services.personalize.model.ListDatasetsResult;
import com.amazonaws.services.personalize.model.ListEventTrackersRequest;
import com.amazonaws.services.personalize.model.ListEventTrackersResult;
import com.amazonaws.services.personalize.model.ListFiltersRequest;
import com.amazonaws.services.personalize.model.ListFiltersResult;
import com.amazonaws.services.personalize.model.ListRecipesRequest;
import com.amazonaws.services.personalize.model.ListRecipesResult;
import com.amazonaws.services.personalize.model.ListSchemasRequest;
import com.amazonaws.services.personalize.model.ListSchemasResult;
import com.amazonaws.services.personalize.model.ListSolutionVersionsRequest;
import com.amazonaws.services.personalize.model.ListSolutionVersionsResult;
import com.amazonaws.services.personalize.model.ListSolutionsRequest;
import com.amazonaws.services.personalize.model.ListSolutionsResult;
import com.amazonaws.services.personalize.model.UpdateCampaignRequest;
import com.amazonaws.services.personalize.model.UpdateCampaignResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonPersonalizeAsyncClient
extends AmazonPersonalizeClient
implements AmazonPersonalizeAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonPersonalizeAsyncClientBuilder asyncBuilder() {
        return AmazonPersonalizeAsyncClientBuilder.standard();
    }

    AmazonPersonalizeAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonPersonalizeAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateBatchInferenceJobResult> createBatchInferenceJobAsync(CreateBatchInferenceJobRequest request) {
        return this.createBatchInferenceJobAsync(request, null);
    }

    @Override
    public Future<CreateBatchInferenceJobResult> createBatchInferenceJobAsync(CreateBatchInferenceJobRequest request, final AsyncHandler<CreateBatchInferenceJobRequest, CreateBatchInferenceJobResult> asyncHandler) {
        final CreateBatchInferenceJobRequest finalRequest = (CreateBatchInferenceJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateBatchInferenceJobResult>(){

            @Override
            public CreateBatchInferenceJobResult call() throws Exception {
                CreateBatchInferenceJobResult result = null;
                try {
                    result = AmazonPersonalizeAsyncClient.this.executeCreateBatchInferenceJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateCampaignResult> createCampaignAsync(CreateCampaignRequest request) {
        return this.createCampaignAsync(request, null);
    }

    @Override
    public Future<CreateCampaignResult> createCampaignAsync(CreateCampaignRequest request, final AsyncHandler<CreateCampaignRequest, CreateCampaignResult> asyncHandler) {
        final CreateCampaignRequest finalRequest = (CreateCampaignRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateCampaignResult>(){

            @Override
            public CreateCampaignResult call() throws Exception {
                CreateCampaignResult result = null;
                try {
                    result = AmazonPersonalizeAsyncClient.this.executeCreateCampaign(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateDatasetResult> createDatasetAsync(CreateDatasetRequest request) {
        return this.createDatasetAsync(request, null);
    }

    @Override
    public Future<CreateDatasetResult> createDatasetAsync(CreateDatasetRequest request, final AsyncHandler<CreateDatasetRequest, CreateDatasetResult> asyncHandler) {
        final CreateDatasetRequest finalRequest = (CreateDatasetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateDatasetResult>(){

            @Override
            public CreateDatasetResult call() throws Exception {
                CreateDatasetResult result = null;
                try {
                    result = AmazonPersonalizeAsyncClient.this.executeCreateDataset(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateDatasetGroupResult> createDatasetGroupAsync(CreateDatasetGroupRequest request) {
        return this.createDatasetGroupAsync(request, null);
    }

    @Override
    public Future<CreateDatasetGroupResult> createDatasetGroupAsync(CreateDatasetGroupRequest request, final AsyncHandler<CreateDatasetGroupRequest, CreateDatasetGroupResult> asyncHandler) {
        final CreateDatasetGroupRequest finalRequest = (CreateDatasetGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateDatasetGroupResult>(){

            @Override
            public CreateDatasetGroupResult call() throws Exception {
                CreateDatasetGroupResult result = null;
                try {
                    result = AmazonPersonalizeAsyncClient.this.executeCreateDatasetGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateDatasetImportJobResult> createDatasetImportJobAsync(CreateDatasetImportJobRequest request) {
        return this.createDatasetImportJobAsync(request, null);
    }

    @Override
    public Future<CreateDatasetImportJobResult> createDatasetImportJobAsync(CreateDatasetImportJobRequest request, final AsyncHandler<CreateDatasetImportJobRequest, CreateDatasetImportJobResult> asyncHandler) {
        final CreateDatasetImportJobRequest finalRequest = (CreateDatasetImportJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateDatasetImportJobResult>(){

            @Override
            public CreateDatasetImportJobResult call() throws Exception {
                CreateDatasetImportJobResult result = null;
                try {
                    result = AmazonPersonalizeAsyncClient.this.executeCreateDatasetImportJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateEventTrackerResult> createEventTrackerAsync(CreateEventTrackerRequest request) {
        return this.createEventTrackerAsync(request, null);
    }

    @Override
    public Future<CreateEventTrackerResult> createEventTrackerAsync(CreateEventTrackerRequest request, final AsyncHandler<CreateEventTrackerRequest, CreateEventTrackerResult> asyncHandler) {
        final CreateEventTrackerRequest finalRequest = (CreateEventTrackerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateEventTrackerResult>(){

            @Override
            public CreateEventTrackerResult call() throws Exception {
                CreateEventTrackerResult result = null;
                try {
                    result = AmazonPersonalizeAsyncClient.this.executeCreateEventTracker(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateFilterResult> createFilterAsync(CreateFilterRequest request) {
        return this.createFilterAsync(request, null);
    }

    @Override
    public Future<CreateFilterResult> createFilterAsync(CreateFilterRequest request, final AsyncHandler<CreateFilterRequest, CreateFilterResult> asyncHandler) {
        final CreateFilterRequest finalRequest = (CreateFilterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateFilterResult>(){

            @Override
            public CreateFilterResult call() throws Exception {
                CreateFilterResult result = null;
                try {
                    result = AmazonPersonalizeAsyncClient.this.executeCreateFilter(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateSchemaResult> createSchemaAsync(CreateSchemaRequest request) {
        return this.createSchemaAsync(request, null);
    }

    @Override
    public Future<CreateSchemaResult> createSchemaAsync(CreateSchemaRequest request, final AsyncHandler<CreateSchemaRequest, CreateSchemaResult> asyncHandler) {
        final CreateSchemaRequest finalRequest = (CreateSchemaRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateSchemaResult>(){

            @Override
            public CreateSchemaResult call() throws Exception {
                CreateSchemaResult result = null;
                try {
                    result = AmazonPersonalizeAsyncClient.this.executeCreateSchema(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateSolutionResult> createSolutionAsync(CreateSolutionRequest request) {
        return this.createSolutionAsync(request, null);
    }

    @Override
    public Future<CreateSolutionResult> createSolutionAsync(CreateSolutionRequest request, final AsyncHandler<CreateSolutionRequest, CreateSolutionResult> asyncHandler) {
        final CreateSolutionRequest finalRequest = (CreateSolutionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateSolutionResult>(){

            @Override
            public CreateSolutionResult call() throws Exception {
                CreateSolutionResult result = null;
                try {
                    result = AmazonPersonalizeAsyncClient.this.executeCreateSolution(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateSolutionVersionResult> createSolutionVersionAsync(CreateSolutionVersionRequest request) {
        return this.createSolutionVersionAsync(request, null);
    }

    @Override
    public Future<CreateSolutionVersionResult> createSolutionVersionAsync(CreateSolutionVersionRequest request, final AsyncHandler<CreateSolutionVersionRequest, CreateSolutionVersionResult> asyncHandler) {
        final CreateSolutionVersionRequest finalRequest = (CreateSolutionVersionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateSolutionVersionResult>(){

            @Override
            public CreateSolutionVersionResult call() throws Exception {
                CreateSolutionVersionResult result = null;
                try {
                    result = AmazonPersonalizeAsyncClient.this.executeCreateSolutionVersion(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteCampaignResult> deleteCampaignAsync(DeleteCampaignRequest request) {
        return this.deleteCampaignAsync(request, null);
    }

    @Override
    public Future<DeleteCampaignResult> deleteCampaignAsync(DeleteCampaignRequest request, final AsyncHandler<DeleteCampaignRequest, DeleteCampaignResult> asyncHandler) {
        final DeleteCampaignRequest finalRequest = (DeleteCampaignRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteCampaignResult>(){

            @Override
            public DeleteCampaignResult call() throws Exception {
                DeleteCampaignResult result = null;
                try {
                    result = AmazonPersonalizeAsyncClient.this.executeDeleteCampaign(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDatasetResult> deleteDatasetAsync(DeleteDatasetRequest request) {
        return this.deleteDatasetAsync(request, null);
    }

    @Override
    public Future<DeleteDatasetResult> deleteDatasetAsync(DeleteDatasetRequest request, final AsyncHandler<DeleteDatasetRequest, DeleteDatasetResult> asyncHandler) {
        final DeleteDatasetRequest finalRequest = (DeleteDatasetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteDatasetResult>(){

            @Override
            public DeleteDatasetResult call() throws Exception {
                DeleteDatasetResult result = null;
                try {
                    result = AmazonPersonalizeAsyncClient.this.executeDeleteDataset(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDatasetGroupResult> deleteDatasetGroupAsync(DeleteDatasetGroupRequest request) {
        return this.deleteDatasetGroupAsync(request, null);
    }

    @Override
    public Future<DeleteDatasetGroupResult> deleteDatasetGroupAsync(DeleteDatasetGroupRequest request, final AsyncHandler<DeleteDatasetGroupRequest, DeleteDatasetGroupResult> asyncHandler) {
        final DeleteDatasetGroupRequest finalRequest = (DeleteDatasetGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteDatasetGroupResult>(){

            @Override
            public DeleteDatasetGroupResult call() throws Exception {
                DeleteDatasetGroupResult result = null;
                try {
                    result = AmazonPersonalizeAsyncClient.this.executeDeleteDatasetGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteEventTrackerResult> deleteEventTrackerAsync(DeleteEventTrackerRequest request) {
        return this.deleteEventTrackerAsync(request, null);
    }

    @Override
    public Future<DeleteEventTrackerResult> deleteEventTrackerAsync(DeleteEventTrackerRequest request, final AsyncHandler<DeleteEventTrackerRequest, DeleteEventTrackerResult> asyncHandler) {
        final DeleteEventTrackerRequest finalRequest = (DeleteEventTrackerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteEventTrackerResult>(){

            @Override
            public DeleteEventTrackerResult call() throws Exception {
                DeleteEventTrackerResult result = null;
                try {
                    result = AmazonPersonalizeAsyncClient.this.executeDeleteEventTracker(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteFilterResult> deleteFilterAsync(DeleteFilterRequest request) {
        return this.deleteFilterAsync(request, null);
    }

    @Override
    public Future<DeleteFilterResult> deleteFilterAsync(DeleteFilterRequest request, final AsyncHandler<DeleteFilterRequest, DeleteFilterResult> asyncHandler) {
        final DeleteFilterRequest finalRequest = (DeleteFilterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteFilterResult>(){

            @Override
            public DeleteFilterResult call() throws Exception {
                DeleteFilterResult result = null;
                try {
                    result = AmazonPersonalizeAsyncClient.this.executeDeleteFilter(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteSchemaResult> deleteSchemaAsync(DeleteSchemaRequest request) {
        return this.deleteSchemaAsync(request, null);
    }

    @Override
    public Future<DeleteSchemaResult> deleteSchemaAsync(DeleteSchemaRequest request, final AsyncHandler<DeleteSchemaRequest, DeleteSchemaResult> asyncHandler) {
        final DeleteSchemaRequest finalRequest = (DeleteSchemaRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteSchemaResult>(){

            @Override
            public DeleteSchemaResult call() throws Exception {
                DeleteSchemaResult result = null;
                try {
                    result = AmazonPersonalizeAsyncClient.this.executeDeleteSchema(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteSolutionResult> deleteSolutionAsync(DeleteSolutionRequest request) {
        return this.deleteSolutionAsync(request, null);
    }

    @Override
    public Future<DeleteSolutionResult> deleteSolutionAsync(DeleteSolutionRequest request, final AsyncHandler<DeleteSolutionRequest, DeleteSolutionResult> asyncHandler) {
        final DeleteSolutionRequest finalRequest = (DeleteSolutionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteSolutionResult>(){

            @Override
            public DeleteSolutionResult call() throws Exception {
                DeleteSolutionResult result = null;
                try {
                    result = AmazonPersonalizeAsyncClient.this.executeDeleteSolution(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAlgorithmResult> describeAlgorithmAsync(DescribeAlgorithmRequest request) {
        return this.describeAlgorithmAsync(request, null);
    }

    @Override
    public Future<DescribeAlgorithmResult> describeAlgorithmAsync(DescribeAlgorithmRequest request, final AsyncHandler<DescribeAlgorithmRequest, DescribeAlgorithmResult> asyncHandler) {
        final DescribeAlgorithmRequest finalRequest = (DescribeAlgorithmRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeAlgorithmResult>(){

            @Override
            public DescribeAlgorithmResult call() throws Exception {
                DescribeAlgorithmResult result = null;
                try {
                    result = AmazonPersonalizeAsyncClient.this.executeDescribeAlgorithm(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeBatchInferenceJobResult> describeBatchInferenceJobAsync(DescribeBatchInferenceJobRequest request) {
        return this.describeBatchInferenceJobAsync(request, null);
    }

    @Override
    public Future<DescribeBatchInferenceJobResult> describeBatchInferenceJobAsync(DescribeBatchInferenceJobRequest request, final AsyncHandler<DescribeBatchInferenceJobRequest, DescribeBatchInferenceJobResult> asyncHandler) {
        final DescribeBatchInferenceJobRequest finalRequest = (DescribeBatchInferenceJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeBatchInferenceJobResult>(){

            @Override
            public DescribeBatchInferenceJobResult call() throws Exception {
                DescribeBatchInferenceJobResult result = null;
                try {
                    result = AmazonPersonalizeAsyncClient.this.executeDescribeBatchInferenceJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCampaignResult> describeCampaignAsync(DescribeCampaignRequest request) {
        return this.describeCampaignAsync(request, null);
    }

    @Override
    public Future<DescribeCampaignResult> describeCampaignAsync(DescribeCampaignRequest request, final AsyncHandler<DescribeCampaignRequest, DescribeCampaignResult> asyncHandler) {
        final DescribeCampaignRequest finalRequest = (DescribeCampaignRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeCampaignResult>(){

            @Override
            public DescribeCampaignResult call() throws Exception {
                DescribeCampaignResult result = null;
                try {
                    result = AmazonPersonalizeAsyncClient.this.executeDescribeCampaign(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDatasetResult> describeDatasetAsync(DescribeDatasetRequest request) {
        return this.describeDatasetAsync(request, null);
    }

    @Override
    public Future<DescribeDatasetResult> describeDatasetAsync(DescribeDatasetRequest request, final AsyncHandler<DescribeDatasetRequest, DescribeDatasetResult> asyncHandler) {
        final DescribeDatasetRequest finalRequest = (DescribeDatasetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDatasetResult>(){

            @Override
            public DescribeDatasetResult call() throws Exception {
                DescribeDatasetResult result = null;
                try {
                    result = AmazonPersonalizeAsyncClient.this.executeDescribeDataset(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDatasetGroupResult> describeDatasetGroupAsync(DescribeDatasetGroupRequest request) {
        return this.describeDatasetGroupAsync(request, null);
    }

    @Override
    public Future<DescribeDatasetGroupResult> describeDatasetGroupAsync(DescribeDatasetGroupRequest request, final AsyncHandler<DescribeDatasetGroupRequest, DescribeDatasetGroupResult> asyncHandler) {
        final DescribeDatasetGroupRequest finalRequest = (DescribeDatasetGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDatasetGroupResult>(){

            @Override
            public DescribeDatasetGroupResult call() throws Exception {
                DescribeDatasetGroupResult result = null;
                try {
                    result = AmazonPersonalizeAsyncClient.this.executeDescribeDatasetGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDatasetImportJobResult> describeDatasetImportJobAsync(DescribeDatasetImportJobRequest request) {
        return this.describeDatasetImportJobAsync(request, null);
    }

    @Override
    public Future<DescribeDatasetImportJobResult> describeDatasetImportJobAsync(DescribeDatasetImportJobRequest request, final AsyncHandler<DescribeDatasetImportJobRequest, DescribeDatasetImportJobResult> asyncHandler) {
        final DescribeDatasetImportJobRequest finalRequest = (DescribeDatasetImportJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDatasetImportJobResult>(){

            @Override
            public DescribeDatasetImportJobResult call() throws Exception {
                DescribeDatasetImportJobResult result = null;
                try {
                    result = AmazonPersonalizeAsyncClient.this.executeDescribeDatasetImportJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEventTrackerResult> describeEventTrackerAsync(DescribeEventTrackerRequest request) {
        return this.describeEventTrackerAsync(request, null);
    }

    @Override
    public Future<DescribeEventTrackerResult> describeEventTrackerAsync(DescribeEventTrackerRequest request, final AsyncHandler<DescribeEventTrackerRequest, DescribeEventTrackerResult> asyncHandler) {
        final DescribeEventTrackerRequest finalRequest = (DescribeEventTrackerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeEventTrackerResult>(){

            @Override
            public DescribeEventTrackerResult call() throws Exception {
                DescribeEventTrackerResult result = null;
                try {
                    result = AmazonPersonalizeAsyncClient.this.executeDescribeEventTracker(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeFeatureTransformationResult> describeFeatureTransformationAsync(DescribeFeatureTransformationRequest request) {
        return this.describeFeatureTransformationAsync(request, null);
    }

    @Override
    public Future<DescribeFeatureTransformationResult> describeFeatureTransformationAsync(DescribeFeatureTransformationRequest request, final AsyncHandler<DescribeFeatureTransformationRequest, DescribeFeatureTransformationResult> asyncHandler) {
        final DescribeFeatureTransformationRequest finalRequest = (DescribeFeatureTransformationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeFeatureTransformationResult>(){

            @Override
            public DescribeFeatureTransformationResult call() throws Exception {
                DescribeFeatureTransformationResult result = null;
                try {
                    result = AmazonPersonalizeAsyncClient.this.executeDescribeFeatureTransformation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeFilterResult> describeFilterAsync(DescribeFilterRequest request) {
        return this.describeFilterAsync(request, null);
    }

    @Override
    public Future<DescribeFilterResult> describeFilterAsync(DescribeFilterRequest request, final AsyncHandler<DescribeFilterRequest, DescribeFilterResult> asyncHandler) {
        final DescribeFilterRequest finalRequest = (DescribeFilterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeFilterResult>(){

            @Override
            public DescribeFilterResult call() throws Exception {
                DescribeFilterResult result = null;
                try {
                    result = AmazonPersonalizeAsyncClient.this.executeDescribeFilter(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeRecipeResult> describeRecipeAsync(DescribeRecipeRequest request) {
        return this.describeRecipeAsync(request, null);
    }

    @Override
    public Future<DescribeRecipeResult> describeRecipeAsync(DescribeRecipeRequest request, final AsyncHandler<DescribeRecipeRequest, DescribeRecipeResult> asyncHandler) {
        final DescribeRecipeRequest finalRequest = (DescribeRecipeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeRecipeResult>(){

            @Override
            public DescribeRecipeResult call() throws Exception {
                DescribeRecipeResult result = null;
                try {
                    result = AmazonPersonalizeAsyncClient.this.executeDescribeRecipe(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeSchemaResult> describeSchemaAsync(DescribeSchemaRequest request) {
        return this.describeSchemaAsync(request, null);
    }

    @Override
    public Future<DescribeSchemaResult> describeSchemaAsync(DescribeSchemaRequest request, final AsyncHandler<DescribeSchemaRequest, DescribeSchemaResult> asyncHandler) {
        final DescribeSchemaRequest finalRequest = (DescribeSchemaRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeSchemaResult>(){

            @Override
            public DescribeSchemaResult call() throws Exception {
                DescribeSchemaResult result = null;
                try {
                    result = AmazonPersonalizeAsyncClient.this.executeDescribeSchema(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeSolutionResult> describeSolutionAsync(DescribeSolutionRequest request) {
        return this.describeSolutionAsync(request, null);
    }

    @Override
    public Future<DescribeSolutionResult> describeSolutionAsync(DescribeSolutionRequest request, final AsyncHandler<DescribeSolutionRequest, DescribeSolutionResult> asyncHandler) {
        final DescribeSolutionRequest finalRequest = (DescribeSolutionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeSolutionResult>(){

            @Override
            public DescribeSolutionResult call() throws Exception {
                DescribeSolutionResult result = null;
                try {
                    result = AmazonPersonalizeAsyncClient.this.executeDescribeSolution(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeSolutionVersionResult> describeSolutionVersionAsync(DescribeSolutionVersionRequest request) {
        return this.describeSolutionVersionAsync(request, null);
    }

    @Override
    public Future<DescribeSolutionVersionResult> describeSolutionVersionAsync(DescribeSolutionVersionRequest request, final AsyncHandler<DescribeSolutionVersionRequest, DescribeSolutionVersionResult> asyncHandler) {
        final DescribeSolutionVersionRequest finalRequest = (DescribeSolutionVersionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeSolutionVersionResult>(){

            @Override
            public DescribeSolutionVersionResult call() throws Exception {
                DescribeSolutionVersionResult result = null;
                try {
                    result = AmazonPersonalizeAsyncClient.this.executeDescribeSolutionVersion(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSolutionMetricsResult> getSolutionMetricsAsync(GetSolutionMetricsRequest request) {
        return this.getSolutionMetricsAsync(request, null);
    }

    @Override
    public Future<GetSolutionMetricsResult> getSolutionMetricsAsync(GetSolutionMetricsRequest request, final AsyncHandler<GetSolutionMetricsRequest, GetSolutionMetricsResult> asyncHandler) {
        final GetSolutionMetricsRequest finalRequest = (GetSolutionMetricsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSolutionMetricsResult>(){

            @Override
            public GetSolutionMetricsResult call() throws Exception {
                GetSolutionMetricsResult result = null;
                try {
                    result = AmazonPersonalizeAsyncClient.this.executeGetSolutionMetrics(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListBatchInferenceJobsResult> listBatchInferenceJobsAsync(ListBatchInferenceJobsRequest request) {
        return this.listBatchInferenceJobsAsync(request, null);
    }

    @Override
    public Future<ListBatchInferenceJobsResult> listBatchInferenceJobsAsync(ListBatchInferenceJobsRequest request, final AsyncHandler<ListBatchInferenceJobsRequest, ListBatchInferenceJobsResult> asyncHandler) {
        final ListBatchInferenceJobsRequest finalRequest = (ListBatchInferenceJobsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListBatchInferenceJobsResult>(){

            @Override
            public ListBatchInferenceJobsResult call() throws Exception {
                ListBatchInferenceJobsResult result = null;
                try {
                    result = AmazonPersonalizeAsyncClient.this.executeListBatchInferenceJobs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListCampaignsResult> listCampaignsAsync(ListCampaignsRequest request) {
        return this.listCampaignsAsync(request, null);
    }

    @Override
    public Future<ListCampaignsResult> listCampaignsAsync(ListCampaignsRequest request, final AsyncHandler<ListCampaignsRequest, ListCampaignsResult> asyncHandler) {
        final ListCampaignsRequest finalRequest = (ListCampaignsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListCampaignsResult>(){

            @Override
            public ListCampaignsResult call() throws Exception {
                ListCampaignsResult result = null;
                try {
                    result = AmazonPersonalizeAsyncClient.this.executeListCampaigns(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDatasetGroupsResult> listDatasetGroupsAsync(ListDatasetGroupsRequest request) {
        return this.listDatasetGroupsAsync(request, null);
    }

    @Override
    public Future<ListDatasetGroupsResult> listDatasetGroupsAsync(ListDatasetGroupsRequest request, final AsyncHandler<ListDatasetGroupsRequest, ListDatasetGroupsResult> asyncHandler) {
        final ListDatasetGroupsRequest finalRequest = (ListDatasetGroupsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDatasetGroupsResult>(){

            @Override
            public ListDatasetGroupsResult call() throws Exception {
                ListDatasetGroupsResult result = null;
                try {
                    result = AmazonPersonalizeAsyncClient.this.executeListDatasetGroups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDatasetImportJobsResult> listDatasetImportJobsAsync(ListDatasetImportJobsRequest request) {
        return this.listDatasetImportJobsAsync(request, null);
    }

    @Override
    public Future<ListDatasetImportJobsResult> listDatasetImportJobsAsync(ListDatasetImportJobsRequest request, final AsyncHandler<ListDatasetImportJobsRequest, ListDatasetImportJobsResult> asyncHandler) {
        final ListDatasetImportJobsRequest finalRequest = (ListDatasetImportJobsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDatasetImportJobsResult>(){

            @Override
            public ListDatasetImportJobsResult call() throws Exception {
                ListDatasetImportJobsResult result = null;
                try {
                    result = AmazonPersonalizeAsyncClient.this.executeListDatasetImportJobs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDatasetsResult> listDatasetsAsync(ListDatasetsRequest request) {
        return this.listDatasetsAsync(request, null);
    }

    @Override
    public Future<ListDatasetsResult> listDatasetsAsync(ListDatasetsRequest request, final AsyncHandler<ListDatasetsRequest, ListDatasetsResult> asyncHandler) {
        final ListDatasetsRequest finalRequest = (ListDatasetsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDatasetsResult>(){

            @Override
            public ListDatasetsResult call() throws Exception {
                ListDatasetsResult result = null;
                try {
                    result = AmazonPersonalizeAsyncClient.this.executeListDatasets(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListEventTrackersResult> listEventTrackersAsync(ListEventTrackersRequest request) {
        return this.listEventTrackersAsync(request, null);
    }

    @Override
    public Future<ListEventTrackersResult> listEventTrackersAsync(ListEventTrackersRequest request, final AsyncHandler<ListEventTrackersRequest, ListEventTrackersResult> asyncHandler) {
        final ListEventTrackersRequest finalRequest = (ListEventTrackersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListEventTrackersResult>(){

            @Override
            public ListEventTrackersResult call() throws Exception {
                ListEventTrackersResult result = null;
                try {
                    result = AmazonPersonalizeAsyncClient.this.executeListEventTrackers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListFiltersResult> listFiltersAsync(ListFiltersRequest request) {
        return this.listFiltersAsync(request, null);
    }

    @Override
    public Future<ListFiltersResult> listFiltersAsync(ListFiltersRequest request, final AsyncHandler<ListFiltersRequest, ListFiltersResult> asyncHandler) {
        final ListFiltersRequest finalRequest = (ListFiltersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListFiltersResult>(){

            @Override
            public ListFiltersResult call() throws Exception {
                ListFiltersResult result = null;
                try {
                    result = AmazonPersonalizeAsyncClient.this.executeListFilters(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListRecipesResult> listRecipesAsync(ListRecipesRequest request) {
        return this.listRecipesAsync(request, null);
    }

    @Override
    public Future<ListRecipesResult> listRecipesAsync(ListRecipesRequest request, final AsyncHandler<ListRecipesRequest, ListRecipesResult> asyncHandler) {
        final ListRecipesRequest finalRequest = (ListRecipesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListRecipesResult>(){

            @Override
            public ListRecipesResult call() throws Exception {
                ListRecipesResult result = null;
                try {
                    result = AmazonPersonalizeAsyncClient.this.executeListRecipes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSchemasResult> listSchemasAsync(ListSchemasRequest request) {
        return this.listSchemasAsync(request, null);
    }

    @Override
    public Future<ListSchemasResult> listSchemasAsync(ListSchemasRequest request, final AsyncHandler<ListSchemasRequest, ListSchemasResult> asyncHandler) {
        final ListSchemasRequest finalRequest = (ListSchemasRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListSchemasResult>(){

            @Override
            public ListSchemasResult call() throws Exception {
                ListSchemasResult result = null;
                try {
                    result = AmazonPersonalizeAsyncClient.this.executeListSchemas(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSolutionVersionsResult> listSolutionVersionsAsync(ListSolutionVersionsRequest request) {
        return this.listSolutionVersionsAsync(request, null);
    }

    @Override
    public Future<ListSolutionVersionsResult> listSolutionVersionsAsync(ListSolutionVersionsRequest request, final AsyncHandler<ListSolutionVersionsRequest, ListSolutionVersionsResult> asyncHandler) {
        final ListSolutionVersionsRequest finalRequest = (ListSolutionVersionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListSolutionVersionsResult>(){

            @Override
            public ListSolutionVersionsResult call() throws Exception {
                ListSolutionVersionsResult result = null;
                try {
                    result = AmazonPersonalizeAsyncClient.this.executeListSolutionVersions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSolutionsResult> listSolutionsAsync(ListSolutionsRequest request) {
        return this.listSolutionsAsync(request, null);
    }

    @Override
    public Future<ListSolutionsResult> listSolutionsAsync(ListSolutionsRequest request, final AsyncHandler<ListSolutionsRequest, ListSolutionsResult> asyncHandler) {
        final ListSolutionsRequest finalRequest = (ListSolutionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListSolutionsResult>(){

            @Override
            public ListSolutionsResult call() throws Exception {
                ListSolutionsResult result = null;
                try {
                    result = AmazonPersonalizeAsyncClient.this.executeListSolutions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateCampaignResult> updateCampaignAsync(UpdateCampaignRequest request) {
        return this.updateCampaignAsync(request, null);
    }

    @Override
    public Future<UpdateCampaignResult> updateCampaignAsync(UpdateCampaignRequest request, final AsyncHandler<UpdateCampaignRequest, UpdateCampaignResult> asyncHandler) {
        final UpdateCampaignRequest finalRequest = (UpdateCampaignRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateCampaignResult>(){

            @Override
            public UpdateCampaignResult call() throws Exception {
                UpdateCampaignResult result = null;
                try {
                    result = AmazonPersonalizeAsyncClient.this.executeUpdateCampaign(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

