/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.paymentcryptographydata.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.paymentcryptographydata.model.EncryptionDecryptionAttributes;
import com.amazonaws.services.paymentcryptographydata.model.WrappedKey;
import java.io.Serializable;

public class EncryptDataRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String keyIdentifier;
    private String plainText;
    private EncryptionDecryptionAttributes encryptionAttributes;
    private WrappedKey wrappedKey;

    public void setKeyIdentifier(String keyIdentifier) {
        this.keyIdentifier = keyIdentifier;
    }

    public String getKeyIdentifier() {
        return this.keyIdentifier;
    }

    public EncryptDataRequest withKeyIdentifier(String keyIdentifier) {
        this.setKeyIdentifier(keyIdentifier);
        return this;
    }

    public void setPlainText(String plainText) {
        this.plainText = plainText;
    }

    public String getPlainText() {
        return this.plainText;
    }

    public EncryptDataRequest withPlainText(String plainText) {
        this.setPlainText(plainText);
        return this;
    }

    public void setEncryptionAttributes(EncryptionDecryptionAttributes encryptionAttributes) {
        this.encryptionAttributes = encryptionAttributes;
    }

    public EncryptionDecryptionAttributes getEncryptionAttributes() {
        return this.encryptionAttributes;
    }

    public EncryptDataRequest withEncryptionAttributes(EncryptionDecryptionAttributes encryptionAttributes) {
        this.setEncryptionAttributes(encryptionAttributes);
        return this;
    }

    public void setWrappedKey(WrappedKey wrappedKey) {
        this.wrappedKey = wrappedKey;
    }

    public WrappedKey getWrappedKey() {
        return this.wrappedKey;
    }

    public EncryptDataRequest withWrappedKey(WrappedKey wrappedKey) {
        this.setWrappedKey(wrappedKey);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getKeyIdentifier() != null) {
            sb.append("KeyIdentifier: ").append(this.getKeyIdentifier()).append(",");
        }
        if (this.getPlainText() != null) {
            sb.append("PlainText: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getEncryptionAttributes() != null) {
            sb.append("EncryptionAttributes: ").append(this.getEncryptionAttributes()).append(",");
        }
        if (this.getWrappedKey() != null) {
            sb.append("WrappedKey: ").append(this.getWrappedKey());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptDataRequest)) {
            return false;
        }
        EncryptDataRequest other = (EncryptDataRequest)obj;
        if (other.getKeyIdentifier() == null ^ this.getKeyIdentifier() == null) {
            return false;
        }
        if (other.getKeyIdentifier() != null && !other.getKeyIdentifier().equals(this.getKeyIdentifier())) {
            return false;
        }
        if (other.getPlainText() == null ^ this.getPlainText() == null) {
            return false;
        }
        if (other.getPlainText() != null && !other.getPlainText().equals(this.getPlainText())) {
            return false;
        }
        if (other.getEncryptionAttributes() == null ^ this.getEncryptionAttributes() == null) {
            return false;
        }
        if (other.getEncryptionAttributes() != null && !other.getEncryptionAttributes().equals(this.getEncryptionAttributes())) {
            return false;
        }
        if (other.getWrappedKey() == null ^ this.getWrappedKey() == null) {
            return false;
        }
        return other.getWrappedKey() == null || other.getWrappedKey().equals(this.getWrappedKey());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getKeyIdentifier() == null ? 0 : this.getKeyIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getPlainText() == null ? 0 : this.getPlainText().hashCode());
        hashCode = 31 * hashCode + (this.getEncryptionAttributes() == null ? 0 : this.getEncryptionAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getWrappedKey() == null ? 0 : this.getWrappedKey().hashCode());
        return hashCode;
    }

    public EncryptDataRequest clone() {
        return (EncryptDataRequest)super.clone();
    }
}

