/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.paymentcryptographydata.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.paymentcryptographydata.model.ReEncryptionAttributes;

@SdkInternalApi
public class ReEncryptionAttributesMarshaller {
    private static final MarshallingInfo<StructuredPojo> SYMMETRIC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Symmetric").build();
    private static final MarshallingInfo<StructuredPojo> DUKPT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Dukpt").build();
    private static final ReEncryptionAttributesMarshaller instance = new ReEncryptionAttributesMarshaller();

    public static ReEncryptionAttributesMarshaller getInstance() {
        return instance;
    }

    public void marshall(ReEncryptionAttributes reEncryptionAttributes, ProtocolMarshaller protocolMarshaller) {
        if (reEncryptionAttributes == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)reEncryptionAttributes.getSymmetric(), SYMMETRIC_BINDING);
            protocolMarshaller.marshall((Object)reEncryptionAttributes.getDukpt(), DUKPT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

