/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.paymentcryptography.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.paymentcryptography.model.KeyAlgorithm;
import com.amazonaws.services.paymentcryptography.model.KeyClass;
import com.amazonaws.services.paymentcryptography.model.KeyModesOfUse;
import com.amazonaws.services.paymentcryptography.model.KeyUsage;
import com.amazonaws.services.paymentcryptography.model.transform.KeyAttributesMarshaller;
import java.io.Serializable;

public class KeyAttributes
implements Serializable,
Cloneable,
StructuredPojo {
    private String keyAlgorithm;
    private String keyClass;
    private KeyModesOfUse keyModesOfUse;
    private String keyUsage;

    public void setKeyAlgorithm(String keyAlgorithm) {
        this.keyAlgorithm = keyAlgorithm;
    }

    public String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public KeyAttributes withKeyAlgorithm(String keyAlgorithm) {
        this.setKeyAlgorithm(keyAlgorithm);
        return this;
    }

    public KeyAttributes withKeyAlgorithm(KeyAlgorithm keyAlgorithm) {
        this.keyAlgorithm = keyAlgorithm.toString();
        return this;
    }

    public void setKeyClass(String keyClass) {
        this.keyClass = keyClass;
    }

    public String getKeyClass() {
        return this.keyClass;
    }

    public KeyAttributes withKeyClass(String keyClass) {
        this.setKeyClass(keyClass);
        return this;
    }

    public KeyAttributes withKeyClass(KeyClass keyClass) {
        this.keyClass = keyClass.toString();
        return this;
    }

    public void setKeyModesOfUse(KeyModesOfUse keyModesOfUse) {
        this.keyModesOfUse = keyModesOfUse;
    }

    public KeyModesOfUse getKeyModesOfUse() {
        return this.keyModesOfUse;
    }

    public KeyAttributes withKeyModesOfUse(KeyModesOfUse keyModesOfUse) {
        this.setKeyModesOfUse(keyModesOfUse);
        return this;
    }

    public void setKeyUsage(String keyUsage) {
        this.keyUsage = keyUsage;
    }

    public String getKeyUsage() {
        return this.keyUsage;
    }

    public KeyAttributes withKeyUsage(String keyUsage) {
        this.setKeyUsage(keyUsage);
        return this;
    }

    public KeyAttributes withKeyUsage(KeyUsage keyUsage) {
        this.keyUsage = keyUsage.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getKeyAlgorithm() != null) {
            sb.append("KeyAlgorithm: ").append(this.getKeyAlgorithm()).append(",");
        }
        if (this.getKeyClass() != null) {
            sb.append("KeyClass: ").append(this.getKeyClass()).append(",");
        }
        if (this.getKeyModesOfUse() != null) {
            sb.append("KeyModesOfUse: ").append(this.getKeyModesOfUse()).append(",");
        }
        if (this.getKeyUsage() != null) {
            sb.append("KeyUsage: ").append(this.getKeyUsage());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyAttributes)) {
            return false;
        }
        KeyAttributes other = (KeyAttributes)obj;
        if (other.getKeyAlgorithm() == null ^ this.getKeyAlgorithm() == null) {
            return false;
        }
        if (other.getKeyAlgorithm() != null && !other.getKeyAlgorithm().equals(this.getKeyAlgorithm())) {
            return false;
        }
        if (other.getKeyClass() == null ^ this.getKeyClass() == null) {
            return false;
        }
        if (other.getKeyClass() != null && !other.getKeyClass().equals(this.getKeyClass())) {
            return false;
        }
        if (other.getKeyModesOfUse() == null ^ this.getKeyModesOfUse() == null) {
            return false;
        }
        if (other.getKeyModesOfUse() != null && !other.getKeyModesOfUse().equals(this.getKeyModesOfUse())) {
            return false;
        }
        if (other.getKeyUsage() == null ^ this.getKeyUsage() == null) {
            return false;
        }
        return other.getKeyUsage() == null || other.getKeyUsage().equals(this.getKeyUsage());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getKeyAlgorithm() == null ? 0 : this.getKeyAlgorithm().hashCode());
        hashCode = 31 * hashCode + (this.getKeyClass() == null ? 0 : this.getKeyClass().hashCode());
        hashCode = 31 * hashCode + (this.getKeyModesOfUse() == null ? 0 : this.getKeyModesOfUse().hashCode());
        hashCode = 31 * hashCode + (this.getKeyUsage() == null ? 0 : this.getKeyUsage().hashCode());
        return hashCode;
    }

    public KeyAttributes clone() {
        try {
            return (KeyAttributes)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KeyAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

