/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.osis;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.osis.AmazonOSISAsync;
import com.amazonaws.services.osis.AmazonOSISAsyncClientBuilder;
import com.amazonaws.services.osis.AmazonOSISClient;
import com.amazonaws.services.osis.model.CreatePipelineRequest;
import com.amazonaws.services.osis.model.CreatePipelineResult;
import com.amazonaws.services.osis.model.DeletePipelineRequest;
import com.amazonaws.services.osis.model.DeletePipelineResult;
import com.amazonaws.services.osis.model.GetPipelineBlueprintRequest;
import com.amazonaws.services.osis.model.GetPipelineBlueprintResult;
import com.amazonaws.services.osis.model.GetPipelineChangeProgressRequest;
import com.amazonaws.services.osis.model.GetPipelineChangeProgressResult;
import com.amazonaws.services.osis.model.GetPipelineRequest;
import com.amazonaws.services.osis.model.GetPipelineResult;
import com.amazonaws.services.osis.model.ListPipelineBlueprintsRequest;
import com.amazonaws.services.osis.model.ListPipelineBlueprintsResult;
import com.amazonaws.services.osis.model.ListPipelinesRequest;
import com.amazonaws.services.osis.model.ListPipelinesResult;
import com.amazonaws.services.osis.model.ListTagsForResourceRequest;
import com.amazonaws.services.osis.model.ListTagsForResourceResult;
import com.amazonaws.services.osis.model.StartPipelineRequest;
import com.amazonaws.services.osis.model.StartPipelineResult;
import com.amazonaws.services.osis.model.StopPipelineRequest;
import com.amazonaws.services.osis.model.StopPipelineResult;
import com.amazonaws.services.osis.model.TagResourceRequest;
import com.amazonaws.services.osis.model.TagResourceResult;
import com.amazonaws.services.osis.model.UntagResourceRequest;
import com.amazonaws.services.osis.model.UntagResourceResult;
import com.amazonaws.services.osis.model.UpdatePipelineRequest;
import com.amazonaws.services.osis.model.UpdatePipelineResult;
import com.amazonaws.services.osis.model.ValidatePipelineRequest;
import com.amazonaws.services.osis.model.ValidatePipelineResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonOSISAsyncClient
extends AmazonOSISClient
implements AmazonOSISAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonOSISAsyncClientBuilder asyncBuilder() {
        return AmazonOSISAsyncClientBuilder.standard();
    }

    AmazonOSISAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonOSISAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreatePipelineResult> createPipelineAsync(CreatePipelineRequest request) {
        return this.createPipelineAsync(request, null);
    }

    @Override
    public Future<CreatePipelineResult> createPipelineAsync(CreatePipelineRequest request, final AsyncHandler<CreatePipelineRequest, CreatePipelineResult> asyncHandler) {
        final CreatePipelineRequest finalRequest = (CreatePipelineRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreatePipelineResult>(){

            @Override
            public CreatePipelineResult call() throws Exception {
                CreatePipelineResult result = null;
                try {
                    result = AmazonOSISAsyncClient.this.executeCreatePipeline(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeletePipelineResult> deletePipelineAsync(DeletePipelineRequest request) {
        return this.deletePipelineAsync(request, null);
    }

    @Override
    public Future<DeletePipelineResult> deletePipelineAsync(DeletePipelineRequest request, final AsyncHandler<DeletePipelineRequest, DeletePipelineResult> asyncHandler) {
        final DeletePipelineRequest finalRequest = (DeletePipelineRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeletePipelineResult>(){

            @Override
            public DeletePipelineResult call() throws Exception {
                DeletePipelineResult result = null;
                try {
                    result = AmazonOSISAsyncClient.this.executeDeletePipeline(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetPipelineResult> getPipelineAsync(GetPipelineRequest request) {
        return this.getPipelineAsync(request, null);
    }

    @Override
    public Future<GetPipelineResult> getPipelineAsync(GetPipelineRequest request, final AsyncHandler<GetPipelineRequest, GetPipelineResult> asyncHandler) {
        final GetPipelineRequest finalRequest = (GetPipelineRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetPipelineResult>(){

            @Override
            public GetPipelineResult call() throws Exception {
                GetPipelineResult result = null;
                try {
                    result = AmazonOSISAsyncClient.this.executeGetPipeline(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetPipelineBlueprintResult> getPipelineBlueprintAsync(GetPipelineBlueprintRequest request) {
        return this.getPipelineBlueprintAsync(request, null);
    }

    @Override
    public Future<GetPipelineBlueprintResult> getPipelineBlueprintAsync(GetPipelineBlueprintRequest request, final AsyncHandler<GetPipelineBlueprintRequest, GetPipelineBlueprintResult> asyncHandler) {
        final GetPipelineBlueprintRequest finalRequest = (GetPipelineBlueprintRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetPipelineBlueprintResult>(){

            @Override
            public GetPipelineBlueprintResult call() throws Exception {
                GetPipelineBlueprintResult result = null;
                try {
                    result = AmazonOSISAsyncClient.this.executeGetPipelineBlueprint(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetPipelineChangeProgressResult> getPipelineChangeProgressAsync(GetPipelineChangeProgressRequest request) {
        return this.getPipelineChangeProgressAsync(request, null);
    }

    @Override
    public Future<GetPipelineChangeProgressResult> getPipelineChangeProgressAsync(GetPipelineChangeProgressRequest request, final AsyncHandler<GetPipelineChangeProgressRequest, GetPipelineChangeProgressResult> asyncHandler) {
        final GetPipelineChangeProgressRequest finalRequest = (GetPipelineChangeProgressRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetPipelineChangeProgressResult>(){

            @Override
            public GetPipelineChangeProgressResult call() throws Exception {
                GetPipelineChangeProgressResult result = null;
                try {
                    result = AmazonOSISAsyncClient.this.executeGetPipelineChangeProgress(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPipelineBlueprintsResult> listPipelineBlueprintsAsync(ListPipelineBlueprintsRequest request) {
        return this.listPipelineBlueprintsAsync(request, null);
    }

    @Override
    public Future<ListPipelineBlueprintsResult> listPipelineBlueprintsAsync(ListPipelineBlueprintsRequest request, final AsyncHandler<ListPipelineBlueprintsRequest, ListPipelineBlueprintsResult> asyncHandler) {
        final ListPipelineBlueprintsRequest finalRequest = (ListPipelineBlueprintsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPipelineBlueprintsResult>(){

            @Override
            public ListPipelineBlueprintsResult call() throws Exception {
                ListPipelineBlueprintsResult result = null;
                try {
                    result = AmazonOSISAsyncClient.this.executeListPipelineBlueprints(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPipelinesResult> listPipelinesAsync(ListPipelinesRequest request) {
        return this.listPipelinesAsync(request, null);
    }

    @Override
    public Future<ListPipelinesResult> listPipelinesAsync(ListPipelinesRequest request, final AsyncHandler<ListPipelinesRequest, ListPipelinesResult> asyncHandler) {
        final ListPipelinesRequest finalRequest = (ListPipelinesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPipelinesResult>(){

            @Override
            public ListPipelinesResult call() throws Exception {
                ListPipelinesResult result = null;
                try {
                    result = AmazonOSISAsyncClient.this.executeListPipelines(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonOSISAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartPipelineResult> startPipelineAsync(StartPipelineRequest request) {
        return this.startPipelineAsync(request, null);
    }

    @Override
    public Future<StartPipelineResult> startPipelineAsync(StartPipelineRequest request, final AsyncHandler<StartPipelineRequest, StartPipelineResult> asyncHandler) {
        final StartPipelineRequest finalRequest = (StartPipelineRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartPipelineResult>(){

            @Override
            public StartPipelineResult call() throws Exception {
                StartPipelineResult result = null;
                try {
                    result = AmazonOSISAsyncClient.this.executeStartPipeline(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopPipelineResult> stopPipelineAsync(StopPipelineRequest request) {
        return this.stopPipelineAsync(request, null);
    }

    @Override
    public Future<StopPipelineResult> stopPipelineAsync(StopPipelineRequest request, final AsyncHandler<StopPipelineRequest, StopPipelineResult> asyncHandler) {
        final StopPipelineRequest finalRequest = (StopPipelineRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopPipelineResult>(){

            @Override
            public StopPipelineResult call() throws Exception {
                StopPipelineResult result = null;
                try {
                    result = AmazonOSISAsyncClient.this.executeStopPipeline(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonOSISAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonOSISAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdatePipelineResult> updatePipelineAsync(UpdatePipelineRequest request) {
        return this.updatePipelineAsync(request, null);
    }

    @Override
    public Future<UpdatePipelineResult> updatePipelineAsync(UpdatePipelineRequest request, final AsyncHandler<UpdatePipelineRequest, UpdatePipelineResult> asyncHandler) {
        final UpdatePipelineRequest finalRequest = (UpdatePipelineRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdatePipelineResult>(){

            @Override
            public UpdatePipelineResult call() throws Exception {
                UpdatePipelineResult result = null;
                try {
                    result = AmazonOSISAsyncClient.this.executeUpdatePipeline(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ValidatePipelineResult> validatePipelineAsync(ValidatePipelineRequest request) {
        return this.validatePipelineAsync(request, null);
    }

    @Override
    public Future<ValidatePipelineResult> validatePipelineAsync(ValidatePipelineRequest request, final AsyncHandler<ValidatePipelineRequest, ValidatePipelineResult> asyncHandler) {
        final ValidatePipelineRequest finalRequest = (ValidatePipelineRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ValidatePipelineResult>(){

            @Override
            public ValidatePipelineResult call() throws Exception {
                ValidatePipelineResult result = null;
                try {
                    result = AmazonOSISAsyncClient.this.executeValidatePipeline(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

