/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticfilesystem.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elasticfilesystem.model.MountTargetDescription;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeMountTargetsResult
implements Serializable,
Cloneable {
    private String marker;
    private ListWithAutoConstructFlag<MountTargetDescription> mountTargets;
    private String nextMarker;

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public DescribeMountTargetsResult withMarker(String marker) {
        this.marker = marker;
        return this;
    }

    public List<MountTargetDescription> getMountTargets() {
        if (this.mountTargets == null) {
            this.mountTargets = new ListWithAutoConstructFlag();
            this.mountTargets.setAutoConstruct(true);
        }
        return this.mountTargets;
    }

    public void setMountTargets(Collection<MountTargetDescription> mountTargets) {
        if (mountTargets == null) {
            this.mountTargets = null;
            return;
        }
        ListWithAutoConstructFlag mountTargetsCopy = new ListWithAutoConstructFlag(mountTargets.size());
        mountTargetsCopy.addAll(mountTargets);
        this.mountTargets = mountTargetsCopy;
    }

    public DescribeMountTargetsResult withMountTargets(MountTargetDescription ... mountTargets) {
        if (this.getMountTargets() == null) {
            this.setMountTargets(new ArrayList<MountTargetDescription>(mountTargets.length));
        }
        for (MountTargetDescription value : mountTargets) {
            this.getMountTargets().add(value);
        }
        return this;
    }

    public DescribeMountTargetsResult withMountTargets(Collection<MountTargetDescription> mountTargets) {
        if (mountTargets == null) {
            this.mountTargets = null;
        } else {
            ListWithAutoConstructFlag mountTargetsCopy = new ListWithAutoConstructFlag(mountTargets.size());
            mountTargetsCopy.addAll(mountTargets);
            this.mountTargets = mountTargetsCopy;
        }
        return this;
    }

    public String getNextMarker() {
        return this.nextMarker;
    }

    public void setNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
    }

    public DescribeMountTargetsResult withNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMarker() != null) {
            sb.append("Marker: " + this.getMarker() + ",");
        }
        if (this.getMountTargets() != null) {
            sb.append("MountTargets: " + this.getMountTargets() + ",");
        }
        if (this.getNextMarker() != null) {
            sb.append("NextMarker: " + this.getNextMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        hashCode = 31 * hashCode + (this.getMountTargets() == null ? 0 : this.getMountTargets().hashCode());
        hashCode = 31 * hashCode + (this.getNextMarker() == null ? 0 : this.getNextMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMountTargetsResult)) {
            return false;
        }
        DescribeMountTargetsResult other = (DescribeMountTargetsResult)obj;
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        if (other.getMarker() != null && !other.getMarker().equals(this.getMarker())) {
            return false;
        }
        if (other.getMountTargets() == null ^ this.getMountTargets() == null) {
            return false;
        }
        if (other.getMountTargets() != null && !other.getMountTargets().equals(this.getMountTargets())) {
            return false;
        }
        if (other.getNextMarker() == null ^ this.getNextMarker() == null) {
            return false;
        }
        return other.getNextMarker() == null || other.getNextMarker().equals(this.getNextMarker());
    }

    public DescribeMountTargetsResult clone() {
        try {
            return (DescribeMountTargetsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

