/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticfilesystem;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.elasticfilesystem.AmazonElasticFileSystemAsync;
import com.amazonaws.services.elasticfilesystem.AmazonElasticFileSystemClient;
import com.amazonaws.services.elasticfilesystem.model.CreateFileSystemRequest;
import com.amazonaws.services.elasticfilesystem.model.CreateFileSystemResult;
import com.amazonaws.services.elasticfilesystem.model.CreateMountTargetRequest;
import com.amazonaws.services.elasticfilesystem.model.CreateMountTargetResult;
import com.amazonaws.services.elasticfilesystem.model.CreateTagsRequest;
import com.amazonaws.services.elasticfilesystem.model.DeleteFileSystemRequest;
import com.amazonaws.services.elasticfilesystem.model.DeleteMountTargetRequest;
import com.amazonaws.services.elasticfilesystem.model.DeleteTagsRequest;
import com.amazonaws.services.elasticfilesystem.model.DescribeFileSystemsRequest;
import com.amazonaws.services.elasticfilesystem.model.DescribeFileSystemsResult;
import com.amazonaws.services.elasticfilesystem.model.DescribeMountTargetSecurityGroupsRequest;
import com.amazonaws.services.elasticfilesystem.model.DescribeMountTargetSecurityGroupsResult;
import com.amazonaws.services.elasticfilesystem.model.DescribeMountTargetsRequest;
import com.amazonaws.services.elasticfilesystem.model.DescribeMountTargetsResult;
import com.amazonaws.services.elasticfilesystem.model.DescribeTagsRequest;
import com.amazonaws.services.elasticfilesystem.model.DescribeTagsResult;
import com.amazonaws.services.elasticfilesystem.model.ModifyMountTargetSecurityGroupsRequest;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AmazonElasticFileSystemAsyncClient
extends AmazonElasticFileSystemClient
implements AmazonElasticFileSystemAsync {
    private ExecutorService executorService;
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;

    public AmazonElasticFileSystemAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AmazonElasticFileSystemAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonElasticFileSystemAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonElasticFileSystemAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonElasticFileSystemAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonElasticFileSystemAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonElasticFileSystemAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonElasticFileSystemAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonElasticFileSystemAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<CreateFileSystemResult> createFileSystemAsync(final CreateFileSystemRequest createFileSystemRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateFileSystemResult>(){

            @Override
            public CreateFileSystemResult call() throws Exception {
                return AmazonElasticFileSystemAsyncClient.this.createFileSystem(createFileSystemRequest);
            }
        });
    }

    @Override
    public Future<CreateFileSystemResult> createFileSystemAsync(final CreateFileSystemRequest createFileSystemRequest, final AsyncHandler<CreateFileSystemRequest, CreateFileSystemResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateFileSystemResult>(){

            @Override
            public CreateFileSystemResult call() throws Exception {
                CreateFileSystemResult result;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.createFileSystem(createFileSystemRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createFileSystemRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteMountTargetAsync(final DeleteMountTargetRequest deleteMountTargetRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonElasticFileSystemAsyncClient.this.deleteMountTarget(deleteMountTargetRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteMountTargetAsync(final DeleteMountTargetRequest deleteMountTargetRequest, final AsyncHandler<DeleteMountTargetRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonElasticFileSystemAsyncClient.this.deleteMountTarget(deleteMountTargetRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteMountTargetRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeFileSystemsResult> describeFileSystemsAsync(final DescribeFileSystemsRequest describeFileSystemsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeFileSystemsResult>(){

            @Override
            public DescribeFileSystemsResult call() throws Exception {
                return AmazonElasticFileSystemAsyncClient.this.describeFileSystems(describeFileSystemsRequest);
            }
        });
    }

    @Override
    public Future<DescribeFileSystemsResult> describeFileSystemsAsync(final DescribeFileSystemsRequest describeFileSystemsRequest, final AsyncHandler<DescribeFileSystemsRequest, DescribeFileSystemsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeFileSystemsResult>(){

            @Override
            public DescribeFileSystemsResult call() throws Exception {
                DescribeFileSystemsResult result;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.describeFileSystems(describeFileSystemsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeFileSystemsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> createTagsAsync(final CreateTagsRequest createTagsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonElasticFileSystemAsyncClient.this.createTags(createTagsRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> createTagsAsync(final CreateTagsRequest createTagsRequest, final AsyncHandler<CreateTagsRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonElasticFileSystemAsyncClient.this.createTags(createTagsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createTagsRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteFileSystemAsync(final DeleteFileSystemRequest deleteFileSystemRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonElasticFileSystemAsyncClient.this.deleteFileSystem(deleteFileSystemRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteFileSystemAsync(final DeleteFileSystemRequest deleteFileSystemRequest, final AsyncHandler<DeleteFileSystemRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonElasticFileSystemAsyncClient.this.deleteFileSystem(deleteFileSystemRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteFileSystemRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeMountTargetsResult> describeMountTargetsAsync(final DescribeMountTargetsRequest describeMountTargetsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeMountTargetsResult>(){

            @Override
            public DescribeMountTargetsResult call() throws Exception {
                return AmazonElasticFileSystemAsyncClient.this.describeMountTargets(describeMountTargetsRequest);
            }
        });
    }

    @Override
    public Future<DescribeMountTargetsResult> describeMountTargetsAsync(final DescribeMountTargetsRequest describeMountTargetsRequest, final AsyncHandler<DescribeMountTargetsRequest, DescribeMountTargetsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeMountTargetsResult>(){

            @Override
            public DescribeMountTargetsResult call() throws Exception {
                DescribeMountTargetsResult result;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.describeMountTargets(describeMountTargetsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeMountTargetsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateMountTargetResult> createMountTargetAsync(final CreateMountTargetRequest createMountTargetRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateMountTargetResult>(){

            @Override
            public CreateMountTargetResult call() throws Exception {
                return AmazonElasticFileSystemAsyncClient.this.createMountTarget(createMountTargetRequest);
            }
        });
    }

    @Override
    public Future<CreateMountTargetResult> createMountTargetAsync(final CreateMountTargetRequest createMountTargetRequest, final AsyncHandler<CreateMountTargetRequest, CreateMountTargetResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateMountTargetResult>(){

            @Override
            public CreateMountTargetResult call() throws Exception {
                CreateMountTargetResult result;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.createMountTarget(createMountTargetRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createMountTargetRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeMountTargetSecurityGroupsResult> describeMountTargetSecurityGroupsAsync(final DescribeMountTargetSecurityGroupsRequest describeMountTargetSecurityGroupsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeMountTargetSecurityGroupsResult>(){

            @Override
            public DescribeMountTargetSecurityGroupsResult call() throws Exception {
                return AmazonElasticFileSystemAsyncClient.this.describeMountTargetSecurityGroups(describeMountTargetSecurityGroupsRequest);
            }
        });
    }

    @Override
    public Future<DescribeMountTargetSecurityGroupsResult> describeMountTargetSecurityGroupsAsync(final DescribeMountTargetSecurityGroupsRequest describeMountTargetSecurityGroupsRequest, final AsyncHandler<DescribeMountTargetSecurityGroupsRequest, DescribeMountTargetSecurityGroupsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeMountTargetSecurityGroupsResult>(){

            @Override
            public DescribeMountTargetSecurityGroupsResult call() throws Exception {
                DescribeMountTargetSecurityGroupsResult result;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.describeMountTargetSecurityGroups(describeMountTargetSecurityGroupsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeMountTargetSecurityGroupsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> modifyMountTargetSecurityGroupsAsync(final ModifyMountTargetSecurityGroupsRequest modifyMountTargetSecurityGroupsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonElasticFileSystemAsyncClient.this.modifyMountTargetSecurityGroups(modifyMountTargetSecurityGroupsRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> modifyMountTargetSecurityGroupsAsync(final ModifyMountTargetSecurityGroupsRequest modifyMountTargetSecurityGroupsRequest, final AsyncHandler<ModifyMountTargetSecurityGroupsRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonElasticFileSystemAsyncClient.this.modifyMountTargetSecurityGroups(modifyMountTargetSecurityGroupsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(modifyMountTargetSecurityGroupsRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeTagsResult> describeTagsAsync(final DescribeTagsRequest describeTagsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeTagsResult>(){

            @Override
            public DescribeTagsResult call() throws Exception {
                return AmazonElasticFileSystemAsyncClient.this.describeTags(describeTagsRequest);
            }
        });
    }

    @Override
    public Future<DescribeTagsResult> describeTagsAsync(final DescribeTagsRequest describeTagsRequest, final AsyncHandler<DescribeTagsRequest, DescribeTagsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeTagsResult>(){

            @Override
            public DescribeTagsResult call() throws Exception {
                DescribeTagsResult result;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.describeTags(describeTagsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeTagsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteTagsAsync(final DeleteTagsRequest deleteTagsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonElasticFileSystemAsyncClient.this.deleteTags(deleteTagsRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteTagsAsync(final DeleteTagsRequest deleteTagsRequest, final AsyncHandler<DeleteTagsRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonElasticFileSystemAsyncClient.this.deleteTags(deleteTagsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteTagsRequest, null);
                return null;
            }
        });
    }
}

