/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.document.spec;

import com.amazonaws.annotation.Beta;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.dynamodbv2.document.KeyAttribute;
import com.amazonaws.services.dynamodbv2.document.PrimaryKey;
import com.amazonaws.services.dynamodbv2.document.ScanFilter;
import com.amazonaws.services.dynamodbv2.document.spec.AbstractCollectionSpec;
import com.amazonaws.services.dynamodbv2.model.ConditionalOperator;
import com.amazonaws.services.dynamodbv2.model.ReturnConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.Select;
import com.amazonaws.services.dynamodbv2.xspec.ScanExpressionSpec;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class ScanSpec
extends AbstractCollectionSpec<ScanRequest> {
    private Collection<ScanFilter> scanFilters;
    private Map<String, String> nameMap;
    private Map<String, Object> valueMap;
    private Collection<KeyAttribute> exclusiveStartKey;

    public ScanSpec() {
        super(new ScanRequest());
    }

    public Collection<ScanFilter> getScanFilters() {
        return this.scanFilters;
    }

    public ScanSpec withScanFilters(ScanFilter ... scanFilters) {
        if (scanFilters == null) {
            this.scanFilters = null;
        } else {
            LinkedHashSet<String> names = new LinkedHashSet<String>();
            for (ScanFilter e : scanFilters) {
                names.add(e.getAttribute());
            }
            if (names.size() != scanFilters.length) {
                throw new IllegalArgumentException("attribute names must not duplicate in the list of scan filters");
            }
            this.scanFilters = Arrays.asList(scanFilters);
        }
        return this;
    }

    public String getConditionalOperator() {
        return ((ScanRequest)this.getRequest()).getConditionalOperator();
    }

    public ScanSpec withConditionalOperator(ConditionalOperator op) {
        ((ScanRequest)this.getRequest()).setConditionalOperator(op);
        return this;
    }

    public List<String> getAttributesToGet() {
        return ((ScanRequest)this.getRequest()).getAttributesToGet();
    }

    public ScanSpec withAttributesToGet(String ... attributes) {
        if (attributes == null) {
            ((ScanRequest)this.getRequest()).setAttributesToGet(null);
        } else {
            ((ScanRequest)this.getRequest()).setAttributesToGet(Arrays.asList(attributes));
        }
        return this;
    }

    public String getFilterExpression() {
        return ((ScanRequest)this.getRequest()).getFilterExpression();
    }

    public ScanSpec withFilterExpression(String filterExpression) {
        ((ScanRequest)this.getRequest()).setFilterExpression(filterExpression);
        return this;
    }

    public String getProjectionExpression() {
        return ((ScanRequest)this.getRequest()).getProjectionExpression();
    }

    public ScanSpec withProjectionExpression(String projectionExpression) {
        ((ScanRequest)this.getRequest()).setProjectionExpression(projectionExpression);
        return this;
    }

    public Map<String, String> getNameMap() {
        return this.nameMap;
    }

    public ScanSpec withNameMap(Map<String, String> nameMap) {
        this.nameMap = nameMap == null ? null : Collections.unmodifiableMap(new LinkedHashMap<String, String>(nameMap));
        return this;
    }

    public Map<String, Object> getValueMap() {
        return this.valueMap;
    }

    public ScanSpec withValueMap(Map<String, Object> valueMap) {
        this.valueMap = valueMap == null ? null : Collections.unmodifiableMap(new LinkedHashMap<String, Object>(valueMap));
        return this;
    }

    public String getReturnConsumedCapacity() {
        return ((ScanRequest)this.getRequest()).getReturnConsumedCapacity();
    }

    public ScanSpec withReturnConsumedCapacity(ReturnConsumedCapacity capacity) {
        ((ScanRequest)this.getRequest()).setReturnConsumedCapacity(capacity);
        return this;
    }

    public String getSelect() {
        return ((ScanRequest)this.getRequest()).getSelect();
    }

    public ScanSpec withSelect(Select select) {
        ((ScanRequest)this.getRequest()).setSelect(select);
        return this;
    }

    public Integer getSegment() {
        return ((ScanRequest)this.getRequest()).getSegment();
    }

    public ScanSpec withSegment(Integer segment) {
        ((ScanRequest)this.getRequest()).setSegment(segment);
        return this;
    }

    public Integer getTotalSegments() {
        return ((ScanRequest)this.getRequest()).getTotalSegments();
    }

    public ScanSpec withTotalSegments(Integer totalSegments) {
        ((ScanRequest)this.getRequest()).setTotalSegments(totalSegments);
        return this;
    }

    public Collection<KeyAttribute> getExclusiveStartKey() {
        return this.exclusiveStartKey;
    }

    public ScanSpec withExclusiveStartKey(KeyAttribute ... exclusiveStartKey) {
        this.exclusiveStartKey = exclusiveStartKey == null ? null : Arrays.asList(exclusiveStartKey);
        return this;
    }

    public ScanSpec withExclusiveStartKey(PrimaryKey exclusiveStartKey) {
        this.exclusiveStartKey = exclusiveStartKey == null ? null : exclusiveStartKey.getComponents();
        return this;
    }

    public ScanSpec withExclusiveStartKey(String hashKeyName, Object hashKeyValue) {
        return this.withExclusiveStartKey(new KeyAttribute(hashKeyName, hashKeyValue));
    }

    public ScanSpec withExclusiveStartKey(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue) {
        return this.withExclusiveStartKey(new KeyAttribute(hashKeyName, hashKeyValue), new KeyAttribute(rangeKeyName, rangeKeyValue));
    }

    public ScanSpec withMaxResultSize(Integer maxResultSize) {
        this.setMaxResultSize(maxResultSize);
        return this;
    }

    public ScanSpec withMaxResultSize(int maxResultSize) {
        this.setMaxResultSize(maxResultSize);
        return this;
    }

    public ScanSpec withMaxPageSize(Integer maxPageSize) {
        this.setMaxPageSize(maxPageSize);
        return this;
    }

    public ScanSpec withMaxPageSize(int maxPageSize) {
        this.setMaxPageSize(maxPageSize);
        return this;
    }

    public ScanSpec withProgressListener(ProgressListener progressListener) {
        this.setProgressListener(progressListener);
        return this;
    }

    public ScanSpec withRequestMetricCollector(RequestMetricCollector requestMetricCollector) {
        this.setRequestMetricCollector(requestMetricCollector);
        return this;
    }

    @Beta
    public ScanSpec withExpressionSpec(ScanExpressionSpec xspec) {
        return this.withFilterExpression(xspec.getFilterExpression()).withProjectionExpression(xspec.getProjectionExpression()).withNameMap(xspec.getNameMap()).withValueMap(xspec.getValueMap());
    }
}

