/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.retry.RetryUtils;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.datamodeling.AttributeTransformer;
import com.amazonaws.services.dynamodbv2.datamodeling.ConversionSchema;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBDeleteExpression;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBHashKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBIndexHashKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperConfig;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBQueryExpression;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBRangeKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBReflector;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBSaveExpression;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBScanExpression;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTableSchemaParser;
import com.amazonaws.services.dynamodbv2.datamodeling.ItemConverter;
import com.amazonaws.services.dynamodbv2.datamodeling.KeyPair;
import com.amazonaws.services.dynamodbv2.datamodeling.PaginatedParallelScanList;
import com.amazonaws.services.dynamodbv2.datamodeling.PaginatedQueryList;
import com.amazonaws.services.dynamodbv2.datamodeling.PaginatedScanList;
import com.amazonaws.services.dynamodbv2.datamodeling.ParallelScanTask;
import com.amazonaws.services.dynamodbv2.datamodeling.QueryResultPage;
import com.amazonaws.services.dynamodbv2.datamodeling.ReflectionUtils;
import com.amazonaws.services.dynamodbv2.datamodeling.S3ClientCache;
import com.amazonaws.services.dynamodbv2.datamodeling.S3Link;
import com.amazonaws.services.dynamodbv2.datamodeling.ScanResultPage;
import com.amazonaws.services.dynamodbv2.datamodeling.VersionIncrementor;
import com.amazonaws.services.dynamodbv2.model.AttributeAction;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemResult;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemResult;
import com.amazonaws.services.dynamodbv2.model.ComparisonOperator;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.ConditionalOperator;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteRequest;
import com.amazonaws.services.dynamodbv2.model.ExpectedAttributeValue;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemResult;
import com.amazonaws.services.dynamodbv2.model.KeysAndAttributes;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.PutItemResult;
import com.amazonaws.services.dynamodbv2.model.PutRequest;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.QueryResult;
import com.amazonaws.services.dynamodbv2.model.ReturnValue;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import com.amazonaws.services.dynamodbv2.model.Select;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateItemResult;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import com.amazonaws.services.s3.model.Region;
import com.amazonaws.util.VersionInfoUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DynamoDBMapper {
    private final S3ClientCache s3cc;
    private final AmazonDynamoDB db;
    private final DynamoDBMapperConfig config;
    private final DynamoDBReflector reflector = new DynamoDBReflector();
    private final DynamoDBTableSchemaParser schemaParser = new DynamoDBTableSchemaParser();
    private final VersionIncrementor incrementor = new VersionIncrementor();
    private final AttributeTransformer transformer;
    static final long MAX_BACKOFF_IN_MILLISECONDS = 3000L;
    static final int MAX_ITEMS_PER_BATCH = 25;
    static final int BATCH_GET_MAX_RETRY_COUNT_ALL_KEYS = 5;
    private static final String USER_AGENT = DynamoDBMapper.class.getName() + "/" + VersionInfoUtils.getVersion();
    private static final String USER_AGENT_BATCH_OPERATION = DynamoDBMapper.class.getName() + "_batch_operation/" + VersionInfoUtils.getVersion();
    private static final String NO_RANGE_KEY = new String();
    private static final Log log = LogFactory.getLog(DynamoDBMapper.class);

    private static void failFastOnIncompatibleSubclass(Class<?> clazz) {
        while (clazz != DynamoDBMapper.class) {
            Object[] classOverride = new Class[]{Class.class, Map.class};
            Object[] nameOverride = new Class[]{String.class, String.class, Map.class};
            for (Method method : clazz.getDeclaredMethods()) {
                Object[] params;
                if (!method.getName().equals("transformAttributes") || !Arrays.equals(params = method.getParameterTypes(), classOverride) && !Arrays.equals(params, nameOverride)) continue;
                throw new IllegalStateException("The deprecated transformAttributes method is no longer supported as of 1.9.0. Use an AttributeTransformer to inject custom attribute transformation logic.");
            }
            clazz = clazz.getSuperclass();
        }
    }

    public DynamoDBMapper(AmazonDynamoDB dynamoDB) {
        this(dynamoDB, DynamoDBMapperConfig.DEFAULT, null, null);
    }

    public DynamoDBMapper(AmazonDynamoDB dynamoDB, DynamoDBMapperConfig config) {
        this(dynamoDB, config, null, null);
    }

    public DynamoDBMapper(AmazonDynamoDB ddb, AWSCredentialsProvider s3CredentialProvider) {
        this(ddb, DynamoDBMapperConfig.DEFAULT, s3CredentialProvider);
    }

    public DynamoDBMapper(AmazonDynamoDB dynamoDB, DynamoDBMapperConfig config, AttributeTransformer transformer) {
        this(dynamoDB, config, transformer, null);
    }

    public DynamoDBMapper(AmazonDynamoDB dynamoDB, DynamoDBMapperConfig config, AWSCredentialsProvider s3CredentialProvider) {
        this(dynamoDB, config, null, DynamoDBMapper.validate(s3CredentialProvider));
    }

    private static AWSCredentialsProvider validate(AWSCredentialsProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("s3 credentials provider must not be null");
        }
        return provider;
    }

    public DynamoDBMapper(AmazonDynamoDB dynamoDB, DynamoDBMapperConfig config, AttributeTransformer transformer, AWSCredentialsProvider s3CredentialsProvider) {
        DynamoDBMapper.failFastOnIncompatibleSubclass(this.getClass());
        this.db = dynamoDB;
        this.config = config;
        this.transformer = transformer;
        this.s3cc = s3CredentialsProvider == null ? null : new S3ClientCache(s3CredentialsProvider);
    }

    public <T> T load(Class<T> clazz, Object hashKey, DynamoDBMapperConfig config) {
        return this.load(clazz, hashKey, null, config);
    }

    public <T> T load(Class<T> clazz, Object hashKey) {
        return this.load(clazz, hashKey, null, this.config);
    }

    public <T> T load(Class<T> clazz, Object hashKey, Object rangeKey) {
        return this.load(clazz, hashKey, rangeKey, this.config);
    }

    public <T> T load(T keyObject) {
        return this.load(keyObject, this.config);
    }

    public <T> T load(T keyObject, DynamoDBMapperConfig config) {
        Class<?> clazz = keyObject.getClass();
        config = this.mergeConfig(config);
        ItemConverter converter = this.getConverter(config);
        String tableName = this.getTableName(clazz, keyObject, config);
        GetItemRequest rq = (GetItemRequest)new GetItemRequest().withRequestMetricCollector(config.getRequestMetricCollector());
        Map<String, AttributeValue> key = this.getKey(converter, keyObject, clazz);
        rq.setKey(key);
        rq.setTableName(tableName);
        rq.setConsistentRead(config.getConsistentReads() == DynamoDBMapperConfig.ConsistentReads.CONSISTENT);
        GetItemResult item = this.db.getItem(DynamoDBMapper.applyUserAgent(rq));
        Map<String, AttributeValue> itemAttributes = item.getItem();
        if (itemAttributes == null) {
            return null;
        }
        Object object = this.privateMarshallIntoObject(converter, this.toParameters(itemAttributes, clazz, tableName, config));
        return (T)object;
    }

    private <T> Map<String, AttributeValue> getKey(ItemConverter converter, T keyObject) {
        return this.getKey(converter, keyObject, keyObject.getClass());
    }

    private <T> Map<String, AttributeValue> getKey(ItemConverter converter, T keyObject, Class<T> clazz) {
        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
        for (Method keyGetter : this.reflector.getPrimaryKeyGetters(clazz)) {
            Object getterResult;
            AttributeValue keyAttributeValue = converter.convert(keyGetter, getterResult = ReflectionUtils.safeInvoke(keyGetter, keyObject, new Object[0]));
            if (keyAttributeValue == null) {
                throw new DynamoDBMappingException("Null key found for " + keyGetter);
            }
            key.put(this.reflector.getAttributeName(keyGetter), keyAttributeValue);
        }
        if (key.isEmpty()) {
            throw new DynamoDBMappingException("Class must be annotated with " + DynamoDBHashKey.class + " and " + DynamoDBRangeKey.class);
        }
        return key;
    }

    public <T> T load(Class<T> clazz, Object hashKey, Object rangeKey, DynamoDBMapperConfig config) {
        config = this.mergeConfig(config);
        T keyObject = this.createKeyObject(clazz, hashKey, rangeKey);
        return this.load(keyObject, config);
    }

    private <T> T createKeyObject(Class<T> clazz, Object hashKey, Object rangeKey) {
        T keyObject = null;
        try {
            keyObject = clazz.newInstance();
        }
        catch (Exception e) {
            throw new DynamoDBMappingException("Failed to instantiate class", e);
        }
        boolean seenHashKey = false;
        boolean seenRangeKey = false;
        for (Method getter : this.reflector.getPrimaryKeyGetters(clazz)) {
            if (ReflectionUtils.getterOrFieldHasAnnotation(getter, DynamoDBHashKey.class)) {
                if (seenHashKey) {
                    throw new DynamoDBMappingException("Found more than one method annotated with " + DynamoDBHashKey.class + " for class " + clazz + ". Use load(Object) for tables with more than a single hash and range key.");
                }
                seenHashKey = true;
                ReflectionUtils.safeInvoke(this.reflector.getSetter(getter), keyObject, hashKey);
                continue;
            }
            if (!ReflectionUtils.getterOrFieldHasAnnotation(getter, DynamoDBRangeKey.class)) continue;
            if (seenRangeKey) {
                throw new DynamoDBMappingException("Found more than one method annotated with " + DynamoDBRangeKey.class + " for class " + clazz + ". Use load(Object) for tables with more than a single hash and range key.");
            }
            seenRangeKey = true;
            ReflectionUtils.safeInvoke(this.reflector.getSetter(getter), keyObject, rangeKey);
        }
        if (!seenHashKey) {
            throw new DynamoDBMappingException("No method annotated with " + DynamoDBHashKey.class + " for class " + clazz + ".");
        }
        if (rangeKey != null && !seenRangeKey) {
            throw new DynamoDBMappingException("No method annotated with " + DynamoDBRangeKey.class + " for class " + clazz + ".");
        }
        return keyObject;
    }

    private Map<String, Condition> getHashKeyEqualsConditions(ItemConverter converter, Object obj) {
        HashMap<String, Condition> conditions = new HashMap<String, Condition>();
        if (obj == null) {
            return conditions;
        }
        for (Method getter : this.reflector.getRelevantGetters(obj.getClass())) {
            Object getterReturnResult;
            if (!ReflectionUtils.getterOrFieldHasAnnotation(getter, DynamoDBHashKey.class) && !ReflectionUtils.getterOrFieldHasAnnotation(getter, DynamoDBIndexHashKey.class) || (getterReturnResult = ReflectionUtils.safeInvoke(getter, obj, new Object[0])) == null) continue;
            conditions.put(this.reflector.getAttributeName(getter), new Condition().withComparisonOperator(ComparisonOperator.EQ).withAttributeValueList(converter.convert(getter, getterReturnResult)));
        }
        return conditions;
    }

    protected final String getTableName(Class<?> clazz, DynamoDBMapperConfig config) {
        return DynamoDBMapper.internalGetTableName(clazz, null, config);
    }

    protected final String getTableName(Class<?> clazz, Object object, DynamoDBMapperConfig config) {
        return DynamoDBMapper.internalGetTableName(clazz, object, config);
    }

    static String internalGetTableName(Class<?> clazz, Object object, DynamoDBMapperConfig config) {
        DynamoDBMapperConfig.ObjectTableNameResolver objectResolver = config.getObjectTableNameResolver();
        if (object != null && objectResolver != null) {
            return objectResolver.getTableName(object, config);
        }
        DynamoDBMapperConfig.TableNameResolver classResolver = config.getTableNameResolver();
        if (classResolver == null) {
            classResolver = DynamoDBMapperConfig.DefaultTableNameResolver.INSTANCE;
        }
        return classResolver.getTableName(clazz, config);
    }

    public <T> T marshallIntoObject(Class<T> clazz, Map<String, AttributeValue> itemAttributes) {
        ItemConverter converter = this.getConverter(this.config);
        String tableName = this.getTableName(clazz, this.config);
        return this.privateMarshallIntoObject(converter, this.toParameters(itemAttributes, clazz, tableName, this.config));
    }

    private <T> T privateMarshallIntoObject(ItemConverter converter, AttributeTransformer.Parameters<T> parameters) {
        Class<T> clazz = parameters.getModelClass();
        Map<String, AttributeValue> values = this.untransformAttributes(parameters);
        return converter.unconvert(clazz, values);
    }

    public <T> List<T> marshallIntoObjects(Class<T> clazz, List<Map<String, AttributeValue>> itemAttributes) {
        ArrayList<T> result = new ArrayList<T>(itemAttributes.size());
        for (Map<String, AttributeValue> item : itemAttributes) {
            result.add(this.marshallIntoObject(clazz, item));
        }
        return result;
    }

    final <T> List<T> marshallIntoObjects(List<AttributeTransformer.Parameters<T>> parameters) {
        ArrayList<T> result = new ArrayList<T>(parameters.size());
        ItemConverter converter = null;
        if (!parameters.isEmpty()) {
            converter = this.getConverter(parameters.get(0).getMapperConfig());
        }
        for (AttributeTransformer.Parameters<T> entry : parameters) {
            result.add(this.privateMarshallIntoObject(converter, entry));
        }
        return result;
    }

    public <T> void save(T object) {
        this.save(object, null, this.config);
    }

    public <T> void save(T object, DynamoDBSaveExpression saveExpression) {
        this.save(object, saveExpression, this.config);
    }

    private boolean needAutoGenerateAssignableKey(Class<?> clazz, Object object) {
        Collection<Method> keyGetters = this.reflector.getPrimaryKeyGetters(clazz);
        boolean forcePut = false;
        boolean hashKeyGetterFound = false;
        for (Method method : keyGetters) {
            Object getterResult = ReflectionUtils.safeInvoke(method, object, new Object[0]);
            if (getterResult == null && this.reflector.isAssignableKey(method)) {
                forcePut = true;
            }
            if (!ReflectionUtils.getterOrFieldHasAnnotation(method, DynamoDBHashKey.class)) continue;
            hashKeyGetterFound = true;
        }
        if (!hashKeyGetterFound) {
            throw new DynamoDBMappingException("No " + DynamoDBHashKey.class + " annotation found in class " + clazz);
        }
        return forcePut;
    }

    public <T> void save(T object, DynamoDBMapperConfig config) {
        this.save(object, null, config);
    }

    public <T> void save(T object, DynamoDBSaveExpression saveExpression, DynamoDBMapperConfig config) {
        DynamoDBMapperConfig finalConfig = this.mergeConfig(config);
        ItemConverter converter = this.getConverter(finalConfig);
        Class<?> clazz = object.getClass();
        String tableName = this.getTableName(clazz, object, finalConfig);
        boolean forcePut = finalConfig.getSaveBehavior() == DynamoDBMapperConfig.SaveBehavior.CLOBBER || this.needAutoGenerateAssignableKey(clazz, object);
        SaveObjectHandler saveObjectHandler = forcePut ? new SaveObjectHandler(this, clazz, object, tableName, finalConfig, converter, saveExpression){
            {
                DynamoDBMapper dynamoDBMapper2 = x0;
                dynamoDBMapper2.getClass();
                super(x1, x2, x3, x4, x5, x6);
            }

            @Override
            protected void onKeyAttributeValue(String attributeName, AttributeValue keyAttributeValue) {
                this.getAttributeValueUpdates().put(attributeName, new AttributeValueUpdate().withValue(keyAttributeValue).withAction("PUT"));
            }

            @Override
            protected void onNullNonKeyAttribute(String attributeName) {
            }

            @Override
            protected void executeLowLevelRequest() {
                this.doPutItem();
            }
        } : new SaveObjectHandler(this, clazz, object, tableName, finalConfig, converter, saveExpression){
            {
                DynamoDBMapper dynamoDBMapper2 = x0;
                dynamoDBMapper2.getClass();
                super(x1, x2, x3, x4, x5, x6);
            }

            @Override
            protected void onKeyAttributeValue(String attributeName, AttributeValue keyAttributeValue) {
                this.getKeyAttributeValues().put(attributeName, keyAttributeValue);
            }

            @Override
            protected void onNonKeyAttribute(String attributeName, AttributeValue currentValue) {
                if (this.getLocalSaveBehavior() == DynamoDBMapperConfig.SaveBehavior.APPEND_SET && (currentValue.getBS() != null || currentValue.getNS() != null || currentValue.getSS() != null)) {
                    this.getAttributeValueUpdates().put(attributeName, new AttributeValueUpdate().withValue(currentValue).withAction("ADD"));
                    return;
                }
                super.onNonKeyAttribute(attributeName, currentValue);
            }

            @Override
            protected void onNullNonKeyAttribute(String attributeName) {
                if (this.getLocalSaveBehavior() == DynamoDBMapperConfig.SaveBehavior.UPDATE_SKIP_NULL_ATTRIBUTES || this.getLocalSaveBehavior() == DynamoDBMapperConfig.SaveBehavior.APPEND_SET) {
                    return;
                }
                this.getAttributeValueUpdates().put(attributeName, new AttributeValueUpdate().withAction("DELETE"));
            }

            @Override
            protected void executeLowLevelRequest() {
                UpdateItemResult updateItemResult = this.doUpdateItem();
                if (updateItemResult.getAttributes() == null || updateItemResult.getAttributes().isEmpty()) {
                    for (String keyAttributeName : this.getKeyAttributeValues().keySet()) {
                        this.getAttributeValueUpdates().put(keyAttributeName, new AttributeValueUpdate().withValue(this.getKeyAttributeValues().get(keyAttributeName)).withAction("PUT"));
                    }
                    this.doPutItem();
                }
            }
        };
        saveObjectHandler.execute();
    }

    public void delete(Object object) {
        this.delete(object, null, this.config);
    }

    public void delete(Object object, DynamoDBDeleteExpression deleteExpression) {
        this.delete(object, deleteExpression, this.config);
    }

    public void delete(Object object, DynamoDBMapperConfig config) {
        this.delete(object, null, config);
    }

    public <T> void delete(T object, DynamoDBDeleteExpression deleteExpression, DynamoDBMapperConfig config) {
        config = this.mergeConfig(config);
        ItemConverter converter = this.getConverter(config);
        Class<?> clazz = object.getClass();
        String tableName = this.getTableName(clazz, object, config);
        Map<String, AttributeValue> key = this.getKey(converter, object, clazz);
        HashMap<String, ExpectedAttributeValue> internalAssertions = new HashMap<String, ExpectedAttributeValue>();
        if (config.getSaveBehavior() != DynamoDBMapperConfig.SaveBehavior.CLOBBER) {
            for (Method method : this.reflector.getRelevantGetters(clazz)) {
                if (!this.reflector.isVersionAttributeGetter(method)) continue;
                Object getterResult = ReflectionUtils.safeInvoke(method, object, new Object[0]);
                String attributeName = this.reflector.getAttributeName(method);
                ExpectedAttributeValue expected = new ExpectedAttributeValue();
                AttributeValue currentValue = converter.convert(method, getterResult);
                expected.setExists(currentValue != null);
                if (currentValue != null) {
                    expected.setValue(currentValue);
                }
                internalAssertions.put(attributeName, expected);
                break;
            }
        }
        DeleteItemRequest req = (DeleteItemRequest)new DeleteItemRequest().withKey(key).withTableName(tableName).withExpected(internalAssertions).withRequestMetricCollector(config.getRequestMetricCollector());
        if (deleteExpression != null) {
            String conditionalExpression = deleteExpression.getConditionExpression();
            if (conditionalExpression != null) {
                if (internalAssertions != null && !internalAssertions.isEmpty()) {
                    throw new AmazonClientException("Condition Expressions cannot be used if a versioned attribute is present");
                }
                req = req.withConditionExpression(conditionalExpression).withExpressionAttributeNames(deleteExpression.getExpressionAttributeNames()).withExpressionAttributeValues(deleteExpression.getExpressionAttributeValues());
            }
            req = req.withExpected(DynamoDBMapper.mergeExpectedAttributeValueConditions(internalAssertions, deleteExpression.getExpected(), deleteExpression.getConditionalOperator())).withConditionalOperator(deleteExpression.getConditionalOperator());
        }
        this.db.deleteItem(DynamoDBMapper.applyUserAgent(req));
    }

    public List<FailedBatch> batchDelete(List<? extends Object> objectsToDelete) {
        return this.batchWrite(Collections.emptyList(), objectsToDelete, this.config);
    }

    public List<FailedBatch> batchDelete(Object ... objectsToDelete) {
        return this.batchWrite(Collections.emptyList(), Arrays.asList(objectsToDelete), this.config);
    }

    public List<FailedBatch> batchSave(List<? extends Object> objectsToSave) {
        return this.batchWrite(objectsToSave, Collections.emptyList(), this.config);
    }

    public List<FailedBatch> batchSave(Object ... objectsToSave) {
        return this.batchWrite(Arrays.asList(objectsToSave), Collections.emptyList(), this.config);
    }

    public List<FailedBatch> batchWrite(List<? extends Object> objectsToWrite, List<? extends Object> objectsToDelete) {
        return this.batchWrite(objectsToWrite, objectsToDelete, this.config);
    }

    /*
     * WARNING - void declaration
     */
    public List<FailedBatch> batchWrite(List<? extends Object> objectsToWrite, List<? extends Object> objectsToDelete, DynamoDBMapperConfig config) {
        String tableName;
        Class<?> clazz;
        config = this.mergeConfig(config);
        LinkedList<FailedBatch> totalFailedBatches = new LinkedList<FailedBatch>();
        HashMap requestItems = new HashMap();
        ItemConverter converter = this.getConverter(config);
        LinkedList<ValueUpdate> inMemoryUpdates = new LinkedList<ValueUpdate>();
        for (Object object : objectsToWrite) {
            clazz = object.getClass();
            tableName = this.getTableName(clazz, object, config);
            HashMap<String, AttributeValue> attributeValues = new HashMap<String, AttributeValue>();
            for (Method method : this.reflector.getRelevantGetters(clazz)) {
                Object getterResult = ReflectionUtils.safeInvoke(method, object, new Object[0]);
                String attributeName = this.reflector.getAttributeName(method);
                AttributeValue currentValue = null;
                if (getterResult == null && this.reflector.isAssignableKey(method)) {
                    currentValue = this.getAutoGeneratedKeyAttributeValue(converter, method);
                    inMemoryUpdates.add(new ValueUpdate(method, currentValue, object, converter));
                } else {
                    currentValue = converter.convert(method, getterResult);
                }
                if (currentValue == null) continue;
                attributeValues.put(attributeName, currentValue);
            }
            if (!requestItems.containsKey(tableName)) {
                requestItems.put(tableName, new LinkedList());
            }
            AttributeTransformer.Parameters<?> parameters = this.toParameters(attributeValues, clazz, tableName, config);
            ((List)requestItems.get(tableName)).add(new WriteRequest().withPutRequest(new PutRequest().withItem(this.transformAttributes(parameters))));
        }
        for (Object object : objectsToDelete) {
            clazz = object.getClass();
            tableName = this.getTableName(clazz, object, config);
            Map<String, AttributeValue> key = this.getKey(converter, object);
            if (!requestItems.containsKey(tableName)) {
                requestItems.put(tableName, new LinkedList());
            }
            ((List)requestItems.get(tableName)).add(new WriteRequest().withDeleteRequest(new DeleteRequest().withKey(key)));
        }
        while (!requestItems.isEmpty()) {
            void var9_13;
            HashMap<String, List<WriteRequest>> batch = new HashMap<String, List<WriteRequest>>();
            boolean bl = false;
            Iterator tableIter = requestItems.entrySet().iterator();
            while (tableIter.hasNext() && var9_13 < 25) {
                Map.Entry tableRequest = tableIter.next();
                batch.put((String)tableRequest.getKey(), new LinkedList());
                Iterator writeRequestIter = ((List)tableRequest.getValue()).iterator();
                while (writeRequestIter.hasNext() && ++var9_13 < 25) {
                    WriteRequest writeRequest = (WriteRequest)writeRequestIter.next();
                    batch.get(tableRequest.getKey()).add(writeRequest);
                    writeRequestIter.remove();
                }
                if (writeRequestIter.hasNext()) continue;
                tableIter.remove();
            }
            List<FailedBatch> failedBatches = this.writeOneBatch(batch);
            if (failedBatches == null) continue;
            totalFailedBatches.addAll(failedBatches);
            if (!this.containsThrottlingException(failedBatches)) continue;
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new AmazonClientException(e.getMessage(), e);
            }
        }
        for (ValueUpdate valueUpdate : inMemoryUpdates) {
            valueUpdate.apply();
        }
        return totalFailedBatches;
    }

    private List<FailedBatch> writeOneBatch(Map<String, List<WriteRequest>> batch) {
        LinkedList<FailedBatch> failedBatches = new LinkedList<FailedBatch>();
        HashMap<String, List<WriteRequest>> firstHalfBatch = new HashMap<String, List<WriteRequest>>();
        HashMap<String, List<WriteRequest>> secondHalfBatch = new HashMap<String, List<WriteRequest>>();
        FailedBatch failedBatch = this.callUntilCompletion(batch);
        if (failedBatch != null) {
            if (failedBatch.getException() instanceof AmazonServiceException && RetryUtils.isRequestEntityTooLargeException((AmazonServiceException)failedBatch.getException())) {
                if (this.computeFailedBatchSize(failedBatch) == 1) {
                    failedBatches.add(failedBatch);
                } else {
                    this.divideBatch(batch, firstHalfBatch, secondHalfBatch);
                    failedBatches.addAll(this.writeOneBatch(firstHalfBatch));
                    failedBatches.addAll(this.writeOneBatch(secondHalfBatch));
                }
            } else {
                failedBatches.add(failedBatch);
            }
        }
        return failedBatches;
    }

    private boolean containsThrottlingException(List<FailedBatch> failedBatches) {
        for (FailedBatch failedBatch : failedBatches) {
            Exception e = failedBatch.getException();
            if (!(e instanceof AmazonServiceException) || !RetryUtils.isThrottlingException((AmazonServiceException)e)) continue;
            return true;
        }
        return false;
    }

    private void divideBatch(Map<String, List<WriteRequest>> batch, Map<String, List<WriteRequest>> firstHalfBatch, Map<String, List<WriteRequest>> secondHalfBatch) {
        for (String key : batch.keySet()) {
            List<WriteRequest> requests = batch.get(key);
            List<WriteRequest> firstHalfRequests = requests.subList(0, requests.size() / 2);
            List<WriteRequest> secondHalfRequests = requests.subList(requests.size() / 2, requests.size());
            firstHalfBatch.put(key, firstHalfRequests);
            secondHalfBatch.put(key, secondHalfRequests);
        }
    }

    private int computeFailedBatchSize(FailedBatch failedBatch) {
        int count = 0;
        for (String tableName : failedBatch.getUnprocessedItems().keySet()) {
            count += failedBatch.getUnprocessedItems().get(tableName).size();
        }
        return count;
    }

    private FailedBatch callUntilCompletion(Map<String, List<WriteRequest>> batch) {
        BatchWriteItemResult result = null;
        int retries = 0;
        FailedBatch failedBatch = null;
        while (true) {
            try {
                result = this.db.batchWriteItem(DynamoDBMapper.applyBatchOperationUserAgent(new BatchWriteItemRequest().withRequestItems(batch)));
            }
            catch (Exception e) {
                failedBatch = new FailedBatch();
                failedBatch.setUnprocessedItems(batch);
                failedBatch.setException(e);
                return failedBatch;
            }
            ++retries;
            batch = result.getUnprocessedItems();
            if (batch.size() <= 0) break;
            this.pauseExponentially(retries);
        }
        return failedBatch;
    }

    public Map<String, List<Object>> batchLoad(List<Object> itemsToGet) {
        return this.batchLoad(itemsToGet, this.config);
    }

    public Map<String, List<Object>> batchLoad(List<Object> itemsToGet, DynamoDBMapperConfig config) {
        boolean consistentReads;
        boolean bl = consistentReads = (config = this.mergeConfig(config)).getConsistentReads() == DynamoDBMapperConfig.ConsistentReads.CONSISTENT;
        if (itemsToGet == null || itemsToGet.isEmpty()) {
            return new HashMap<String, List<Object>>();
        }
        HashMap<String, KeysAndAttributes> requestItems = new HashMap<String, KeysAndAttributes>();
        HashMap classesByTableName = new HashMap();
        HashMap<String, List<Object>> resultSet = new HashMap<String, List<Object>>();
        int count = 0;
        ItemConverter converter = this.getConverter(config);
        for (Object keyObject : itemsToGet) {
            Class<?> clazz = keyObject.getClass();
            String tableName = this.getTableName(clazz, keyObject, config);
            classesByTableName.put(tableName, clazz);
            if (!requestItems.containsKey(tableName)) {
                requestItems.put(tableName, new KeysAndAttributes().withConsistentRead(consistentReads).withKeys(new LinkedList<Map<String, AttributeValue>>()));
            }
            ((KeysAndAttributes)requestItems.get(tableName)).getKeys().add(this.getKey(converter, keyObject));
            if (++count != 100) continue;
            this.processBatchGetRequest(classesByTableName, requestItems, resultSet, config, converter);
            requestItems.clear();
            count = 0;
        }
        if (count > 0) {
            this.processBatchGetRequest(classesByTableName, requestItems, resultSet, config, converter);
        }
        return resultSet;
    }

    public Map<String, List<Object>> batchLoad(Map<Class<?>, List<KeyPair>> itemsToGet) {
        return this.batchLoad(itemsToGet, this.config);
    }

    public Map<String, List<Object>> batchLoad(Map<Class<?>, List<KeyPair>> itemsToGet, DynamoDBMapperConfig config) {
        ArrayList<Object> keys = new ArrayList<Object>();
        if (itemsToGet != null) {
            for (Class<?> clazz : itemsToGet.keySet()) {
                if (itemsToGet.get(clazz) == null) continue;
                for (KeyPair keyPair : itemsToGet.get(clazz)) {
                    keys.add(this.createKeyObject(clazz, keyPair.getHashKey(), keyPair.getRangeKey()));
                }
            }
        }
        return this.batchLoad(keys, config);
    }

    private void processBatchGetRequest(Map<String, Class<?>> classesByTableName, Map<String, KeysAndAttributes> requestItems, Map<String, List<Object>> resultSet, DynamoDBMapperConfig config, ItemConverter converter) {
        BatchGetItemResult batchGetItemResult = null;
        BatchGetItemRequest batchGetItemRequest = (BatchGetItemRequest)new BatchGetItemRequest().withRequestMetricCollector(config.getRequestMetricCollector());
        batchGetItemRequest.setRequestItems(requestItems);
        int retries = 0;
        int noOfItemsInOriginalRequest = requestItems.size();
        do {
            if (batchGetItemResult != null) {
                ++retries;
                if (noOfItemsInOriginalRequest == batchGetItemResult.getUnprocessedKeys().size()) {
                    this.pauseExponentially(retries);
                    if (retries > 5) {
                        throw new AmazonClientException("Batch Get Item request to server hasn't received any data. Please try again later.");
                    }
                }
                batchGetItemRequest.setRequestItems(batchGetItemResult.getUnprocessedKeys());
            }
            batchGetItemResult = this.db.batchGetItem(DynamoDBMapper.applyBatchOperationUserAgent(batchGetItemRequest));
            Map<String, List<Map<String, AttributeValue>>> responses = batchGetItemResult.getResponses();
            for (String tableName : responses.keySet()) {
                List<Object> objects = null;
                objects = resultSet.get(tableName) != null ? resultSet.get(tableName) : new LinkedList();
                Class<?> clazz = classesByTableName.get(tableName);
                for (Map<String, AttributeValue> item : responses.get(tableName)) {
                    AttributeTransformer.Parameters<?> parameters = this.toParameters(item, clazz, tableName, config);
                    objects.add(this.privateMarshallIntoObject(converter, parameters));
                }
                resultSet.put(tableName, objects);
            }
        } while (batchGetItemResult.getUnprocessedKeys() != null && batchGetItemResult.getUnprocessedKeys().size() > 0);
    }

    private Map<String, AttributeValue> convertToItem(Map<String, AttributeValueUpdate> putValues) {
        HashMap<String, AttributeValue> map = new HashMap<String, AttributeValue>();
        for (Map.Entry<String, AttributeValueUpdate> entry : putValues.entrySet()) {
            String attributeName = entry.getKey();
            AttributeValue attributeValue = entry.getValue().getValue();
            String attributeAction = entry.getValue().getAction();
            if (attributeValue == null || AttributeAction.DELETE.toString().equals(attributeAction)) continue;
            map.put(attributeName, attributeValue);
        }
        return map;
    }

    private AttributeValue getAutoGeneratedKeyAttributeValue(ItemConverter converter, Method getter) {
        Class<?> returnType = getter.getReturnType();
        if (String.class.isAssignableFrom(returnType)) {
            return converter.convert(getter, UUID.randomUUID().toString());
        }
        throw new DynamoDBMappingException("Unsupported type for " + getter + ": " + returnType + ".  Only Strings are supported when auto-generating keys.");
    }

    public <T> PaginatedScanList<T> scan(Class<T> clazz, DynamoDBScanExpression scanExpression) {
        return this.scan(clazz, scanExpression, this.config);
    }

    public <T> PaginatedScanList<T> scan(Class<T> clazz, DynamoDBScanExpression scanExpression, DynamoDBMapperConfig config) {
        config = this.mergeConfig(config);
        ScanRequest scanRequest = this.createScanRequestFromExpression(clazz, scanExpression, config);
        ScanResult scanResult = this.db.scan(DynamoDBMapper.applyUserAgent(scanRequest));
        return new PaginatedScanList<T>(this, clazz, this.db, scanRequest, scanResult, config.getPaginationLoadingStrategy(), config);
    }

    public <T> PaginatedParallelScanList<T> parallelScan(Class<T> clazz, DynamoDBScanExpression scanExpression, int totalSegments) {
        return this.parallelScan(clazz, scanExpression, totalSegments, this.config);
    }

    public <T> PaginatedParallelScanList<T> parallelScan(Class<T> clazz, DynamoDBScanExpression scanExpression, int totalSegments, DynamoDBMapperConfig config) {
        config = this.mergeConfig(config);
        List<ScanRequest> parallelScanRequests = this.createParallelScanRequestsFromExpression(clazz, scanExpression, totalSegments, config);
        ParallelScanTask parallelScanTask = new ParallelScanTask(this.db, parallelScanRequests);
        return new PaginatedParallelScanList<T>(this, clazz, this.db, parallelScanTask, config.getPaginationLoadingStrategy(), config);
    }

    public <T> ScanResultPage<T> scanPage(Class<T> clazz, DynamoDBScanExpression scanExpression, DynamoDBMapperConfig config) {
        config = this.mergeConfig(config);
        ScanRequest scanRequest = this.createScanRequestFromExpression(clazz, scanExpression, config);
        ScanResult scanResult = this.db.scan(DynamoDBMapper.applyUserAgent(scanRequest));
        ScanResultPage<T> result = new ScanResultPage<T>();
        List<AttributeTransformer.Parameters<T>> parameters = this.toParameters(scanResult.getItems(), clazz, scanRequest.getTableName(), config);
        result.setResults(this.marshallIntoObjects(parameters));
        result.setLastEvaluatedKey(scanResult.getLastEvaluatedKey());
        result.setCount(scanResult.getCount());
        result.setScannedCount(scanResult.getScannedCount());
        result.setConsumedCapacity(scanResult.getConsumedCapacity());
        return result;
    }

    public <T> ScanResultPage<T> scanPage(Class<T> clazz, DynamoDBScanExpression scanExpression) {
        return this.scanPage(clazz, scanExpression, this.config);
    }

    public <T> PaginatedQueryList<T> query(Class<T> clazz, DynamoDBQueryExpression<T> queryExpression) {
        return this.query(clazz, queryExpression, this.config);
    }

    public <T> PaginatedQueryList<T> query(Class<T> clazz, DynamoDBQueryExpression<T> queryExpression, DynamoDBMapperConfig config) {
        config = this.mergeConfig(config);
        QueryRequest queryRequest = this.createQueryRequestFromExpression(clazz, queryExpression, config);
        QueryResult queryResult = this.db.query(DynamoDBMapper.applyUserAgent(queryRequest));
        return new PaginatedQueryList<T>(this, clazz, this.db, queryRequest, queryResult, config.getPaginationLoadingStrategy(), config);
    }

    public <T> QueryResultPage<T> queryPage(Class<T> clazz, DynamoDBQueryExpression<T> queryExpression) {
        return this.queryPage(clazz, queryExpression, this.config);
    }

    public <T> QueryResultPage<T> queryPage(Class<T> clazz, DynamoDBQueryExpression<T> queryExpression, DynamoDBMapperConfig config) {
        config = this.mergeConfig(config);
        QueryRequest queryRequest = this.createQueryRequestFromExpression(clazz, queryExpression, config);
        QueryResult queryResult = this.db.query(DynamoDBMapper.applyUserAgent(queryRequest));
        QueryResultPage<T> result = new QueryResultPage<T>();
        List<AttributeTransformer.Parameters<T>> parameters = this.toParameters(queryResult.getItems(), clazz, queryRequest.getTableName(), config);
        result.setResults(this.marshallIntoObjects(parameters));
        result.setLastEvaluatedKey(queryResult.getLastEvaluatedKey());
        result.setCount(queryResult.getCount());
        result.setScannedCount(queryResult.getScannedCount());
        result.setConsumedCapacity(queryResult.getConsumedCapacity());
        return result;
    }

    public int count(Class<?> clazz, DynamoDBScanExpression scanExpression) {
        return this.count(clazz, scanExpression, this.config);
    }

    public int count(Class<?> clazz, DynamoDBScanExpression scanExpression, DynamoDBMapperConfig config) {
        config = this.mergeConfig(config);
        ScanRequest scanRequest = this.createScanRequestFromExpression(clazz, scanExpression, config);
        scanRequest.setSelect(Select.COUNT);
        int count = 0;
        ScanResult scanResult = null;
        do {
            scanResult = this.db.scan(DynamoDBMapper.applyUserAgent(scanRequest));
            count += scanResult.getCount().intValue();
            scanRequest.setExclusiveStartKey(scanResult.getLastEvaluatedKey());
        } while (scanResult.getLastEvaluatedKey() != null);
        return count;
    }

    public <T> int count(Class<T> clazz, DynamoDBQueryExpression<T> queryExpression) {
        return this.count(clazz, queryExpression, this.config);
    }

    public <T> int count(Class<T> clazz, DynamoDBQueryExpression<T> queryExpression, DynamoDBMapperConfig config) {
        config = this.mergeConfig(config);
        QueryRequest queryRequest = this.createQueryRequestFromExpression(clazz, queryExpression, config);
        queryRequest.setSelect(Select.COUNT);
        int count = 0;
        QueryResult queryResult = null;
        do {
            queryResult = this.db.query(DynamoDBMapper.applyUserAgent(queryRequest));
            count += queryResult.getCount().intValue();
            queryRequest.setExclusiveStartKey(queryResult.getLastEvaluatedKey());
        } while (queryResult.getLastEvaluatedKey() != null);
        return count;
    }

    private DynamoDBMapperConfig mergeConfig(DynamoDBMapperConfig config) {
        if (config != this.config) {
            config = new DynamoDBMapperConfig(this.config, config);
        }
        return config;
    }

    private ScanRequest createScanRequestFromExpression(Class<?> clazz, DynamoDBScanExpression scanExpression, DynamoDBMapperConfig config) {
        ScanRequest scanRequest = new ScanRequest();
        scanRequest.setTableName(this.getTableName(clazz, config));
        scanRequest.setIndexName(scanExpression.getIndexName());
        scanRequest.setScanFilter(scanExpression.getScanFilter());
        scanRequest.setLimit(scanExpression.getLimit());
        scanRequest.setExclusiveStartKey(scanExpression.getExclusiveStartKey());
        scanRequest.setTotalSegments(scanExpression.getTotalSegments());
        scanRequest.setSegment(scanExpression.getSegment());
        scanRequest.setConditionalOperator(scanExpression.getConditionalOperator());
        scanRequest.setFilterExpression(scanExpression.getFilterExpression());
        scanRequest.setExpressionAttributeNames(scanExpression.getExpressionAttributeNames());
        scanRequest.setExpressionAttributeValues(scanExpression.getExpressionAttributeValues());
        scanRequest.setRequestMetricCollector(config.getRequestMetricCollector());
        scanRequest.setSelect(scanExpression.getSelect());
        scanRequest.setProjectionExpression(scanExpression.getProjectionExpression());
        scanRequest.setReturnConsumedCapacity(scanExpression.getReturnConsumedCapacity());
        return DynamoDBMapper.applyUserAgent(scanRequest);
    }

    private List<ScanRequest> createParallelScanRequestsFromExpression(Class<?> clazz, DynamoDBScanExpression scanExpression, int totalSegments, DynamoDBMapperConfig config) {
        if (totalSegments < 1) {
            throw new IllegalArgumentException("Parallel scan should have at least one scan segment.");
        }
        if (scanExpression.getExclusiveStartKey() != null) {
            log.info((Object)"The ExclusiveStartKey parameter specified in the DynamoDBScanExpression is ignored, since the individual parallel scan request on each segment is applied on a separate key scope.");
        }
        if (scanExpression.getSegment() != null || scanExpression.getTotalSegments() != null) {
            log.info((Object)"The Segment and TotalSegments parameters specified in the DynamoDBScanExpression are ignored.");
        }
        LinkedList<ScanRequest> parallelScanRequests = new LinkedList<ScanRequest>();
        for (int segment = 0; segment < totalSegments; ++segment) {
            ScanRequest scanRequest = this.createScanRequestFromExpression(clazz, scanExpression, config);
            parallelScanRequests.add(scanRequest.withSegment(segment).withTotalSegments(totalSegments).withExclusiveStartKey(null));
        }
        return parallelScanRequests;
    }

    private <T> QueryRequest createQueryRequestFromExpression(Class<T> clazz, DynamoDBQueryExpression<T> xpress, DynamoDBMapperConfig config) {
        QueryRequest req = new QueryRequest();
        req.setConsistentRead(xpress.isConsistentRead());
        req.setTableName(this.getTableName(clazz, xpress.getHashKeyValues(), config));
        req.setIndexName(xpress.getIndexName());
        ItemConverter converter = this.getConverter(config);
        Map<String, Condition> hashKeyConditions = this.getHashKeyEqualsConditions(converter, xpress.getHashKeyValues());
        Map<String, Condition> rangeKeyConditions = xpress.getRangeKeyConditions();
        req.setKeyConditionExpression(xpress.getKeyConditionExpression());
        this.processKeyConditions(clazz, req, hashKeyConditions, rangeKeyConditions);
        req.withScanIndexForward(xpress.isScanIndexForward()).withLimit(xpress.getLimit()).withExclusiveStartKey(xpress.getExclusiveStartKey()).withQueryFilter(xpress.getQueryFilter()).withConditionalOperator(xpress.getConditionalOperator()).withSelect(xpress.getSelect()).withProjectionExpression(xpress.getProjectionExpression()).withFilterExpression(xpress.getFilterExpression()).withExpressionAttributeNames(xpress.getExpressionAttributeNames()).withExpressionAttributeValues(xpress.getExpressionAttributeValues()).withReturnConsumedCapacity(xpress.getReturnConsumedCapacity()).withRequestMetricCollector(config.getRequestMetricCollector());
        return DynamoDBMapper.applyUserAgent(req);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processKeyConditions(Class<?> clazz, QueryRequest queryRequest, Map<String, Condition> hashKeyConditions, Map<String, Condition> rangeKeyConditions) {
        boolean userProvidedGSI;
        String keyCondExpression = queryRequest.getKeyConditionExpression();
        if (keyCondExpression == null) {
            if (hashKeyConditions == null || hashKeyConditions.isEmpty()) {
                throw new IllegalArgumentException("Illegal query expression: No hash key condition is found in the query");
            }
        } else {
            if (hashKeyConditions != null && !hashKeyConditions.isEmpty()) {
                throw new IllegalArgumentException("Illegal query expression: Either the hash key conditions or the key condition expression must be specified but not both.");
            }
            if (rangeKeyConditions == null || rangeKeyConditions.isEmpty()) return;
            throw new IllegalArgumentException("Illegal query expression: The range key conditions can only be specified when the key condition expression is not specified.");
        }
        if (rangeKeyConditions != null && rangeKeyConditions.size() > 1) {
            throw new IllegalArgumentException("Illegal query expression: Conditions on multiple range keys (" + rangeKeyConditions.keySet().toString() + ") are found in the query. DynamoDB service only accepts up to ONE range key condition.");
        }
        boolean hasRangeKeyCondition = rangeKeyConditions != null && !rangeKeyConditions.isEmpty();
        String userProvidedIndexName = queryRequest.getIndexName();
        String primaryHashKeyName = this.reflector.getPrimaryHashKeyName(clazz);
        DynamoDBTableSchemaParser.TableIndexesInfo parsedIndexesInfo = this.schemaParser.parseTableIndexes(clazz, this.reflector);
        boolean hasPrimaryHashKeyCondition = false;
        HashMap annotatedGSIsOnHashKeys = new HashMap();
        String hashKeyNameForThisQuery = null;
        boolean hasPrimaryRangeKeyCondition = false;
        HashSet<String> annotatedLSIsOnRangeKey = new HashSet<String>();
        HashSet<String> annotatedGSIsOnRangeKey = new HashSet<String>();
        String rangeKeyNameForThisQuery = null;
        if (hasRangeKeyCondition) {
            Iterator<String> i$ = rangeKeyConditions.keySet().iterator();
            while (i$.hasNext()) {
                Set<String> annotatedGSI;
                Set<String> annotatedLSI;
                String rangeKeyName;
                rangeKeyNameForThisQuery = rangeKeyName = i$.next();
                if (this.reflector.hasPrimaryRangeKey(clazz) && rangeKeyName.equals(this.reflector.getPrimaryRangeKeyName(clazz))) {
                    hasPrimaryRangeKeyCondition = true;
                }
                if ((annotatedLSI = parsedIndexesInfo.getLsiNamesByIndexRangeKey(rangeKeyName)) != null) {
                    annotatedLSIsOnRangeKey.addAll(annotatedLSI);
                }
                if ((annotatedGSI = parsedIndexesInfo.getGsiNamesByIndexRangeKey(rangeKeyName)) == null) continue;
                annotatedGSIsOnRangeKey.addAll(annotatedGSI);
            }
            if (!hasPrimaryRangeKeyCondition && annotatedLSIsOnRangeKey.isEmpty() && annotatedGSIsOnRangeKey.isEmpty()) {
                throw new DynamoDBMappingException("The query contains a condition on a range key (" + rangeKeyNameForThisQuery + ") " + "that is not annotated with either @DynamoDBRangeKey or @DynamoDBIndexRangeKey.");
            }
        }
        boolean userProvidedLSIWithRangeKeyCondition = userProvidedIndexName != null && annotatedLSIsOnRangeKey.contains(userProvidedIndexName);
        boolean hashOnlyLSIQuery = userProvidedIndexName != null && !hasRangeKeyCondition && parsedIndexesInfo.getAllLsiNames().contains(userProvidedIndexName);
        boolean userProvidedLSI = userProvidedLSIWithRangeKeyCondition || hashOnlyLSIQuery;
        boolean userProvidedGSIWithRangeKeyCondition = userProvidedIndexName != null && annotatedGSIsOnRangeKey.contains(userProvidedIndexName);
        boolean hashOnlyGSIQuery = userProvidedIndexName != null && !hasRangeKeyCondition && parsedIndexesInfo.getAllGsiNames().contains(userProvidedIndexName);
        boolean bl = userProvidedGSI = userProvidedGSIWithRangeKeyCondition || hashOnlyGSIQuery;
        if (userProvidedLSI && userProvidedGSI) {
            throw new DynamoDBMappingException("Invalid query: Index \"" + userProvidedIndexName + "\" " + "is annotateded as both a LSI and a GSI for attribute.");
        }
        for (String hashKeyName : hashKeyConditions.keySet()) {
            Set<String> annotatedGSINames;
            if (hashKeyName.equals(primaryHashKeyName)) {
                hasPrimaryHashKeyCondition = true;
            }
            annotatedGSIsOnHashKeys.put(hashKeyName, (annotatedGSINames = parsedIndexesInfo.getGsiNamesByIndexHashKey(hashKeyName)) == null ? new HashSet() : new HashSet<String>(annotatedGSINames));
            if (userProvidedIndexName == null) continue;
            boolean foundHashKeyConditionValidWithUserProvidedIndex = false;
            if (userProvidedLSI && hashKeyName.equals(primaryHashKeyName)) {
                foundHashKeyConditionValidWithUserProvidedIndex = true;
            } else if (userProvidedGSI && annotatedGSINames != null && annotatedGSINames.contains(userProvidedIndexName)) {
                foundHashKeyConditionValidWithUserProvidedIndex = true;
            }
            if (!foundHashKeyConditionValidWithUserProvidedIndex) continue;
            if (hashKeyNameForThisQuery != null) {
                throw new IllegalArgumentException("Ambiguous query expression: More than one hash key EQ conditions (" + hashKeyNameForThisQuery + ", " + hashKeyName + ") are applicable to the specified index (" + userProvidedIndexName + "). " + "Please provide only one of them in the query expression.");
            }
            hashKeyNameForThisQuery = hashKeyName;
        }
        HashMap<String, Condition> keyConditions = new HashMap<String, Condition>();
        if (userProvidedIndexName != null) {
            if (hasRangeKeyCondition && !userProvidedLSI && !userProvidedGSI) {
                throw new IllegalArgumentException("Illegal query expression: No range key condition is applicable to the specified index (" + userProvidedIndexName + "). ");
            }
            if (hashKeyNameForThisQuery == null) {
                throw new IllegalArgumentException("Illegal query expression: No hash key condition is applicable to the specified index (" + userProvidedIndexName + "). ");
            }
            keyConditions.put(hashKeyNameForThisQuery, hashKeyConditions.get(hashKeyNameForThisQuery));
            if (hasRangeKeyCondition) {
                keyConditions.putAll(rangeKeyConditions);
            }
        } else if (hasRangeKeyCondition) {
            String inferredIndexName = null;
            hashKeyNameForThisQuery = null;
            if (hasPrimaryHashKeyCondition && hasPrimaryRangeKeyCondition) {
                hashKeyNameForThisQuery = primaryHashKeyName;
            } else {
                for (String hashKeyName : annotatedGSIsOnHashKeys.keySet()) {
                    boolean foundValidQueryExpressionWithInferredIndex = false;
                    String indexNameInferredByThisHashKey = null;
                    if (hashKeyName.equals(primaryHashKeyName) && annotatedLSIsOnRangeKey.size() == 1) {
                        foundValidQueryExpressionWithInferredIndex = true;
                        indexNameInferredByThisHashKey = (String)annotatedLSIsOnRangeKey.iterator().next();
                    }
                    Set annotatedGSIsOnHashKey = (Set)annotatedGSIsOnHashKeys.get(hashKeyName);
                    annotatedGSIsOnHashKey.retainAll(annotatedGSIsOnRangeKey);
                    if (annotatedGSIsOnHashKey.size() == 1) {
                        if (foundValidQueryExpressionWithInferredIndex) {
                            hashKeyNameForThisQuery = hashKeyName;
                            inferredIndexName = indexNameInferredByThisHashKey;
                        }
                        foundValidQueryExpressionWithInferredIndex = true;
                        indexNameInferredByThisHashKey = (String)annotatedGSIsOnHashKey.iterator().next();
                    }
                    if (!foundValidQueryExpressionWithInferredIndex) continue;
                    if (hashKeyNameForThisQuery != null) {
                        throw new IllegalArgumentException("Ambiguous query expression: Found multiple valid queries: (Hash: \"" + hashKeyNameForThisQuery + "\", Range: \"" + rangeKeyNameForThisQuery + "\", Index: \"" + inferredIndexName + "\") and " + "(Hash: \"" + hashKeyName + "\", Range: \"" + rangeKeyNameForThisQuery + "\", Index: \"" + indexNameInferredByThisHashKey + "\").");
                    }
                    hashKeyNameForThisQuery = hashKeyName;
                    inferredIndexName = indexNameInferredByThisHashKey;
                }
            }
            if (hashKeyNameForThisQuery == null) throw new IllegalArgumentException("Illegal query expression: Cannot infer the index name from the query expression.");
            keyConditions.put(hashKeyNameForThisQuery, hashKeyConditions.get(hashKeyNameForThisQuery));
            keyConditions.putAll(rangeKeyConditions);
            queryRequest.setIndexName(inferredIndexName);
        } else if (hashKeyConditions.size() > 1) {
            if (!hasPrimaryHashKeyCondition) throw new IllegalArgumentException("Ambiguous query expression: More than one index hash key EQ conditions (" + hashKeyConditions.keySet() + ") are applicable to the query. " + "Please provide only one of them in the query expression, or specify the appropriate index name.");
            keyConditions.put(primaryHashKeyName, hashKeyConditions.get(primaryHashKeyName));
        } else {
            String hashKeyName;
            hashKeyName = (String)annotatedGSIsOnHashKeys.keySet().iterator().next();
            if (!hasPrimaryHashKeyCondition) {
                if (((Set)annotatedGSIsOnHashKeys.get(hashKeyName)).size() == 1) {
                    queryRequest.setIndexName((String)((Set)annotatedGSIsOnHashKeys.get(hashKeyName)).iterator().next());
                } else {
                    if (((Set)annotatedGSIsOnHashKeys.get(hashKeyName)).size() <= 1) throw new IllegalArgumentException("Illegal query expression: No GSI is found in the @DynamoDBIndexHashKey annotation for attribute \"" + hashKeyName + "\".");
                    throw new IllegalArgumentException("Ambiguous query expression: More than one GSIs (" + annotatedGSIsOnHashKeys.get(hashKeyName) + ") are applicable to the query. " + "Please specify one of them in your query expression.");
                }
            }
            keyConditions.putAll(hashKeyConditions);
        }
        queryRequest.setKeyConditions(keyConditions);
    }

    private <T> AttributeTransformer.Parameters<T> toParameters(Map<String, AttributeValue> attributeValues, Class<T> modelClass, String tableName, DynamoDBMapperConfig mapperConfig) {
        return this.toParameters(attributeValues, false, modelClass, tableName, mapperConfig);
    }

    private <T> AttributeTransformer.Parameters<T> toParameters(Map<String, AttributeValue> attributeValues, boolean partialUpdate, Class<T> modelClass, String tableName, DynamoDBMapperConfig mapperConfig) {
        return new TransformerParameters<T>(this.reflector, attributeValues, partialUpdate, modelClass, mapperConfig, tableName);
    }

    final <T> List<AttributeTransformer.Parameters<T>> toParameters(List<Map<String, AttributeValue>> attributeValues, Class<T> modelClass, String tableName, DynamoDBMapperConfig mapperConfig) {
        ArrayList<AttributeTransformer.Parameters<T>> rval = new ArrayList<AttributeTransformer.Parameters<T>>(attributeValues.size());
        for (Map<String, AttributeValue> item : attributeValues) {
            rval.add(this.toParameters(item, modelClass, tableName, mapperConfig));
        }
        return rval;
    }

    private Map<String, AttributeValue> untransformAttributes(AttributeTransformer.Parameters<?> parameters) {
        if (this.transformer != null) {
            return this.transformer.untransform(parameters);
        }
        return parameters.getAttributeValues();
    }

    private Map<String, AttributeValue> transformAttributes(AttributeTransformer.Parameters<?> parameters) {
        if (this.transformer != null) {
            return this.transformer.transform(parameters);
        }
        return parameters.getAttributeValues();
    }

    private Map<String, AttributeValueUpdate> transformAttributeUpdates(Class<?> clazz, String tableName, Map<String, AttributeValue> keys, Map<String, AttributeValueUpdate> updateValues, DynamoDBMapperConfig config) {
        Map<String, AttributeValue> item = this.convertToItem(updateValues);
        HashSet<String> keysAdded = new HashSet<String>();
        for (Map.Entry<String, AttributeValue> e : keys.entrySet()) {
            if (item.containsKey(e.getKey())) continue;
            keysAdded.add(e.getKey());
            item.put(e.getKey(), e.getValue());
        }
        AttributeTransformer.Parameters<?> parameters = this.toParameters(item, true, clazz, tableName, config);
        String hashKey = parameters.getHashKeyName();
        if (!item.containsKey(hashKey)) {
            item.put(hashKey, keys.get(hashKey));
        }
        item = this.transformAttributes(parameters);
        for (Map.Entry<String, AttributeValue> entry : item.entrySet()) {
            if (keysAdded.contains(entry.getKey())) continue;
            AttributeValueUpdate update = updateValues.get(entry.getKey());
            if (update != null) {
                update.getValue().withB(entry.getValue().getB()).withBS(entry.getValue().getBS()).withN(entry.getValue().getN()).withNS(entry.getValue().getNS()).withS(entry.getValue().getS()).withSS(entry.getValue().getSS());
                continue;
            }
            updateValues.put(entry.getKey(), new AttributeValueUpdate(entry.getValue(), "PUT"));
        }
        return updateValues;
    }

    private ItemConverter getConverter(DynamoDBMapperConfig config) {
        ConversionSchema schema = config.getConversionSchema();
        ConversionSchema.Dependencies params = new ConversionSchema.Dependencies().with(DynamoDBReflector.class, this.reflector).with(S3ClientCache.class, this.s3cc);
        return schema.getConverter(params);
    }

    private void pauseExponentially(int retries) {
        if (retries == 0) {
            return;
        }
        Random random = new Random();
        long delay = 0L;
        long scaleFactor = 500 + random.nextInt(100);
        delay = (long)(Math.pow(2.0, retries) * (double)scaleFactor);
        delay = Math.min(delay, 3000L);
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new AmazonClientException(e.getMessage(), e);
        }
    }

    private static Map<String, ExpectedAttributeValue> mergeExpectedAttributeValueConditions(Map<String, ExpectedAttributeValue> internalAssertions, Map<String, ExpectedAttributeValue> userProvidedConditions, String userProvidedConditionOperator) {
        if ((internalAssertions == null || internalAssertions.isEmpty()) && (userProvidedConditions == null || userProvidedConditions.isEmpty())) {
            return null;
        }
        if (internalAssertions == null) {
            return new HashMap<String, ExpectedAttributeValue>(userProvidedConditions);
        }
        if (userProvidedConditions == null) {
            return new HashMap<String, ExpectedAttributeValue>(internalAssertions);
        }
        HashMap<String, ExpectedAttributeValue> mergedExpectedValues = new HashMap<String, ExpectedAttributeValue>(internalAssertions);
        for (String attrName : userProvidedConditions.keySet()) {
            mergedExpectedValues.remove(attrName);
        }
        if (ConditionalOperator.OR.toString().equals(userProvidedConditionOperator) && !mergedExpectedValues.isEmpty()) {
            throw new IllegalArgumentException("Unable to assert the value of the fields " + mergedExpectedValues.keySet() + ", since the expected value conditions cannot be combined " + "with user-specified conditions joined by \"OR\". You can use SaveBehavior.CLOBBER to " + "skip the assertion on these fields.");
        }
        mergedExpectedValues.putAll(userProvidedConditions);
        return mergedExpectedValues;
    }

    static <X extends AmazonWebServiceRequest> X applyUserAgent(X request) {
        request.getRequestClientOptions().appendUserAgent(USER_AGENT);
        return request;
    }

    static <X extends AmazonWebServiceRequest> X applyBatchOperationUserAgent(X request) {
        request.getRequestClientOptions().appendUserAgent(USER_AGENT_BATCH_OPERATION);
        return request;
    }

    public S3ClientCache getS3ClientCache() {
        return this.s3cc;
    }

    public S3Link createS3Link(String bucketName, String key) {
        return this.createS3Link(null, bucketName, key);
    }

    public S3Link createS3Link(Region s3region, String bucketName, String key) {
        if (this.s3cc == null) {
            throw new IllegalStateException("Mapper must be constructed with S3 AWS Credentials to create S3Link");
        }
        return new S3Link(this.s3cc, s3region, bucketName, key);
    }

    public CreateTableRequest generateCreateTableRequest(Class<?> clazz) {
        ItemConverter converter = this.getConverter(this.config);
        return this.schemaParser.parseTablePojoToCreateTableRequest(clazz, this.config, this.reflector, converter);
    }

    public static class FailedBatch {
        private Map<String, List<WriteRequest>> unprocessedItems;
        private Exception exception;

        public void setUnprocessedItems(Map<String, List<WriteRequest>> unprocessedItems) {
            this.unprocessedItems = unprocessedItems;
        }

        public Map<String, List<WriteRequest>> getUnprocessedItems() {
            return this.unprocessedItems;
        }

        public void setException(Exception excetpion) {
            this.exception = excetpion;
        }

        public Exception getException() {
            return this.exception;
        }
    }

    private static class TransformerParameters<T>
    implements AttributeTransformer.Parameters<T> {
        private final DynamoDBReflector reflector;
        private final Map<String, AttributeValue> attributeValues;
        private final boolean partialUpdate;
        private final Class<T> modelClass;
        private final DynamoDBMapperConfig mapperConfig;
        private final String tableName;
        private String hashKeyName;
        private String rangeKeyName;

        public TransformerParameters(DynamoDBReflector reflector, Map<String, AttributeValue> attributeValues, boolean partialUpdate, Class<T> modelClass, DynamoDBMapperConfig mapperConfig, String tableName) {
            this.reflector = reflector;
            this.attributeValues = Collections.unmodifiableMap(attributeValues);
            this.partialUpdate = partialUpdate;
            this.modelClass = modelClass;
            this.mapperConfig = mapperConfig;
            this.tableName = tableName;
        }

        @Override
        public Map<String, AttributeValue> getAttributeValues() {
            return this.attributeValues;
        }

        @Override
        public boolean isPartialUpdate() {
            return this.partialUpdate;
        }

        @Override
        public Class<T> getModelClass() {
            return this.modelClass;
        }

        @Override
        public DynamoDBMapperConfig getMapperConfig() {
            return this.mapperConfig;
        }

        @Override
        public String getTableName() {
            return this.tableName;
        }

        @Override
        public String getHashKeyName() {
            if (this.hashKeyName == null) {
                Method hashKeyGetter = this.reflector.getPrimaryHashKeyGetter(this.modelClass);
                this.hashKeyName = this.reflector.getAttributeName(hashKeyGetter);
            }
            return this.hashKeyName;
        }

        @Override
        public String getRangeKeyName() {
            if (this.rangeKeyName == null) {
                Method rangeKeyGetter = this.reflector.getPrimaryRangeKeyGetter(this.modelClass);
                this.rangeKeyName = rangeKeyGetter == null ? NO_RANGE_KEY : this.reflector.getAttributeName(rangeKeyGetter);
            }
            if (this.rangeKeyName == NO_RANGE_KEY) {
                return null;
            }
            return this.rangeKeyName;
        }
    }

    private final class ValueUpdate {
        private final Method method;
        private final AttributeValue newValue;
        private final Object target;
        private final ItemConverter converter;

        public ValueUpdate(Method method, AttributeValue newValue, Object target, ItemConverter converter) {
            this.method = method;
            this.newValue = newValue;
            this.target = target;
            this.converter = converter;
        }

        public void apply() {
            Method setter = DynamoDBMapper.this.reflector.getSetter(this.method);
            Object pojo = this.converter.unconvert(this.method, setter, this.newValue);
            ReflectionUtils.safeInvoke(setter, this.target, pojo);
        }
    }

    protected abstract class SaveObjectHandler {
        protected final Object object;
        protected final Class<?> clazz;
        private final String tableName;
        private final DynamoDBMapperConfig saveConfig;
        private final ItemConverter converter;
        private final Map<String, AttributeValue> key;
        private final Map<String, AttributeValueUpdate> updateValues;
        private final Map<String, ExpectedAttributeValue> internalExpectedValueAssertions;
        protected final Map<String, ExpectedAttributeValue> userProvidedExpectedValueConditions;
        protected final String userProvidedConditionOperator;
        private final List<ValueUpdate> inMemoryUpdates;

        public SaveObjectHandler(Class<?> clazz, Object object, String tableName, DynamoDBMapperConfig saveConfig, ItemConverter converter, DynamoDBSaveExpression saveExpression) {
            this.clazz = clazz;
            this.object = object;
            this.tableName = tableName;
            this.saveConfig = saveConfig;
            this.converter = converter;
            if (saveExpression != null) {
                this.userProvidedExpectedValueConditions = saveExpression.getExpected();
                this.userProvidedConditionOperator = saveExpression.getConditionalOperator();
            } else {
                this.userProvidedExpectedValueConditions = null;
                this.userProvidedConditionOperator = null;
            }
            this.updateValues = new HashMap<String, AttributeValueUpdate>();
            this.internalExpectedValueAssertions = new HashMap<String, ExpectedAttributeValue>();
            this.inMemoryUpdates = new LinkedList<ValueUpdate>();
            this.key = new HashMap<String, AttributeValue>();
        }

        public void execute() {
            String attributeName;
            Object getterResult;
            Collection<Method> keyGetters = DynamoDBMapper.this.reflector.getPrimaryKeyGetters(this.clazz);
            for (Method method : keyGetters) {
                getterResult = ReflectionUtils.safeInvoke(method, this.object, new Object[0]);
                attributeName = DynamoDBMapper.this.reflector.getAttributeName(method);
                if (getterResult == null && DynamoDBMapper.this.reflector.isAssignableKey(method)) {
                    this.onAutoGenerateAssignableKey(method, attributeName);
                    continue;
                }
                AttributeValue newAttributeValue = this.converter.convert(method, getterResult);
                if (newAttributeValue == null) {
                    throw new DynamoDBMappingException("Null or empty value for key: " + method);
                }
                if (newAttributeValue.getS() == null && newAttributeValue.getN() == null && newAttributeValue.getB() == null) {
                    throw new DynamoDBMappingException("Keys must be scalar values (String, Number, or Binary). Got " + newAttributeValue + " for key " + method);
                }
                this.onKeyAttributeValue(attributeName, newAttributeValue);
            }
            for (Method method : DynamoDBMapper.this.reflector.getRelevantGetters(this.clazz)) {
                if (keyGetters.contains(method)) continue;
                getterResult = ReflectionUtils.safeInvoke(method, this.object, new Object[0]);
                attributeName = DynamoDBMapper.this.reflector.getAttributeName(method);
                if (DynamoDBMapper.this.reflector.isVersionAttributeGetter(method)) {
                    this.onVersionAttribute(method, getterResult, attributeName);
                    continue;
                }
                AttributeValue currentValue = this.converter.convert(method, getterResult);
                if (currentValue != null) {
                    this.onNonKeyAttribute(attributeName, currentValue);
                    continue;
                }
                this.onNullNonKeyAttribute(attributeName);
            }
            this.executeLowLevelRequest();
            for (ValueUpdate update : this.inMemoryUpdates) {
                update.apply();
            }
        }

        protected abstract void onKeyAttributeValue(String var1, AttributeValue var2);

        protected void onNonKeyAttribute(String attributeName, AttributeValue currentValue) {
            this.updateValues.put(attributeName, new AttributeValueUpdate().withValue(currentValue).withAction("PUT"));
        }

        protected abstract void onNullNonKeyAttribute(String var1);

        protected abstract void executeLowLevelRequest();

        protected DynamoDBMapperConfig.SaveBehavior getLocalSaveBehavior() {
            return this.saveConfig.getSaveBehavior();
        }

        protected String getTableName() {
            return this.tableName;
        }

        protected Map<String, AttributeValue> getKeyAttributeValues() {
            return this.key;
        }

        protected Map<String, AttributeValueUpdate> getAttributeValueUpdates() {
            return this.updateValues;
        }

        protected Map<String, ExpectedAttributeValue> mergeExpectedAttributeValueConditions() {
            return DynamoDBMapper.mergeExpectedAttributeValueConditions(this.internalExpectedValueAssertions, this.userProvidedExpectedValueConditions, this.userProvidedConditionOperator);
        }

        protected List<ValueUpdate> getInMemoryUpdates() {
            return this.inMemoryUpdates;
        }

        protected UpdateItemResult doUpdateItem() {
            UpdateItemRequest req = (UpdateItemRequest)new UpdateItemRequest().withTableName(this.getTableName()).withKey(this.getKeyAttributeValues()).withAttributeUpdates(DynamoDBMapper.this.transformAttributeUpdates(this.clazz, this.getTableName(), this.getKeyAttributeValues(), this.getAttributeValueUpdates(), this.saveConfig)).withExpected(this.mergeExpectedAttributeValueConditions()).withConditionalOperator(this.userProvidedConditionOperator).withReturnValues(ReturnValue.ALL_NEW).withRequestMetricCollector(this.saveConfig.getRequestMetricCollector());
            return DynamoDBMapper.this.db.updateItem(DynamoDBMapper.applyUserAgent(req));
        }

        protected PutItemResult doPutItem() {
            Map attributeValues = DynamoDBMapper.this.convertToItem(this.getAttributeValueUpdates());
            attributeValues = DynamoDBMapper.this.transformAttributes(DynamoDBMapper.this.toParameters(attributeValues, this.clazz, this.getTableName(), this.saveConfig));
            PutItemRequest req = (PutItemRequest)new PutItemRequest().withTableName(this.getTableName()).withItem(attributeValues).withExpected(this.mergeExpectedAttributeValueConditions()).withConditionalOperator(this.userProvidedConditionOperator).withRequestMetricCollector(this.saveConfig.getRequestMetricCollector());
            return DynamoDBMapper.this.db.putItem(DynamoDBMapper.applyUserAgent(req));
        }

        private void onAutoGenerateAssignableKey(Method method, String attributeName) {
            AttributeValue newVersionValue = DynamoDBMapper.this.getAutoGeneratedKeyAttributeValue(this.converter, method);
            this.updateValues.put(attributeName, new AttributeValueUpdate().withAction("PUT").withValue(newVersionValue));
            this.inMemoryUpdates.add(new ValueUpdate(method, newVersionValue, this.object, this.converter));
            if (this.getLocalSaveBehavior() != DynamoDBMapperConfig.SaveBehavior.CLOBBER && !this.internalExpectedValueAssertions.containsKey(attributeName)) {
                ExpectedAttributeValue expected = new ExpectedAttributeValue();
                expected.setExists(false);
                this.internalExpectedValueAssertions.put(attributeName, expected);
            }
        }

        private void onVersionAttribute(Method method, Object getterResult, String attributeName) {
            if (this.getLocalSaveBehavior() != DynamoDBMapperConfig.SaveBehavior.CLOBBER && !this.internalExpectedValueAssertions.containsKey(attributeName)) {
                ExpectedAttributeValue expected = new ExpectedAttributeValue();
                AttributeValue currentValue = this.converter.convert(method, getterResult);
                expected.setExists(currentValue != null);
                if (currentValue != null) {
                    expected.setValue(currentValue);
                }
                this.internalExpectedValueAssertions.put(attributeName, expected);
            }
            Object newVersion = DynamoDBMapper.this.incrementor.increment(method, getterResult);
            AttributeValue newVersionValue = this.converter.convert(method, newVersion);
            this.updateValues.put(attributeName, new AttributeValueUpdate().withAction("PUT").withValue(newVersionValue));
            this.inMemoryUpdates.add(new ValueUpdate(method, newVersionValue, this.object, this.converter));
        }
    }
}

