/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.rds.model.AvailabilityZone;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class OrderableDBInstanceOption
implements Serializable {
    private String engine;
    private String engineVersion;
    private String dBInstanceClass;
    private String licenseModel;
    private ListWithAutoConstructFlag<AvailabilityZone> availabilityZones;
    private Boolean multiAZCapable;
    private Boolean readReplicaCapable;
    private Boolean vpc;
    private String storageType;
    private Boolean supportsIops;

    public String getEngine() {
        return this.engine;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public OrderableDBInstanceOption withEngine(String engine) {
        this.engine = engine;
        return this;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    public OrderableDBInstanceOption withEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
        return this;
    }

    public String getDBInstanceClass() {
        return this.dBInstanceClass;
    }

    public void setDBInstanceClass(String dBInstanceClass) {
        this.dBInstanceClass = dBInstanceClass;
    }

    public OrderableDBInstanceOption withDBInstanceClass(String dBInstanceClass) {
        this.dBInstanceClass = dBInstanceClass;
        return this;
    }

    public String getLicenseModel() {
        return this.licenseModel;
    }

    public void setLicenseModel(String licenseModel) {
        this.licenseModel = licenseModel;
    }

    public OrderableDBInstanceOption withLicenseModel(String licenseModel) {
        this.licenseModel = licenseModel;
        return this;
    }

    public List<AvailabilityZone> getAvailabilityZones() {
        if (this.availabilityZones == null) {
            this.availabilityZones = new ListWithAutoConstructFlag();
            this.availabilityZones.setAutoConstruct(true);
        }
        return this.availabilityZones;
    }

    public void setAvailabilityZones(Collection<AvailabilityZone> availabilityZones) {
        if (availabilityZones == null) {
            this.availabilityZones = null;
            return;
        }
        ListWithAutoConstructFlag availabilityZonesCopy = new ListWithAutoConstructFlag(availabilityZones.size());
        availabilityZonesCopy.addAll(availabilityZones);
        this.availabilityZones = availabilityZonesCopy;
    }

    public OrderableDBInstanceOption withAvailabilityZones(AvailabilityZone ... availabilityZones) {
        if (this.getAvailabilityZones() == null) {
            this.setAvailabilityZones(new ArrayList<AvailabilityZone>(availabilityZones.length));
        }
        for (AvailabilityZone value : availabilityZones) {
            this.getAvailabilityZones().add(value);
        }
        return this;
    }

    public OrderableDBInstanceOption withAvailabilityZones(Collection<AvailabilityZone> availabilityZones) {
        if (availabilityZones == null) {
            this.availabilityZones = null;
        } else {
            ListWithAutoConstructFlag availabilityZonesCopy = new ListWithAutoConstructFlag(availabilityZones.size());
            availabilityZonesCopy.addAll(availabilityZones);
            this.availabilityZones = availabilityZonesCopy;
        }
        return this;
    }

    public Boolean isMultiAZCapable() {
        return this.multiAZCapable;
    }

    public void setMultiAZCapable(Boolean multiAZCapable) {
        this.multiAZCapable = multiAZCapable;
    }

    public OrderableDBInstanceOption withMultiAZCapable(Boolean multiAZCapable) {
        this.multiAZCapable = multiAZCapable;
        return this;
    }

    public Boolean getMultiAZCapable() {
        return this.multiAZCapable;
    }

    public Boolean isReadReplicaCapable() {
        return this.readReplicaCapable;
    }

    public void setReadReplicaCapable(Boolean readReplicaCapable) {
        this.readReplicaCapable = readReplicaCapable;
    }

    public OrderableDBInstanceOption withReadReplicaCapable(Boolean readReplicaCapable) {
        this.readReplicaCapable = readReplicaCapable;
        return this;
    }

    public Boolean getReadReplicaCapable() {
        return this.readReplicaCapable;
    }

    public Boolean isVpc() {
        return this.vpc;
    }

    public void setVpc(Boolean vpc) {
        this.vpc = vpc;
    }

    public OrderableDBInstanceOption withVpc(Boolean vpc) {
        this.vpc = vpc;
        return this;
    }

    public Boolean getVpc() {
        return this.vpc;
    }

    public String getStorageType() {
        return this.storageType;
    }

    public void setStorageType(String storageType) {
        this.storageType = storageType;
    }

    public OrderableDBInstanceOption withStorageType(String storageType) {
        this.storageType = storageType;
        return this;
    }

    public Boolean isSupportsIops() {
        return this.supportsIops;
    }

    public void setSupportsIops(Boolean supportsIops) {
        this.supportsIops = supportsIops;
    }

    public OrderableDBInstanceOption withSupportsIops(Boolean supportsIops) {
        this.supportsIops = supportsIops;
        return this;
    }

    public Boolean getSupportsIops() {
        return this.supportsIops;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEngine() != null) {
            sb.append("Engine: " + this.getEngine() + ",");
        }
        if (this.getEngineVersion() != null) {
            sb.append("EngineVersion: " + this.getEngineVersion() + ",");
        }
        if (this.getDBInstanceClass() != null) {
            sb.append("DBInstanceClass: " + this.getDBInstanceClass() + ",");
        }
        if (this.getLicenseModel() != null) {
            sb.append("LicenseModel: " + this.getLicenseModel() + ",");
        }
        if (this.getAvailabilityZones() != null) {
            sb.append("AvailabilityZones: " + this.getAvailabilityZones() + ",");
        }
        if (this.isMultiAZCapable() != null) {
            sb.append("MultiAZCapable: " + this.isMultiAZCapable() + ",");
        }
        if (this.isReadReplicaCapable() != null) {
            sb.append("ReadReplicaCapable: " + this.isReadReplicaCapable() + ",");
        }
        if (this.isVpc() != null) {
            sb.append("Vpc: " + this.isVpc() + ",");
        }
        if (this.getStorageType() != null) {
            sb.append("StorageType: " + this.getStorageType() + ",");
        }
        if (this.isSupportsIops() != null) {
            sb.append("SupportsIops: " + this.isSupportsIops());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEngine() == null ? 0 : this.getEngine().hashCode());
        hashCode = 31 * hashCode + (this.getEngineVersion() == null ? 0 : this.getEngineVersion().hashCode());
        hashCode = 31 * hashCode + (this.getDBInstanceClass() == null ? 0 : this.getDBInstanceClass().hashCode());
        hashCode = 31 * hashCode + (this.getLicenseModel() == null ? 0 : this.getLicenseModel().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZones() == null ? 0 : this.getAvailabilityZones().hashCode());
        hashCode = 31 * hashCode + (this.isMultiAZCapable() == null ? 0 : this.isMultiAZCapable().hashCode());
        hashCode = 31 * hashCode + (this.isReadReplicaCapable() == null ? 0 : this.isReadReplicaCapable().hashCode());
        hashCode = 31 * hashCode + (this.isVpc() == null ? 0 : this.isVpc().hashCode());
        hashCode = 31 * hashCode + (this.getStorageType() == null ? 0 : this.getStorageType().hashCode());
        hashCode = 31 * hashCode + (this.isSupportsIops() == null ? 0 : this.isSupportsIops().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrderableDBInstanceOption)) {
            return false;
        }
        OrderableDBInstanceOption other = (OrderableDBInstanceOption)obj;
        if (other.getEngine() == null ^ this.getEngine() == null) {
            return false;
        }
        if (other.getEngine() != null && !other.getEngine().equals(this.getEngine())) {
            return false;
        }
        if (other.getEngineVersion() == null ^ this.getEngineVersion() == null) {
            return false;
        }
        if (other.getEngineVersion() != null && !other.getEngineVersion().equals(this.getEngineVersion())) {
            return false;
        }
        if (other.getDBInstanceClass() == null ^ this.getDBInstanceClass() == null) {
            return false;
        }
        if (other.getDBInstanceClass() != null && !other.getDBInstanceClass().equals(this.getDBInstanceClass())) {
            return false;
        }
        if (other.getLicenseModel() == null ^ this.getLicenseModel() == null) {
            return false;
        }
        if (other.getLicenseModel() != null && !other.getLicenseModel().equals(this.getLicenseModel())) {
            return false;
        }
        if (other.getAvailabilityZones() == null ^ this.getAvailabilityZones() == null) {
            return false;
        }
        if (other.getAvailabilityZones() != null && !other.getAvailabilityZones().equals(this.getAvailabilityZones())) {
            return false;
        }
        if (other.isMultiAZCapable() == null ^ this.isMultiAZCapable() == null) {
            return false;
        }
        if (other.isMultiAZCapable() != null && !other.isMultiAZCapable().equals(this.isMultiAZCapable())) {
            return false;
        }
        if (other.isReadReplicaCapable() == null ^ this.isReadReplicaCapable() == null) {
            return false;
        }
        if (other.isReadReplicaCapable() != null && !other.isReadReplicaCapable().equals(this.isReadReplicaCapable())) {
            return false;
        }
        if (other.isVpc() == null ^ this.isVpc() == null) {
            return false;
        }
        if (other.isVpc() != null && !other.isVpc().equals(this.isVpc())) {
            return false;
        }
        if (other.getStorageType() == null ^ this.getStorageType() == null) {
            return false;
        }
        if (other.getStorageType() != null && !other.getStorageType().equals(this.getStorageType())) {
            return false;
        }
        if (other.isSupportsIops() == null ^ this.isSupportsIops() == null) {
            return false;
        }
        return other.isSupportsIops() == null || other.isSupportsIops().equals(this.isSupportsIops());
    }
}

