/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.lambda.AWSLambdaAsync;
import com.amazonaws.services.lambda.AWSLambdaClient;
import com.amazonaws.services.lambda.model.AddEventSourceRequest;
import com.amazonaws.services.lambda.model.AddEventSourceResult;
import com.amazonaws.services.lambda.model.DeleteFunctionRequest;
import com.amazonaws.services.lambda.model.GetEventSourceRequest;
import com.amazonaws.services.lambda.model.GetEventSourceResult;
import com.amazonaws.services.lambda.model.GetFunctionConfigurationRequest;
import com.amazonaws.services.lambda.model.GetFunctionConfigurationResult;
import com.amazonaws.services.lambda.model.GetFunctionRequest;
import com.amazonaws.services.lambda.model.GetFunctionResult;
import com.amazonaws.services.lambda.model.InvokeAsyncRequest;
import com.amazonaws.services.lambda.model.InvokeAsyncResult;
import com.amazonaws.services.lambda.model.ListEventSourcesRequest;
import com.amazonaws.services.lambda.model.ListEventSourcesResult;
import com.amazonaws.services.lambda.model.ListFunctionsRequest;
import com.amazonaws.services.lambda.model.ListFunctionsResult;
import com.amazonaws.services.lambda.model.RemoveEventSourceRequest;
import com.amazonaws.services.lambda.model.UpdateFunctionConfigurationRequest;
import com.amazonaws.services.lambda.model.UpdateFunctionConfigurationResult;
import com.amazonaws.services.lambda.model.UploadFunctionRequest;
import com.amazonaws.services.lambda.model.UploadFunctionResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AWSLambdaAsyncClient
extends AWSLambdaClient
implements AWSLambdaAsync {
    private ExecutorService executorService;
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;

    public AWSLambdaAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AWSLambdaAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSLambdaAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AWSLambdaAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AWSLambdaAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AWSLambdaAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AWSLambdaAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AWSLambdaAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSLambdaAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<GetEventSourceResult> getEventSourceAsync(final GetEventSourceRequest getEventSourceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetEventSourceResult>(){

            @Override
            public GetEventSourceResult call() throws Exception {
                return AWSLambdaAsyncClient.this.getEventSource(getEventSourceRequest);
            }
        });
    }

    @Override
    public Future<GetEventSourceResult> getEventSourceAsync(final GetEventSourceRequest getEventSourceRequest, final AsyncHandler<GetEventSourceRequest, GetEventSourceResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetEventSourceResult>(){

            @Override
            public GetEventSourceResult call() throws Exception {
                GetEventSourceResult result;
                try {
                    result = AWSLambdaAsyncClient.this.getEventSource(getEventSourceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getEventSourceRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteFunctionAsync(final DeleteFunctionRequest deleteFunctionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSLambdaAsyncClient.this.deleteFunction(deleteFunctionRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteFunctionAsync(final DeleteFunctionRequest deleteFunctionRequest, final AsyncHandler<DeleteFunctionRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSLambdaAsyncClient.this.deleteFunction(deleteFunctionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteFunctionRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<ListFunctionsResult> listFunctionsAsync(final ListFunctionsRequest listFunctionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListFunctionsResult>(){

            @Override
            public ListFunctionsResult call() throws Exception {
                return AWSLambdaAsyncClient.this.listFunctions(listFunctionsRequest);
            }
        });
    }

    @Override
    public Future<ListFunctionsResult> listFunctionsAsync(final ListFunctionsRequest listFunctionsRequest, final AsyncHandler<ListFunctionsRequest, ListFunctionsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListFunctionsResult>(){

            @Override
            public ListFunctionsResult call() throws Exception {
                ListFunctionsResult result;
                try {
                    result = AWSLambdaAsyncClient.this.listFunctions(listFunctionsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listFunctionsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<AddEventSourceResult> addEventSourceAsync(final AddEventSourceRequest addEventSourceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AddEventSourceResult>(){

            @Override
            public AddEventSourceResult call() throws Exception {
                return AWSLambdaAsyncClient.this.addEventSource(addEventSourceRequest);
            }
        });
    }

    @Override
    public Future<AddEventSourceResult> addEventSourceAsync(final AddEventSourceRequest addEventSourceRequest, final AsyncHandler<AddEventSourceRequest, AddEventSourceResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AddEventSourceResult>(){

            @Override
            public AddEventSourceResult call() throws Exception {
                AddEventSourceResult result;
                try {
                    result = AWSLambdaAsyncClient.this.addEventSource(addEventSourceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(addEventSourceRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<UploadFunctionResult> uploadFunctionAsync(final UploadFunctionRequest uploadFunctionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UploadFunctionResult>(){

            @Override
            public UploadFunctionResult call() throws Exception {
                return AWSLambdaAsyncClient.this.uploadFunction(uploadFunctionRequest);
            }
        });
    }

    @Override
    public Future<UploadFunctionResult> uploadFunctionAsync(final UploadFunctionRequest uploadFunctionRequest, final AsyncHandler<UploadFunctionRequest, UploadFunctionResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UploadFunctionResult>(){

            @Override
            public UploadFunctionResult call() throws Exception {
                UploadFunctionResult result;
                try {
                    result = AWSLambdaAsyncClient.this.uploadFunction(uploadFunctionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(uploadFunctionRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetFunctionConfigurationResult> getFunctionConfigurationAsync(final GetFunctionConfigurationRequest getFunctionConfigurationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetFunctionConfigurationResult>(){

            @Override
            public GetFunctionConfigurationResult call() throws Exception {
                return AWSLambdaAsyncClient.this.getFunctionConfiguration(getFunctionConfigurationRequest);
            }
        });
    }

    @Override
    public Future<GetFunctionConfigurationResult> getFunctionConfigurationAsync(final GetFunctionConfigurationRequest getFunctionConfigurationRequest, final AsyncHandler<GetFunctionConfigurationRequest, GetFunctionConfigurationResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetFunctionConfigurationResult>(){

            @Override
            public GetFunctionConfigurationResult call() throws Exception {
                GetFunctionConfigurationResult result;
                try {
                    result = AWSLambdaAsyncClient.this.getFunctionConfiguration(getFunctionConfigurationRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getFunctionConfigurationRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<InvokeAsyncResult> invokeAsyncAsync(final InvokeAsyncRequest invokeAsyncRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<InvokeAsyncResult>(){

            @Override
            public InvokeAsyncResult call() throws Exception {
                return AWSLambdaAsyncClient.this.invokeAsync(invokeAsyncRequest);
            }
        });
    }

    @Override
    public Future<InvokeAsyncResult> invokeAsyncAsync(final InvokeAsyncRequest invokeAsyncRequest, final AsyncHandler<InvokeAsyncRequest, InvokeAsyncResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<InvokeAsyncResult>(){

            @Override
            public InvokeAsyncResult call() throws Exception {
                InvokeAsyncResult result;
                try {
                    result = AWSLambdaAsyncClient.this.invokeAsync(invokeAsyncRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(invokeAsyncRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListEventSourcesResult> listEventSourcesAsync(final ListEventSourcesRequest listEventSourcesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListEventSourcesResult>(){

            @Override
            public ListEventSourcesResult call() throws Exception {
                return AWSLambdaAsyncClient.this.listEventSources(listEventSourcesRequest);
            }
        });
    }

    @Override
    public Future<ListEventSourcesResult> listEventSourcesAsync(final ListEventSourcesRequest listEventSourcesRequest, final AsyncHandler<ListEventSourcesRequest, ListEventSourcesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListEventSourcesResult>(){

            @Override
            public ListEventSourcesResult call() throws Exception {
                ListEventSourcesResult result;
                try {
                    result = AWSLambdaAsyncClient.this.listEventSources(listEventSourcesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listEventSourcesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetFunctionResult> getFunctionAsync(final GetFunctionRequest getFunctionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetFunctionResult>(){

            @Override
            public GetFunctionResult call() throws Exception {
                return AWSLambdaAsyncClient.this.getFunction(getFunctionRequest);
            }
        });
    }

    @Override
    public Future<GetFunctionResult> getFunctionAsync(final GetFunctionRequest getFunctionRequest, final AsyncHandler<GetFunctionRequest, GetFunctionResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetFunctionResult>(){

            @Override
            public GetFunctionResult call() throws Exception {
                GetFunctionResult result;
                try {
                    result = AWSLambdaAsyncClient.this.getFunction(getFunctionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getFunctionRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<UpdateFunctionConfigurationResult> updateFunctionConfigurationAsync(final UpdateFunctionConfigurationRequest updateFunctionConfigurationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateFunctionConfigurationResult>(){

            @Override
            public UpdateFunctionConfigurationResult call() throws Exception {
                return AWSLambdaAsyncClient.this.updateFunctionConfiguration(updateFunctionConfigurationRequest);
            }
        });
    }

    @Override
    public Future<UpdateFunctionConfigurationResult> updateFunctionConfigurationAsync(final UpdateFunctionConfigurationRequest updateFunctionConfigurationRequest, final AsyncHandler<UpdateFunctionConfigurationRequest, UpdateFunctionConfigurationResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateFunctionConfigurationResult>(){

            @Override
            public UpdateFunctionConfigurationResult call() throws Exception {
                UpdateFunctionConfigurationResult result;
                try {
                    result = AWSLambdaAsyncClient.this.updateFunctionConfiguration(updateFunctionConfigurationRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(updateFunctionConfigurationRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> removeEventSourceAsync(final RemoveEventSourceRequest removeEventSourceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSLambdaAsyncClient.this.removeEventSource(removeEventSourceRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> removeEventSourceAsync(final RemoveEventSourceRequest removeEventSourceRequest, final AsyncHandler<RemoveEventSourceRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSLambdaAsyncClient.this.removeEventSource(removeEventSourceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(removeEventSourceRequest, null);
                return null;
            }
        });
    }
}

