/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.private5g;

import javax.annotation.Generated;

import com.amazonaws.services.private5g.model.*;

/**
 * Abstract implementation of {@code AWSPrivate5GAsync}. Convenient method forms pass through to the corresponding
 * overload that takes a request object and an {@code AsyncHandler}, which throws an
 * {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSPrivate5GAsync extends AbstractAWSPrivate5G implements AWSPrivate5GAsync {

    protected AbstractAWSPrivate5GAsync() {
    }

    @Override
    public java.util.concurrent.Future<AcknowledgeOrderReceiptResult> acknowledgeOrderReceiptAsync(AcknowledgeOrderReceiptRequest request) {

        return acknowledgeOrderReceiptAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<AcknowledgeOrderReceiptResult> acknowledgeOrderReceiptAsync(AcknowledgeOrderReceiptRequest request,
            com.amazonaws.handlers.AsyncHandler<AcknowledgeOrderReceiptRequest, AcknowledgeOrderReceiptResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ActivateDeviceIdentifierResult> activateDeviceIdentifierAsync(ActivateDeviceIdentifierRequest request) {

        return activateDeviceIdentifierAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ActivateDeviceIdentifierResult> activateDeviceIdentifierAsync(ActivateDeviceIdentifierRequest request,
            com.amazonaws.handlers.AsyncHandler<ActivateDeviceIdentifierRequest, ActivateDeviceIdentifierResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ActivateNetworkSiteResult> activateNetworkSiteAsync(ActivateNetworkSiteRequest request) {

        return activateNetworkSiteAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ActivateNetworkSiteResult> activateNetworkSiteAsync(ActivateNetworkSiteRequest request,
            com.amazonaws.handlers.AsyncHandler<ActivateNetworkSiteRequest, ActivateNetworkSiteResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ConfigureAccessPointResult> configureAccessPointAsync(ConfigureAccessPointRequest request) {

        return configureAccessPointAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ConfigureAccessPointResult> configureAccessPointAsync(ConfigureAccessPointRequest request,
            com.amazonaws.handlers.AsyncHandler<ConfigureAccessPointRequest, ConfigureAccessPointResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateNetworkResult> createNetworkAsync(CreateNetworkRequest request) {

        return createNetworkAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateNetworkResult> createNetworkAsync(CreateNetworkRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateNetworkRequest, CreateNetworkResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateNetworkSiteResult> createNetworkSiteAsync(CreateNetworkSiteRequest request) {

        return createNetworkSiteAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateNetworkSiteResult> createNetworkSiteAsync(CreateNetworkSiteRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateNetworkSiteRequest, CreateNetworkSiteResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeactivateDeviceIdentifierResult> deactivateDeviceIdentifierAsync(DeactivateDeviceIdentifierRequest request) {

        return deactivateDeviceIdentifierAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeactivateDeviceIdentifierResult> deactivateDeviceIdentifierAsync(DeactivateDeviceIdentifierRequest request,
            com.amazonaws.handlers.AsyncHandler<DeactivateDeviceIdentifierRequest, DeactivateDeviceIdentifierResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteNetworkResult> deleteNetworkAsync(DeleteNetworkRequest request) {

        return deleteNetworkAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteNetworkResult> deleteNetworkAsync(DeleteNetworkRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteNetworkRequest, DeleteNetworkResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteNetworkSiteResult> deleteNetworkSiteAsync(DeleteNetworkSiteRequest request) {

        return deleteNetworkSiteAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteNetworkSiteResult> deleteNetworkSiteAsync(DeleteNetworkSiteRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteNetworkSiteRequest, DeleteNetworkSiteResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetDeviceIdentifierResult> getDeviceIdentifierAsync(GetDeviceIdentifierRequest request) {

        return getDeviceIdentifierAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetDeviceIdentifierResult> getDeviceIdentifierAsync(GetDeviceIdentifierRequest request,
            com.amazonaws.handlers.AsyncHandler<GetDeviceIdentifierRequest, GetDeviceIdentifierResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetNetworkResult> getNetworkAsync(GetNetworkRequest request) {

        return getNetworkAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetNetworkResult> getNetworkAsync(GetNetworkRequest request,
            com.amazonaws.handlers.AsyncHandler<GetNetworkRequest, GetNetworkResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetNetworkResourceResult> getNetworkResourceAsync(GetNetworkResourceRequest request) {

        return getNetworkResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetNetworkResourceResult> getNetworkResourceAsync(GetNetworkResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<GetNetworkResourceRequest, GetNetworkResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetNetworkSiteResult> getNetworkSiteAsync(GetNetworkSiteRequest request) {

        return getNetworkSiteAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetNetworkSiteResult> getNetworkSiteAsync(GetNetworkSiteRequest request,
            com.amazonaws.handlers.AsyncHandler<GetNetworkSiteRequest, GetNetworkSiteResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetOrderResult> getOrderAsync(GetOrderRequest request) {

        return getOrderAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetOrderResult> getOrderAsync(GetOrderRequest request,
            com.amazonaws.handlers.AsyncHandler<GetOrderRequest, GetOrderResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListDeviceIdentifiersResult> listDeviceIdentifiersAsync(ListDeviceIdentifiersRequest request) {

        return listDeviceIdentifiersAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListDeviceIdentifiersResult> listDeviceIdentifiersAsync(ListDeviceIdentifiersRequest request,
            com.amazonaws.handlers.AsyncHandler<ListDeviceIdentifiersRequest, ListDeviceIdentifiersResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListNetworkResourcesResult> listNetworkResourcesAsync(ListNetworkResourcesRequest request) {

        return listNetworkResourcesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListNetworkResourcesResult> listNetworkResourcesAsync(ListNetworkResourcesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListNetworkResourcesRequest, ListNetworkResourcesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListNetworkSitesResult> listNetworkSitesAsync(ListNetworkSitesRequest request) {

        return listNetworkSitesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListNetworkSitesResult> listNetworkSitesAsync(ListNetworkSitesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListNetworkSitesRequest, ListNetworkSitesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListNetworksResult> listNetworksAsync(ListNetworksRequest request) {

        return listNetworksAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListNetworksResult> listNetworksAsync(ListNetworksRequest request,
            com.amazonaws.handlers.AsyncHandler<ListNetworksRequest, ListNetworksResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListOrdersResult> listOrdersAsync(ListOrdersRequest request) {

        return listOrdersAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListOrdersResult> listOrdersAsync(ListOrdersRequest request,
            com.amazonaws.handlers.AsyncHandler<ListOrdersRequest, ListOrdersResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {

        return listTagsForResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<PingResult> pingAsync(PingRequest request) {

        return pingAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<PingResult> pingAsync(PingRequest request, com.amazonaws.handlers.AsyncHandler<PingRequest, PingResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {

        return tagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {

        return untagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateNetworkSiteResult> updateNetworkSiteAsync(UpdateNetworkSiteRequest request) {

        return updateNetworkSiteAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateNetworkSiteResult> updateNetworkSiteAsync(UpdateNetworkSiteRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateNetworkSiteRequest, UpdateNetworkSiteResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateNetworkSitePlanResult> updateNetworkSitePlanAsync(UpdateNetworkSitePlanRequest request) {

        return updateNetworkSitePlanAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateNetworkSitePlanResult> updateNetworkSitePlanAsync(UpdateNetworkSitePlanRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateNetworkSitePlanRequest, UpdateNetworkSitePlanResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

}
