/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.ForwardedValues;
import com.amazonaws.services.cloudfront.model.transform.CookiePreferenceStaxUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.HeadersStaxUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.QueryStringCacheKeysStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class ForwardedValuesStaxUnmarshaller
implements Unmarshaller<ForwardedValues, StaxUnmarshallerContext> {
    private static ForwardedValuesStaxUnmarshaller instance;

    @Override
    public ForwardedValues unmarshall(StaxUnmarshallerContext context) throws Exception {
        ForwardedValues forwardedValues = new ForwardedValues();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return forwardedValues;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("QueryString", targetDepth)) {
                    forwardedValues.setQueryString(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Cookies", targetDepth)) {
                    forwardedValues.setCookies(CookiePreferenceStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Headers", targetDepth)) {
                    forwardedValues.setHeaders(HeadersStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("QueryStringCacheKeys", targetDepth)) continue;
                forwardedValues.setQueryStringCacheKeys(QueryStringCacheKeysStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return forwardedValues;
    }

    public static ForwardedValuesStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ForwardedValuesStaxUnmarshaller();
        }
        return instance;
    }
}

