/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codecommit.model.GetDifferencesRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class GetDifferencesRequestMarshaller
implements Marshaller<Request<GetDifferencesRequest>, GetDifferencesRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public GetDifferencesRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetDifferencesRequest> marshall(GetDifferencesRequest getDifferencesRequest) {
        if (getDifferencesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetDifferencesRequest> request = new DefaultRequest<GetDifferencesRequest>(getDifferencesRequest, "AWSCodeCommit");
        request.addHeader("X-Amz-Target", "CodeCommit_20150413.GetDifferences");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (getDifferencesRequest.getRepositoryName() != null) {
                jsonGenerator.writeFieldName("repositoryName").writeValue(getDifferencesRequest.getRepositoryName());
            }
            if (getDifferencesRequest.getBeforeCommitSpecifier() != null) {
                jsonGenerator.writeFieldName("beforeCommitSpecifier").writeValue(getDifferencesRequest.getBeforeCommitSpecifier());
            }
            if (getDifferencesRequest.getAfterCommitSpecifier() != null) {
                jsonGenerator.writeFieldName("afterCommitSpecifier").writeValue(getDifferencesRequest.getAfterCommitSpecifier());
            }
            if (getDifferencesRequest.getBeforePath() != null) {
                jsonGenerator.writeFieldName("beforePath").writeValue(getDifferencesRequest.getBeforePath());
            }
            if (getDifferencesRequest.getAfterPath() != null) {
                jsonGenerator.writeFieldName("afterPath").writeValue(getDifferencesRequest.getAfterPath());
            }
            if (getDifferencesRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("MaxResults").writeValue(getDifferencesRequest.getMaxResults());
            }
            if (getDifferencesRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(getDifferencesRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

