/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndexDescription;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndexDescription;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import com.amazonaws.services.dynamodbv2.model.transform.AttributeDefinitionJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.GlobalSecondaryIndexDescriptionJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.KeySchemaElementJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.LocalSecondaryIndexDescriptionJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ProvisionedThroughputDescriptionJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.StreamSpecificationJsonMarshaller;
import java.util.List;

public class TableDescriptionJsonMarshaller {
    private static TableDescriptionJsonMarshaller instance;

    public void marshall(TableDescription tableDescription, StructuredJsonGenerator jsonGenerator) {
        if (tableDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<GlobalSecondaryIndexDescription> list;
            List<LocalSecondaryIndexDescription> list2;
            List<KeySchemaElement> keySchemaList;
            jsonGenerator.writeStartObject();
            List<AttributeDefinition> attributeDefinitionsList = tableDescription.getAttributeDefinitions();
            if (attributeDefinitionsList != null) {
                jsonGenerator.writeFieldName("AttributeDefinitions");
                jsonGenerator.writeStartArray();
                for (AttributeDefinition attributeDefinition : attributeDefinitionsList) {
                    if (attributeDefinition == null) continue;
                    AttributeDefinitionJsonMarshaller.getInstance().marshall(attributeDefinition, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (tableDescription.getTableName() != null) {
                jsonGenerator.writeFieldName("TableName").writeValue(tableDescription.getTableName());
            }
            if ((keySchemaList = tableDescription.getKeySchema()) != null) {
                jsonGenerator.writeFieldName("KeySchema");
                jsonGenerator.writeStartArray();
                for (KeySchemaElement keySchemaElement : keySchemaList) {
                    if (keySchemaElement == null) continue;
                    KeySchemaElementJsonMarshaller.getInstance().marshall(keySchemaElement, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (tableDescription.getTableStatus() != null) {
                jsonGenerator.writeFieldName("TableStatus").writeValue(tableDescription.getTableStatus());
            }
            if (tableDescription.getCreationDateTime() != null) {
                jsonGenerator.writeFieldName("CreationDateTime").writeValue(tableDescription.getCreationDateTime());
            }
            if (tableDescription.getProvisionedThroughput() != null) {
                jsonGenerator.writeFieldName("ProvisionedThroughput");
                ProvisionedThroughputDescriptionJsonMarshaller.getInstance().marshall(tableDescription.getProvisionedThroughput(), jsonGenerator);
            }
            if (tableDescription.getTableSizeBytes() != null) {
                jsonGenerator.writeFieldName("TableSizeBytes").writeValue(tableDescription.getTableSizeBytes());
            }
            if (tableDescription.getItemCount() != null) {
                jsonGenerator.writeFieldName("ItemCount").writeValue(tableDescription.getItemCount());
            }
            if (tableDescription.getTableArn() != null) {
                jsonGenerator.writeFieldName("TableArn").writeValue(tableDescription.getTableArn());
            }
            if ((list2 = tableDescription.getLocalSecondaryIndexes()) != null) {
                jsonGenerator.writeFieldName("LocalSecondaryIndexes");
                jsonGenerator.writeStartArray();
                for (LocalSecondaryIndexDescription localSecondaryIndexesListValue : list2) {
                    if (localSecondaryIndexesListValue == null) continue;
                    LocalSecondaryIndexDescriptionJsonMarshaller.getInstance().marshall(localSecondaryIndexesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((list = tableDescription.getGlobalSecondaryIndexes()) != null) {
                jsonGenerator.writeFieldName("GlobalSecondaryIndexes");
                jsonGenerator.writeStartArray();
                for (GlobalSecondaryIndexDescription globalSecondaryIndexesListValue : list) {
                    if (globalSecondaryIndexesListValue == null) continue;
                    GlobalSecondaryIndexDescriptionJsonMarshaller.getInstance().marshall(globalSecondaryIndexesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (tableDescription.getStreamSpecification() != null) {
                jsonGenerator.writeFieldName("StreamSpecification");
                StreamSpecificationJsonMarshaller.getInstance().marshall(tableDescription.getStreamSpecification(), jsonGenerator);
            }
            if (tableDescription.getLatestStreamLabel() != null) {
                jsonGenerator.writeFieldName("LatestStreamLabel").writeValue(tableDescription.getLatestStreamLabel());
            }
            if (tableDescription.getLatestStreamArn() != null) {
                jsonGenerator.writeFieldName("LatestStreamArn").writeValue(tableDescription.getLatestStreamArn());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static TableDescriptionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new TableDescriptionJsonMarshaller();
        }
        return instance;
    }
}

