/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simplesystemsmanagement.model.UpdatePatchBaselineRequest;
import com.amazonaws.services.simplesystemsmanagement.model.transform.PatchFilterGroupJsonMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.PatchRuleGroupJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class UpdatePatchBaselineRequestMarshaller
implements Marshaller<Request<UpdatePatchBaselineRequest>, UpdatePatchBaselineRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public UpdatePatchBaselineRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<UpdatePatchBaselineRequest> marshall(UpdatePatchBaselineRequest updatePatchBaselineRequest) {
        if (updatePatchBaselineRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdatePatchBaselineRequest> request = new DefaultRequest<UpdatePatchBaselineRequest>(updatePatchBaselineRequest, "AWSSimpleSystemsManagement");
        request.addHeader("X-Amz-Target", "AmazonSSM.UpdatePatchBaseline");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList rejectedPatchesList;
            SdkInternalList approvedPatchesList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updatePatchBaselineRequest.getBaselineId() != null) {
                jsonGenerator.writeFieldName("BaselineId").writeValue(updatePatchBaselineRequest.getBaselineId());
            }
            if (updatePatchBaselineRequest.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(updatePatchBaselineRequest.getName());
            }
            if (updatePatchBaselineRequest.getGlobalFilters() != null) {
                jsonGenerator.writeFieldName("GlobalFilters");
                PatchFilterGroupJsonMarshaller.getInstance().marshall(updatePatchBaselineRequest.getGlobalFilters(), jsonGenerator);
            }
            if (updatePatchBaselineRequest.getApprovalRules() != null) {
                jsonGenerator.writeFieldName("ApprovalRules");
                PatchRuleGroupJsonMarshaller.getInstance().marshall(updatePatchBaselineRequest.getApprovalRules(), jsonGenerator);
            }
            if (!(approvedPatchesList = (SdkInternalList)updatePatchBaselineRequest.getApprovedPatches()).isEmpty() || !approvedPatchesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("ApprovedPatches");
                jsonGenerator.writeStartArray();
                for (Object approvedPatchesListValue : approvedPatchesList) {
                    if (approvedPatchesListValue == null) continue;
                    jsonGenerator.writeValue((String)approvedPatchesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(rejectedPatchesList = (SdkInternalList)updatePatchBaselineRequest.getRejectedPatches()).isEmpty() || !rejectedPatchesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("RejectedPatches");
                jsonGenerator.writeStartArray();
                for (String rejectedPatchesListValue : rejectedPatchesList) {
                    if (rejectedPatchesListValue == null) continue;
                    jsonGenerator.writeValue(rejectedPatchesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (updatePatchBaselineRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(updatePatchBaselineRequest.getDescription());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

