/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simplesystemsmanagement.model.PatchFilter;
import com.amazonaws.services.simplesystemsmanagement.model.PatchFilterGroup;
import com.amazonaws.services.simplesystemsmanagement.model.transform.PatchFilterJsonMarshaller;

public class PatchFilterGroupJsonMarshaller {
    private static PatchFilterGroupJsonMarshaller instance;

    public void marshall(PatchFilterGroup patchFilterGroup, StructuredJsonGenerator jsonGenerator) {
        if (patchFilterGroup == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            SdkInternalList patchFiltersList = (SdkInternalList)patchFilterGroup.getPatchFilters();
            if (!patchFiltersList.isEmpty() || !patchFiltersList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("PatchFilters");
                jsonGenerator.writeStartArray();
                for (PatchFilter patchFiltersListValue : patchFiltersList) {
                    if (patchFiltersListValue == null) continue;
                    PatchFilterJsonMarshaller.getInstance().marshall(patchFiltersListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static PatchFilterGroupJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new PatchFilterGroupJsonMarshaller();
        }
        return instance;
    }
}

