/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simplesystemsmanagement.model.DescribeAvailablePatchesRequest;
import com.amazonaws.services.simplesystemsmanagement.model.PatchOrchestratorFilter;
import com.amazonaws.services.simplesystemsmanagement.model.transform.PatchOrchestratorFilterJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DescribeAvailablePatchesRequestMarshaller
implements Marshaller<Request<DescribeAvailablePatchesRequest>, DescribeAvailablePatchesRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeAvailablePatchesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeAvailablePatchesRequest> marshall(DescribeAvailablePatchesRequest describeAvailablePatchesRequest) {
        if (describeAvailablePatchesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeAvailablePatchesRequest> request = new DefaultRequest<DescribeAvailablePatchesRequest>(describeAvailablePatchesRequest, "AWSSimpleSystemsManagement");
        request.addHeader("X-Amz-Target", "AmazonSSM.DescribeAvailablePatches");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            SdkInternalList filtersList = (SdkInternalList)describeAvailablePatchesRequest.getFilters();
            if (!filtersList.isEmpty() || !filtersList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Filters");
                jsonGenerator.writeStartArray();
                for (PatchOrchestratorFilter filtersListValue : filtersList) {
                    if (filtersListValue == null) continue;
                    PatchOrchestratorFilterJsonMarshaller.getInstance().marshall(filtersListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (describeAvailablePatchesRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("MaxResults").writeValue(describeAvailablePatchesRequest.getMaxResults());
            }
            if (describeAvailablePatchesRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(describeAvailablePatchesRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

