/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simplesystemsmanagement.model.PatchFilterGroup;
import com.amazonaws.services.simplesystemsmanagement.model.PatchRuleGroup;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreatePatchBaselineRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private PatchFilterGroup globalFilters;
    private PatchRuleGroup approvalRules;
    private SdkInternalList<String> approvedPatches;
    private SdkInternalList<String> rejectedPatches;
    private String description;
    private String clientToken;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreatePatchBaselineRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setGlobalFilters(PatchFilterGroup globalFilters) {
        this.globalFilters = globalFilters;
    }

    public PatchFilterGroup getGlobalFilters() {
        return this.globalFilters;
    }

    public CreatePatchBaselineRequest withGlobalFilters(PatchFilterGroup globalFilters) {
        this.setGlobalFilters(globalFilters);
        return this;
    }

    public void setApprovalRules(PatchRuleGroup approvalRules) {
        this.approvalRules = approvalRules;
    }

    public PatchRuleGroup getApprovalRules() {
        return this.approvalRules;
    }

    public CreatePatchBaselineRequest withApprovalRules(PatchRuleGroup approvalRules) {
        this.setApprovalRules(approvalRules);
        return this;
    }

    public List<String> getApprovedPatches() {
        if (this.approvedPatches == null) {
            this.approvedPatches = new SdkInternalList();
        }
        return this.approvedPatches;
    }

    public void setApprovedPatches(Collection<String> approvedPatches) {
        if (approvedPatches == null) {
            this.approvedPatches = null;
            return;
        }
        this.approvedPatches = new SdkInternalList<String>(approvedPatches);
    }

    public CreatePatchBaselineRequest withApprovedPatches(String ... approvedPatches) {
        if (this.approvedPatches == null) {
            this.setApprovedPatches(new SdkInternalList<String>(approvedPatches.length));
        }
        for (String ele : approvedPatches) {
            this.approvedPatches.add(ele);
        }
        return this;
    }

    public CreatePatchBaselineRequest withApprovedPatches(Collection<String> approvedPatches) {
        this.setApprovedPatches(approvedPatches);
        return this;
    }

    public List<String> getRejectedPatches() {
        if (this.rejectedPatches == null) {
            this.rejectedPatches = new SdkInternalList();
        }
        return this.rejectedPatches;
    }

    public void setRejectedPatches(Collection<String> rejectedPatches) {
        if (rejectedPatches == null) {
            this.rejectedPatches = null;
            return;
        }
        this.rejectedPatches = new SdkInternalList<String>(rejectedPatches);
    }

    public CreatePatchBaselineRequest withRejectedPatches(String ... rejectedPatches) {
        if (this.rejectedPatches == null) {
            this.setRejectedPatches(new SdkInternalList<String>(rejectedPatches.length));
        }
        for (String ele : rejectedPatches) {
            this.rejectedPatches.add(ele);
        }
        return this;
    }

    public CreatePatchBaselineRequest withRejectedPatches(Collection<String> rejectedPatches) {
        this.setRejectedPatches(rejectedPatches);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreatePatchBaselineRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreatePatchBaselineRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: " + this.getName() + ",");
        }
        if (this.getGlobalFilters() != null) {
            sb.append("GlobalFilters: " + this.getGlobalFilters() + ",");
        }
        if (this.getApprovalRules() != null) {
            sb.append("ApprovalRules: " + this.getApprovalRules() + ",");
        }
        if (this.getApprovedPatches() != null) {
            sb.append("ApprovedPatches: " + this.getApprovedPatches() + ",");
        }
        if (this.getRejectedPatches() != null) {
            sb.append("RejectedPatches: " + this.getRejectedPatches() + ",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: " + this.getDescription() + ",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: " + this.getClientToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePatchBaselineRequest)) {
            return false;
        }
        CreatePatchBaselineRequest other = (CreatePatchBaselineRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getGlobalFilters() == null ^ this.getGlobalFilters() == null) {
            return false;
        }
        if (other.getGlobalFilters() != null && !other.getGlobalFilters().equals(this.getGlobalFilters())) {
            return false;
        }
        if (other.getApprovalRules() == null ^ this.getApprovalRules() == null) {
            return false;
        }
        if (other.getApprovalRules() != null && !other.getApprovalRules().equals(this.getApprovalRules())) {
            return false;
        }
        if (other.getApprovedPatches() == null ^ this.getApprovedPatches() == null) {
            return false;
        }
        if (other.getApprovedPatches() != null && !other.getApprovedPatches().equals(this.getApprovedPatches())) {
            return false;
        }
        if (other.getRejectedPatches() == null ^ this.getRejectedPatches() == null) {
            return false;
        }
        if (other.getRejectedPatches() != null && !other.getRejectedPatches().equals(this.getRejectedPatches())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        return other.getClientToken() == null || other.getClientToken().equals(this.getClientToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getGlobalFilters() == null ? 0 : this.getGlobalFilters().hashCode());
        hashCode = 31 * hashCode + (this.getApprovalRules() == null ? 0 : this.getApprovalRules().hashCode());
        hashCode = 31 * hashCode + (this.getApprovedPatches() == null ? 0 : this.getApprovedPatches().hashCode());
        hashCode = 31 * hashCode + (this.getRejectedPatches() == null ? 0 : this.getRejectedPatches().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        return hashCode;
    }

    @Override
    public CreatePatchBaselineRequest clone() {
        return (CreatePatchBaselineRequest)super.clone();
    }
}

