/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.rekognition.model.Attribute;
import com.amazonaws.services.rekognition.model.Image;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DetectFacesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private Image image;
    private List<String> attributes;

    public void setImage(Image image) {
        this.image = image;
    }

    public Image getImage() {
        return this.image;
    }

    public DetectFacesRequest withImage(Image image) {
        this.setImage(image);
        return this;
    }

    public List<String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Collection<String> attributes) {
        if (attributes == null) {
            this.attributes = null;
            return;
        }
        this.attributes = new ArrayList<String>(attributes);
    }

    public DetectFacesRequest withAttributes(String ... attributes) {
        if (this.attributes == null) {
            this.setAttributes(new ArrayList<String>(attributes.length));
        }
        for (String ele : attributes) {
            this.attributes.add(ele);
        }
        return this;
    }

    public DetectFacesRequest withAttributes(Collection<String> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public DetectFacesRequest withAttributes(Attribute ... attributes) {
        ArrayList<String> attributesCopy = new ArrayList<String>(attributes.length);
        for (Attribute value : attributes) {
            attributesCopy.add(value.toString());
        }
        if (this.getAttributes() == null) {
            this.setAttributes(attributesCopy);
        } else {
            this.getAttributes().addAll(attributesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getImage() != null) {
            sb.append("Image: " + this.getImage() + ",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: " + this.getAttributes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectFacesRequest)) {
            return false;
        }
        DetectFacesRequest other = (DetectFacesRequest)obj;
        if (other.getImage() == null ^ this.getImage() == null) {
            return false;
        }
        if (other.getImage() != null && !other.getImage().equals(this.getImage())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        return other.getAttributes() == null || other.getAttributes().equals(this.getAttributes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getImage() == null ? 0 : this.getImage().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        return hashCode;
    }

    @Override
    public DetectFacesRequest clone() {
        return (DetectFacesRequest)super.clone();
    }
}

