/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.pinpoint.AmazonPinpoint;
import com.amazonaws.services.pinpoint.model.AmazonPinpointException;
import com.amazonaws.services.pinpoint.model.BadRequestException;
import com.amazonaws.services.pinpoint.model.CreateCampaignRequest;
import com.amazonaws.services.pinpoint.model.CreateCampaignResult;
import com.amazonaws.services.pinpoint.model.CreateImportJobRequest;
import com.amazonaws.services.pinpoint.model.CreateImportJobResult;
import com.amazonaws.services.pinpoint.model.CreateSegmentRequest;
import com.amazonaws.services.pinpoint.model.CreateSegmentResult;
import com.amazonaws.services.pinpoint.model.DeleteApnsChannelRequest;
import com.amazonaws.services.pinpoint.model.DeleteApnsChannelResult;
import com.amazonaws.services.pinpoint.model.DeleteCampaignRequest;
import com.amazonaws.services.pinpoint.model.DeleteCampaignResult;
import com.amazonaws.services.pinpoint.model.DeleteGcmChannelRequest;
import com.amazonaws.services.pinpoint.model.DeleteGcmChannelResult;
import com.amazonaws.services.pinpoint.model.DeleteSegmentRequest;
import com.amazonaws.services.pinpoint.model.DeleteSegmentResult;
import com.amazonaws.services.pinpoint.model.ForbiddenException;
import com.amazonaws.services.pinpoint.model.GetApnsChannelRequest;
import com.amazonaws.services.pinpoint.model.GetApnsChannelResult;
import com.amazonaws.services.pinpoint.model.GetApplicationSettingsRequest;
import com.amazonaws.services.pinpoint.model.GetApplicationSettingsResult;
import com.amazonaws.services.pinpoint.model.GetCampaignActivitiesRequest;
import com.amazonaws.services.pinpoint.model.GetCampaignActivitiesResult;
import com.amazonaws.services.pinpoint.model.GetCampaignRequest;
import com.amazonaws.services.pinpoint.model.GetCampaignResult;
import com.amazonaws.services.pinpoint.model.GetCampaignVersionRequest;
import com.amazonaws.services.pinpoint.model.GetCampaignVersionResult;
import com.amazonaws.services.pinpoint.model.GetCampaignVersionsRequest;
import com.amazonaws.services.pinpoint.model.GetCampaignVersionsResult;
import com.amazonaws.services.pinpoint.model.GetCampaignsRequest;
import com.amazonaws.services.pinpoint.model.GetCampaignsResult;
import com.amazonaws.services.pinpoint.model.GetEndpointRequest;
import com.amazonaws.services.pinpoint.model.GetEndpointResult;
import com.amazonaws.services.pinpoint.model.GetGcmChannelRequest;
import com.amazonaws.services.pinpoint.model.GetGcmChannelResult;
import com.amazonaws.services.pinpoint.model.GetImportJobRequest;
import com.amazonaws.services.pinpoint.model.GetImportJobResult;
import com.amazonaws.services.pinpoint.model.GetImportJobsRequest;
import com.amazonaws.services.pinpoint.model.GetImportJobsResult;
import com.amazonaws.services.pinpoint.model.GetSegmentImportJobsRequest;
import com.amazonaws.services.pinpoint.model.GetSegmentImportJobsResult;
import com.amazonaws.services.pinpoint.model.GetSegmentRequest;
import com.amazonaws.services.pinpoint.model.GetSegmentResult;
import com.amazonaws.services.pinpoint.model.GetSegmentVersionRequest;
import com.amazonaws.services.pinpoint.model.GetSegmentVersionResult;
import com.amazonaws.services.pinpoint.model.GetSegmentVersionsRequest;
import com.amazonaws.services.pinpoint.model.GetSegmentVersionsResult;
import com.amazonaws.services.pinpoint.model.GetSegmentsRequest;
import com.amazonaws.services.pinpoint.model.GetSegmentsResult;
import com.amazonaws.services.pinpoint.model.InternalServerErrorException;
import com.amazonaws.services.pinpoint.model.MethodNotAllowedException;
import com.amazonaws.services.pinpoint.model.NotFoundException;
import com.amazonaws.services.pinpoint.model.TooManyRequestsException;
import com.amazonaws.services.pinpoint.model.UpdateApnsChannelRequest;
import com.amazonaws.services.pinpoint.model.UpdateApnsChannelResult;
import com.amazonaws.services.pinpoint.model.UpdateApplicationSettingsRequest;
import com.amazonaws.services.pinpoint.model.UpdateApplicationSettingsResult;
import com.amazonaws.services.pinpoint.model.UpdateCampaignRequest;
import com.amazonaws.services.pinpoint.model.UpdateCampaignResult;
import com.amazonaws.services.pinpoint.model.UpdateEndpointRequest;
import com.amazonaws.services.pinpoint.model.UpdateEndpointResult;
import com.amazonaws.services.pinpoint.model.UpdateEndpointsBatchRequest;
import com.amazonaws.services.pinpoint.model.UpdateEndpointsBatchResult;
import com.amazonaws.services.pinpoint.model.UpdateGcmChannelRequest;
import com.amazonaws.services.pinpoint.model.UpdateGcmChannelResult;
import com.amazonaws.services.pinpoint.model.UpdateSegmentRequest;
import com.amazonaws.services.pinpoint.model.UpdateSegmentResult;
import com.amazonaws.services.pinpoint.model.transform.CreateCampaignRequestMarshaller;
import com.amazonaws.services.pinpoint.model.transform.CreateCampaignResultJsonUnmarshaller;
import com.amazonaws.services.pinpoint.model.transform.CreateImportJobRequestMarshaller;
import com.amazonaws.services.pinpoint.model.transform.CreateImportJobResultJsonUnmarshaller;
import com.amazonaws.services.pinpoint.model.transform.CreateSegmentRequestMarshaller;
import com.amazonaws.services.pinpoint.model.transform.CreateSegmentResultJsonUnmarshaller;
import com.amazonaws.services.pinpoint.model.transform.DeleteApnsChannelRequestMarshaller;
import com.amazonaws.services.pinpoint.model.transform.DeleteApnsChannelResultJsonUnmarshaller;
import com.amazonaws.services.pinpoint.model.transform.DeleteCampaignRequestMarshaller;
import com.amazonaws.services.pinpoint.model.transform.DeleteCampaignResultJsonUnmarshaller;
import com.amazonaws.services.pinpoint.model.transform.DeleteGcmChannelRequestMarshaller;
import com.amazonaws.services.pinpoint.model.transform.DeleteGcmChannelResultJsonUnmarshaller;
import com.amazonaws.services.pinpoint.model.transform.DeleteSegmentRequestMarshaller;
import com.amazonaws.services.pinpoint.model.transform.DeleteSegmentResultJsonUnmarshaller;
import com.amazonaws.services.pinpoint.model.transform.GetApnsChannelRequestMarshaller;
import com.amazonaws.services.pinpoint.model.transform.GetApnsChannelResultJsonUnmarshaller;
import com.amazonaws.services.pinpoint.model.transform.GetApplicationSettingsRequestMarshaller;
import com.amazonaws.services.pinpoint.model.transform.GetApplicationSettingsResultJsonUnmarshaller;
import com.amazonaws.services.pinpoint.model.transform.GetCampaignActivitiesRequestMarshaller;
import com.amazonaws.services.pinpoint.model.transform.GetCampaignActivitiesResultJsonUnmarshaller;
import com.amazonaws.services.pinpoint.model.transform.GetCampaignRequestMarshaller;
import com.amazonaws.services.pinpoint.model.transform.GetCampaignResultJsonUnmarshaller;
import com.amazonaws.services.pinpoint.model.transform.GetCampaignVersionRequestMarshaller;
import com.amazonaws.services.pinpoint.model.transform.GetCampaignVersionResultJsonUnmarshaller;
import com.amazonaws.services.pinpoint.model.transform.GetCampaignVersionsRequestMarshaller;
import com.amazonaws.services.pinpoint.model.transform.GetCampaignVersionsResultJsonUnmarshaller;
import com.amazonaws.services.pinpoint.model.transform.GetCampaignsRequestMarshaller;
import com.amazonaws.services.pinpoint.model.transform.GetCampaignsResultJsonUnmarshaller;
import com.amazonaws.services.pinpoint.model.transform.GetEndpointRequestMarshaller;
import com.amazonaws.services.pinpoint.model.transform.GetEndpointResultJsonUnmarshaller;
import com.amazonaws.services.pinpoint.model.transform.GetGcmChannelRequestMarshaller;
import com.amazonaws.services.pinpoint.model.transform.GetGcmChannelResultJsonUnmarshaller;
import com.amazonaws.services.pinpoint.model.transform.GetImportJobRequestMarshaller;
import com.amazonaws.services.pinpoint.model.transform.GetImportJobResultJsonUnmarshaller;
import com.amazonaws.services.pinpoint.model.transform.GetImportJobsRequestMarshaller;
import com.amazonaws.services.pinpoint.model.transform.GetImportJobsResultJsonUnmarshaller;
import com.amazonaws.services.pinpoint.model.transform.GetSegmentImportJobsRequestMarshaller;
import com.amazonaws.services.pinpoint.model.transform.GetSegmentImportJobsResultJsonUnmarshaller;
import com.amazonaws.services.pinpoint.model.transform.GetSegmentRequestMarshaller;
import com.amazonaws.services.pinpoint.model.transform.GetSegmentResultJsonUnmarshaller;
import com.amazonaws.services.pinpoint.model.transform.GetSegmentVersionRequestMarshaller;
import com.amazonaws.services.pinpoint.model.transform.GetSegmentVersionResultJsonUnmarshaller;
import com.amazonaws.services.pinpoint.model.transform.GetSegmentVersionsRequestMarshaller;
import com.amazonaws.services.pinpoint.model.transform.GetSegmentVersionsResultJsonUnmarshaller;
import com.amazonaws.services.pinpoint.model.transform.GetSegmentsRequestMarshaller;
import com.amazonaws.services.pinpoint.model.transform.GetSegmentsResultJsonUnmarshaller;
import com.amazonaws.services.pinpoint.model.transform.UpdateApnsChannelRequestMarshaller;
import com.amazonaws.services.pinpoint.model.transform.UpdateApnsChannelResultJsonUnmarshaller;
import com.amazonaws.services.pinpoint.model.transform.UpdateApplicationSettingsRequestMarshaller;
import com.amazonaws.services.pinpoint.model.transform.UpdateApplicationSettingsResultJsonUnmarshaller;
import com.amazonaws.services.pinpoint.model.transform.UpdateCampaignRequestMarshaller;
import com.amazonaws.services.pinpoint.model.transform.UpdateCampaignResultJsonUnmarshaller;
import com.amazonaws.services.pinpoint.model.transform.UpdateEndpointRequestMarshaller;
import com.amazonaws.services.pinpoint.model.transform.UpdateEndpointResultJsonUnmarshaller;
import com.amazonaws.services.pinpoint.model.transform.UpdateEndpointsBatchRequestMarshaller;
import com.amazonaws.services.pinpoint.model.transform.UpdateEndpointsBatchResultJsonUnmarshaller;
import com.amazonaws.services.pinpoint.model.transform.UpdateGcmChannelRequestMarshaller;
import com.amazonaws.services.pinpoint.model.transform.UpdateGcmChannelResultJsonUnmarshaller;
import com.amazonaws.services.pinpoint.model.transform.UpdateSegmentRequestMarshaller;
import com.amazonaws.services.pinpoint.model.transform.UpdateSegmentResultJsonUnmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.ValidationUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonPinpointClient
extends AmazonWebServiceClient
implements AmazonPinpoint {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonPinpoint.class);
    private static final String DEFAULT_SIGNING_NAME = "mobiletargeting";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withModeledClass(NotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MethodNotAllowedException").withModeledClass(MethodNotAllowedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ForbiddenException").withModeledClass(ForbiddenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyRequestsException").withModeledClass(TooManyRequestsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BadRequestException").withModeledClass(BadRequestException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerErrorException").withModeledClass(InternalServerErrorException.class)).withBaseServiceExceptionClass(AmazonPinpointException.class));

    public AmazonPinpointClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    public AmazonPinpointClient(ClientConfiguration clientConfiguration) {
        this(DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    public AmazonPinpointClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    public AmazonPinpointClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonPinpointClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    public AmazonPinpointClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AmazonPinpointClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    AmazonPinpointClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix("pinpoint");
        this.setEndpoint("https://pinpoint.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/pinpoint/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/pinpoint/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateCampaignResult createCampaign(CreateCampaignRequest createCampaignRequest) {
        ValidationUtils.assertStringNotEmpty(StringUtils.fromString(createCampaignRequest.getApplicationId()), "ApplicationId");
        ExecutionContext executionContext = this.createExecutionContext(createCampaignRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateCampaignRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateCampaignRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(createCampaignRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateCampaignResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateCampaignResult createCampaignResult = (CreateCampaignResult)response.getAwsResponse();
            return createCampaignResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateImportJobResult createImportJob(CreateImportJobRequest createImportJobRequest) {
        ValidationUtils.assertStringNotEmpty(StringUtils.fromString(createImportJobRequest.getApplicationId()), "ApplicationId");
        ExecutionContext executionContext = this.createExecutionContext(createImportJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateImportJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateImportJobRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(createImportJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateImportJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateImportJobResult createImportJobResult = (CreateImportJobResult)response.getAwsResponse();
            return createImportJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSegmentResult createSegment(CreateSegmentRequest createSegmentRequest) {
        ValidationUtils.assertStringNotEmpty(StringUtils.fromString(createSegmentRequest.getApplicationId()), "ApplicationId");
        ExecutionContext executionContext = this.createExecutionContext(createSegmentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateSegmentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateSegmentRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(createSegmentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateSegmentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateSegmentResult createSegmentResult = (CreateSegmentResult)response.getAwsResponse();
            return createSegmentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteApnsChannelResult deleteApnsChannel(DeleteApnsChannelRequest deleteApnsChannelRequest) {
        ValidationUtils.assertStringNotEmpty(StringUtils.fromString(deleteApnsChannelRequest.getApplicationId()), "ApplicationId");
        ExecutionContext executionContext = this.createExecutionContext(deleteApnsChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteApnsChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteApnsChannelRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(deleteApnsChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteApnsChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteApnsChannelResult deleteApnsChannelResult = (DeleteApnsChannelResult)response.getAwsResponse();
            return deleteApnsChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteCampaignResult deleteCampaign(DeleteCampaignRequest deleteCampaignRequest) {
        ValidationUtils.assertStringNotEmpty(StringUtils.fromString(deleteCampaignRequest.getApplicationId()), "ApplicationId");
        ValidationUtils.assertStringNotEmpty(StringUtils.fromString(deleteCampaignRequest.getCampaignId()), "CampaignId");
        ExecutionContext executionContext = this.createExecutionContext(deleteCampaignRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteCampaignRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteCampaignRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(deleteCampaignRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteCampaignResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteCampaignResult deleteCampaignResult = (DeleteCampaignResult)response.getAwsResponse();
            return deleteCampaignResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteGcmChannelResult deleteGcmChannel(DeleteGcmChannelRequest deleteGcmChannelRequest) {
        ValidationUtils.assertStringNotEmpty(StringUtils.fromString(deleteGcmChannelRequest.getApplicationId()), "ApplicationId");
        ExecutionContext executionContext = this.createExecutionContext(deleteGcmChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteGcmChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteGcmChannelRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(deleteGcmChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteGcmChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteGcmChannelResult deleteGcmChannelResult = (DeleteGcmChannelResult)response.getAwsResponse();
            return deleteGcmChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSegmentResult deleteSegment(DeleteSegmentRequest deleteSegmentRequest) {
        ValidationUtils.assertStringNotEmpty(StringUtils.fromString(deleteSegmentRequest.getApplicationId()), "ApplicationId");
        ValidationUtils.assertStringNotEmpty(StringUtils.fromString(deleteSegmentRequest.getSegmentId()), "SegmentId");
        ExecutionContext executionContext = this.createExecutionContext(deleteSegmentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteSegmentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteSegmentRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(deleteSegmentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteSegmentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteSegmentResult deleteSegmentResult = (DeleteSegmentResult)response.getAwsResponse();
            return deleteSegmentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetApnsChannelResult getApnsChannel(GetApnsChannelRequest getApnsChannelRequest) {
        ValidationUtils.assertStringNotEmpty(StringUtils.fromString(getApnsChannelRequest.getApplicationId()), "ApplicationId");
        ExecutionContext executionContext = this.createExecutionContext(getApnsChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetApnsChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetApnsChannelRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(getApnsChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetApnsChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetApnsChannelResult getApnsChannelResult = (GetApnsChannelResult)response.getAwsResponse();
            return getApnsChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetApplicationSettingsResult getApplicationSettings(GetApplicationSettingsRequest getApplicationSettingsRequest) {
        ValidationUtils.assertStringNotEmpty(StringUtils.fromString(getApplicationSettingsRequest.getApplicationId()), "ApplicationId");
        ExecutionContext executionContext = this.createExecutionContext(getApplicationSettingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetApplicationSettingsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetApplicationSettingsRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(getApplicationSettingsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetApplicationSettingsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetApplicationSettingsResult getApplicationSettingsResult = (GetApplicationSettingsResult)response.getAwsResponse();
            return getApplicationSettingsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCampaignResult getCampaign(GetCampaignRequest getCampaignRequest) {
        ValidationUtils.assertStringNotEmpty(StringUtils.fromString(getCampaignRequest.getApplicationId()), "ApplicationId");
        ValidationUtils.assertStringNotEmpty(StringUtils.fromString(getCampaignRequest.getCampaignId()), "CampaignId");
        ExecutionContext executionContext = this.createExecutionContext(getCampaignRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetCampaignRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetCampaignRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(getCampaignRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetCampaignResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetCampaignResult getCampaignResult = (GetCampaignResult)response.getAwsResponse();
            return getCampaignResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCampaignActivitiesResult getCampaignActivities(GetCampaignActivitiesRequest getCampaignActivitiesRequest) {
        ValidationUtils.assertStringNotEmpty(StringUtils.fromString(getCampaignActivitiesRequest.getApplicationId()), "ApplicationId");
        ValidationUtils.assertStringNotEmpty(StringUtils.fromString(getCampaignActivitiesRequest.getCampaignId()), "CampaignId");
        ExecutionContext executionContext = this.createExecutionContext(getCampaignActivitiesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetCampaignActivitiesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetCampaignActivitiesRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(getCampaignActivitiesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetCampaignActivitiesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetCampaignActivitiesResult getCampaignActivitiesResult = (GetCampaignActivitiesResult)response.getAwsResponse();
            return getCampaignActivitiesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCampaignVersionResult getCampaignVersion(GetCampaignVersionRequest getCampaignVersionRequest) {
        ValidationUtils.assertStringNotEmpty(StringUtils.fromString(getCampaignVersionRequest.getApplicationId()), "ApplicationId");
        ValidationUtils.assertStringNotEmpty(StringUtils.fromString(getCampaignVersionRequest.getCampaignId()), "CampaignId");
        ValidationUtils.assertStringNotEmpty(StringUtils.fromString(getCampaignVersionRequest.getVersion()), "Version");
        ExecutionContext executionContext = this.createExecutionContext(getCampaignVersionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetCampaignVersionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetCampaignVersionRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(getCampaignVersionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetCampaignVersionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetCampaignVersionResult getCampaignVersionResult = (GetCampaignVersionResult)response.getAwsResponse();
            return getCampaignVersionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCampaignVersionsResult getCampaignVersions(GetCampaignVersionsRequest getCampaignVersionsRequest) {
        ValidationUtils.assertStringNotEmpty(StringUtils.fromString(getCampaignVersionsRequest.getApplicationId()), "ApplicationId");
        ValidationUtils.assertStringNotEmpty(StringUtils.fromString(getCampaignVersionsRequest.getCampaignId()), "CampaignId");
        ExecutionContext executionContext = this.createExecutionContext(getCampaignVersionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetCampaignVersionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetCampaignVersionsRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(getCampaignVersionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetCampaignVersionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetCampaignVersionsResult getCampaignVersionsResult = (GetCampaignVersionsResult)response.getAwsResponse();
            return getCampaignVersionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCampaignsResult getCampaigns(GetCampaignsRequest getCampaignsRequest) {
        ValidationUtils.assertStringNotEmpty(StringUtils.fromString(getCampaignsRequest.getApplicationId()), "ApplicationId");
        ExecutionContext executionContext = this.createExecutionContext(getCampaignsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetCampaignsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetCampaignsRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(getCampaignsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetCampaignsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetCampaignsResult getCampaignsResult = (GetCampaignsResult)response.getAwsResponse();
            return getCampaignsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetEndpointResult getEndpoint(GetEndpointRequest getEndpointRequest) {
        ValidationUtils.assertStringNotEmpty(StringUtils.fromString(getEndpointRequest.getApplicationId()), "ApplicationId");
        ValidationUtils.assertStringNotEmpty(StringUtils.fromString(getEndpointRequest.getEndpointId()), "EndpointId");
        ExecutionContext executionContext = this.createExecutionContext(getEndpointRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetEndpointRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetEndpointRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(getEndpointRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetEndpointResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetEndpointResult getEndpointResult = (GetEndpointResult)response.getAwsResponse();
            return getEndpointResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetGcmChannelResult getGcmChannel(GetGcmChannelRequest getGcmChannelRequest) {
        ValidationUtils.assertStringNotEmpty(StringUtils.fromString(getGcmChannelRequest.getApplicationId()), "ApplicationId");
        ExecutionContext executionContext = this.createExecutionContext(getGcmChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetGcmChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetGcmChannelRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(getGcmChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetGcmChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetGcmChannelResult getGcmChannelResult = (GetGcmChannelResult)response.getAwsResponse();
            return getGcmChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetImportJobResult getImportJob(GetImportJobRequest getImportJobRequest) {
        ValidationUtils.assertStringNotEmpty(StringUtils.fromString(getImportJobRequest.getApplicationId()), "ApplicationId");
        ValidationUtils.assertStringNotEmpty(StringUtils.fromString(getImportJobRequest.getJobId()), "JobId");
        ExecutionContext executionContext = this.createExecutionContext(getImportJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetImportJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetImportJobRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(getImportJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetImportJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetImportJobResult getImportJobResult = (GetImportJobResult)response.getAwsResponse();
            return getImportJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetImportJobsResult getImportJobs(GetImportJobsRequest getImportJobsRequest) {
        ValidationUtils.assertStringNotEmpty(StringUtils.fromString(getImportJobsRequest.getApplicationId()), "ApplicationId");
        ExecutionContext executionContext = this.createExecutionContext(getImportJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetImportJobsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetImportJobsRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(getImportJobsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetImportJobsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetImportJobsResult getImportJobsResult = (GetImportJobsResult)response.getAwsResponse();
            return getImportJobsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSegmentResult getSegment(GetSegmentRequest getSegmentRequest) {
        ValidationUtils.assertStringNotEmpty(StringUtils.fromString(getSegmentRequest.getApplicationId()), "ApplicationId");
        ValidationUtils.assertStringNotEmpty(StringUtils.fromString(getSegmentRequest.getSegmentId()), "SegmentId");
        ExecutionContext executionContext = this.createExecutionContext(getSegmentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSegmentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSegmentRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(getSegmentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetSegmentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetSegmentResult getSegmentResult = (GetSegmentResult)response.getAwsResponse();
            return getSegmentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSegmentImportJobsResult getSegmentImportJobs(GetSegmentImportJobsRequest getSegmentImportJobsRequest) {
        ValidationUtils.assertStringNotEmpty(StringUtils.fromString(getSegmentImportJobsRequest.getApplicationId()), "ApplicationId");
        ValidationUtils.assertStringNotEmpty(StringUtils.fromString(getSegmentImportJobsRequest.getSegmentId()), "SegmentId");
        ExecutionContext executionContext = this.createExecutionContext(getSegmentImportJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSegmentImportJobsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSegmentImportJobsRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(getSegmentImportJobsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetSegmentImportJobsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetSegmentImportJobsResult getSegmentImportJobsResult = (GetSegmentImportJobsResult)response.getAwsResponse();
            return getSegmentImportJobsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSegmentVersionResult getSegmentVersion(GetSegmentVersionRequest getSegmentVersionRequest) {
        ValidationUtils.assertStringNotEmpty(StringUtils.fromString(getSegmentVersionRequest.getApplicationId()), "ApplicationId");
        ValidationUtils.assertStringNotEmpty(StringUtils.fromString(getSegmentVersionRequest.getSegmentId()), "SegmentId");
        ValidationUtils.assertStringNotEmpty(StringUtils.fromString(getSegmentVersionRequest.getVersion()), "Version");
        ExecutionContext executionContext = this.createExecutionContext(getSegmentVersionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSegmentVersionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSegmentVersionRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(getSegmentVersionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetSegmentVersionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetSegmentVersionResult getSegmentVersionResult = (GetSegmentVersionResult)response.getAwsResponse();
            return getSegmentVersionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSegmentVersionsResult getSegmentVersions(GetSegmentVersionsRequest getSegmentVersionsRequest) {
        ValidationUtils.assertStringNotEmpty(StringUtils.fromString(getSegmentVersionsRequest.getApplicationId()), "ApplicationId");
        ValidationUtils.assertStringNotEmpty(StringUtils.fromString(getSegmentVersionsRequest.getSegmentId()), "SegmentId");
        ExecutionContext executionContext = this.createExecutionContext(getSegmentVersionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSegmentVersionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSegmentVersionsRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(getSegmentVersionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetSegmentVersionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetSegmentVersionsResult getSegmentVersionsResult = (GetSegmentVersionsResult)response.getAwsResponse();
            return getSegmentVersionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSegmentsResult getSegments(GetSegmentsRequest getSegmentsRequest) {
        ValidationUtils.assertStringNotEmpty(StringUtils.fromString(getSegmentsRequest.getApplicationId()), "ApplicationId");
        ExecutionContext executionContext = this.createExecutionContext(getSegmentsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSegmentsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSegmentsRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(getSegmentsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetSegmentsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetSegmentsResult getSegmentsResult = (GetSegmentsResult)response.getAwsResponse();
            return getSegmentsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateApnsChannelResult updateApnsChannel(UpdateApnsChannelRequest updateApnsChannelRequest) {
        ValidationUtils.assertStringNotEmpty(StringUtils.fromString(updateApnsChannelRequest.getApplicationId()), "ApplicationId");
        ExecutionContext executionContext = this.createExecutionContext(updateApnsChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateApnsChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateApnsChannelRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(updateApnsChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateApnsChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateApnsChannelResult updateApnsChannelResult = (UpdateApnsChannelResult)response.getAwsResponse();
            return updateApnsChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateApplicationSettingsResult updateApplicationSettings(UpdateApplicationSettingsRequest updateApplicationSettingsRequest) {
        ValidationUtils.assertStringNotEmpty(StringUtils.fromString(updateApplicationSettingsRequest.getApplicationId()), "ApplicationId");
        ExecutionContext executionContext = this.createExecutionContext(updateApplicationSettingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateApplicationSettingsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateApplicationSettingsRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(updateApplicationSettingsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateApplicationSettingsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateApplicationSettingsResult updateApplicationSettingsResult = (UpdateApplicationSettingsResult)response.getAwsResponse();
            return updateApplicationSettingsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateCampaignResult updateCampaign(UpdateCampaignRequest updateCampaignRequest) {
        ValidationUtils.assertStringNotEmpty(StringUtils.fromString(updateCampaignRequest.getApplicationId()), "ApplicationId");
        ValidationUtils.assertStringNotEmpty(StringUtils.fromString(updateCampaignRequest.getCampaignId()), "CampaignId");
        ExecutionContext executionContext = this.createExecutionContext(updateCampaignRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateCampaignRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateCampaignRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(updateCampaignRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateCampaignResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateCampaignResult updateCampaignResult = (UpdateCampaignResult)response.getAwsResponse();
            return updateCampaignResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateEndpointResult updateEndpoint(UpdateEndpointRequest updateEndpointRequest) {
        ValidationUtils.assertStringNotEmpty(StringUtils.fromString(updateEndpointRequest.getApplicationId()), "ApplicationId");
        ValidationUtils.assertStringNotEmpty(StringUtils.fromString(updateEndpointRequest.getEndpointId()), "EndpointId");
        ExecutionContext executionContext = this.createExecutionContext(updateEndpointRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateEndpointRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateEndpointRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(updateEndpointRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateEndpointResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateEndpointResult updateEndpointResult = (UpdateEndpointResult)response.getAwsResponse();
            return updateEndpointResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateEndpointsBatchResult updateEndpointsBatch(UpdateEndpointsBatchRequest updateEndpointsBatchRequest) {
        ValidationUtils.assertStringNotEmpty(StringUtils.fromString(updateEndpointsBatchRequest.getApplicationId()), "ApplicationId");
        ExecutionContext executionContext = this.createExecutionContext(updateEndpointsBatchRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateEndpointsBatchRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateEndpointsBatchRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(updateEndpointsBatchRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateEndpointsBatchResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateEndpointsBatchResult updateEndpointsBatchResult = (UpdateEndpointsBatchResult)response.getAwsResponse();
            return updateEndpointsBatchResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateGcmChannelResult updateGcmChannel(UpdateGcmChannelRequest updateGcmChannelRequest) {
        ValidationUtils.assertStringNotEmpty(StringUtils.fromString(updateGcmChannelRequest.getApplicationId()), "ApplicationId");
        ExecutionContext executionContext = this.createExecutionContext(updateGcmChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateGcmChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateGcmChannelRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(updateGcmChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateGcmChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateGcmChannelResult updateGcmChannelResult = (UpdateGcmChannelResult)response.getAwsResponse();
            return updateGcmChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateSegmentResult updateSegment(UpdateSegmentRequest updateSegmentRequest) {
        ValidationUtils.assertStringNotEmpty(StringUtils.fromString(updateSegmentRequest.getApplicationId()), "ApplicationId");
        ValidationUtils.assertStringNotEmpty(StringUtils.fromString(updateSegmentRequest.getSegmentId()), "SegmentId");
        ExecutionContext executionContext = this.createExecutionContext(updateSegmentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateSegmentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateSegmentRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(updateSegmentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateSegmentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateSegmentResult updateSegmentResult = (UpdateSegmentResult)response.getAwsResponse();
            return updateSegmentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

