/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.elastictranscoder.model.ListPresetsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class ListPresetsRequestMarshaller
implements Marshaller<Request<ListPresetsRequest>, ListPresetsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListPresetsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListPresetsRequest> marshall(ListPresetsRequest listPresetsRequest) {
        if (listPresetsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListPresetsRequest> request = new DefaultRequest<ListPresetsRequest>(listPresetsRequest, "AmazonElasticTranscoder");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2012-09-25/presets";
        request.setResourcePath(uriResourcePath);
        if (listPresetsRequest.getAscending() != null) {
            request.addParameter("Ascending", StringUtils.fromString(listPresetsRequest.getAscending()));
        }
        if (listPresetsRequest.getPageToken() != null) {
            request.addParameter("PageToken", StringUtils.fromString(listPresetsRequest.getPageToken()));
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

