/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elastictranscoder.model.CaptionSource;
import com.amazonaws.services.elastictranscoder.model.InputCaptions;
import com.amazonaws.services.elastictranscoder.model.transform.CaptionSourceJsonMarshaller;

public class InputCaptionsJsonMarshaller {
    private static InputCaptionsJsonMarshaller instance;

    public void marshall(InputCaptions inputCaptions, StructuredJsonGenerator jsonGenerator) {
        if (inputCaptions == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList captionSourcesList;
            jsonGenerator.writeStartObject();
            if (inputCaptions.getMergePolicy() != null) {
                jsonGenerator.writeFieldName("MergePolicy").writeValue(inputCaptions.getMergePolicy());
            }
            if (!(captionSourcesList = (SdkInternalList)inputCaptions.getCaptionSources()).isEmpty() || !captionSourcesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("CaptionSources");
                jsonGenerator.writeStartArray();
                for (CaptionSource captionSourcesListValue : captionSourcesList) {
                    if (captionSourcesListValue == null) continue;
                    CaptionSourceJsonMarshaller.getInstance().marshall(captionSourcesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static InputCaptionsJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new InputCaptionsJsonMarshaller();
        }
        return instance;
    }
}

