/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CancelStepsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String clusterId;
    private SdkInternalList<String> stepIds;

    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public CancelStepsRequest withClusterId(String clusterId) {
        this.setClusterId(clusterId);
        return this;
    }

    public List<String> getStepIds() {
        if (this.stepIds == null) {
            this.stepIds = new SdkInternalList();
        }
        return this.stepIds;
    }

    public void setStepIds(Collection<String> stepIds) {
        if (stepIds == null) {
            this.stepIds = null;
            return;
        }
        this.stepIds = new SdkInternalList<String>(stepIds);
    }

    public CancelStepsRequest withStepIds(String ... stepIds) {
        if (this.stepIds == null) {
            this.setStepIds(new SdkInternalList<String>(stepIds.length));
        }
        for (String ele : stepIds) {
            this.stepIds.add(ele);
        }
        return this;
    }

    public CancelStepsRequest withStepIds(Collection<String> stepIds) {
        this.setStepIds(stepIds);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClusterId() != null) {
            sb.append("ClusterId: " + this.getClusterId() + ",");
        }
        if (this.getStepIds() != null) {
            sb.append("StepIds: " + this.getStepIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelStepsRequest)) {
            return false;
        }
        CancelStepsRequest other = (CancelStepsRequest)obj;
        if (other.getClusterId() == null ^ this.getClusterId() == null) {
            return false;
        }
        if (other.getClusterId() != null && !other.getClusterId().equals(this.getClusterId())) {
            return false;
        }
        if (other.getStepIds() == null ^ this.getStepIds() == null) {
            return false;
        }
        return other.getStepIds() == null || other.getStepIds().equals(this.getStepIds());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClusterId() == null ? 0 : this.getClusterId().hashCode());
        hashCode = 31 * hashCode + (this.getStepIds() == null ? 0 : this.getStepIds().hashCode());
        return hashCode;
    }

    @Override
    public CancelStepsRequest clone() {
        return (CancelStepsRequest)super.clone();
    }
}

