/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codebuild.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codebuild.model.Project;
import com.amazonaws.services.codebuild.model.Tag;
import com.amazonaws.services.codebuild.model.transform.ProjectArtifactsJsonMarshaller;
import com.amazonaws.services.codebuild.model.transform.ProjectEnvironmentJsonMarshaller;
import com.amazonaws.services.codebuild.model.transform.ProjectSourceJsonMarshaller;
import com.amazonaws.services.codebuild.model.transform.TagJsonMarshaller;
import java.util.List;

public class ProjectJsonMarshaller {
    private static ProjectJsonMarshaller instance;

    public void marshall(Project project, StructuredJsonGenerator jsonGenerator) {
        if (project == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Tag> tagsList;
            jsonGenerator.writeStartObject();
            if (project.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(project.getName());
            }
            if (project.getArn() != null) {
                jsonGenerator.writeFieldName("arn").writeValue(project.getArn());
            }
            if (project.getDescription() != null) {
                jsonGenerator.writeFieldName("description").writeValue(project.getDescription());
            }
            if (project.getSource() != null) {
                jsonGenerator.writeFieldName("source");
                ProjectSourceJsonMarshaller.getInstance().marshall(project.getSource(), jsonGenerator);
            }
            if (project.getArtifacts() != null) {
                jsonGenerator.writeFieldName("artifacts");
                ProjectArtifactsJsonMarshaller.getInstance().marshall(project.getArtifacts(), jsonGenerator);
            }
            if (project.getEnvironment() != null) {
                jsonGenerator.writeFieldName("environment");
                ProjectEnvironmentJsonMarshaller.getInstance().marshall(project.getEnvironment(), jsonGenerator);
            }
            if (project.getServiceRole() != null) {
                jsonGenerator.writeFieldName("serviceRole").writeValue(project.getServiceRole());
            }
            if (project.getTimeoutInMinutes() != null) {
                jsonGenerator.writeFieldName("timeoutInMinutes").writeValue(project.getTimeoutInMinutes());
            }
            if (project.getEncryptionKey() != null) {
                jsonGenerator.writeFieldName("encryptionKey").writeValue(project.getEncryptionKey());
            }
            if ((tagsList = project.getTags()) != null) {
                jsonGenerator.writeFieldName("tags");
                jsonGenerator.writeStartArray();
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue == null) continue;
                    TagJsonMarshaller.getInstance().marshall(tagsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (project.getCreated() != null) {
                jsonGenerator.writeFieldName("created").writeValue(project.getCreated());
            }
            if (project.getLastModified() != null) {
                jsonGenerator.writeFieldName("lastModified").writeValue(project.getLastModified());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ProjectJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ProjectJsonMarshaller();
        }
        return instance;
    }
}

