/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.batch.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.batch.model.JobDefinition;
import com.amazonaws.services.batch.model.transform.ContainerPropertiesJsonMarshaller;
import java.util.Map;

public class JobDefinitionJsonMarshaller {
    private static JobDefinitionJsonMarshaller instance;

    public void marshall(JobDefinition jobDefinition, StructuredJsonGenerator jsonGenerator) {
        if (jobDefinition == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            Map<String, String> parametersMap;
            jsonGenerator.writeStartObject();
            if (jobDefinition.getJobDefinitionName() != null) {
                jsonGenerator.writeFieldName("jobDefinitionName").writeValue(jobDefinition.getJobDefinitionName());
            }
            if (jobDefinition.getJobDefinitionArn() != null) {
                jsonGenerator.writeFieldName("jobDefinitionArn").writeValue(jobDefinition.getJobDefinitionArn());
            }
            if (jobDefinition.getRevision() != null) {
                jsonGenerator.writeFieldName("revision").writeValue(jobDefinition.getRevision());
            }
            if (jobDefinition.getStatus() != null) {
                jsonGenerator.writeFieldName("status").writeValue(jobDefinition.getStatus());
            }
            if (jobDefinition.getType() != null) {
                jsonGenerator.writeFieldName("type").writeValue(jobDefinition.getType());
            }
            if ((parametersMap = jobDefinition.getParameters()) != null) {
                jsonGenerator.writeFieldName("parameters");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> parametersMapValue : parametersMap.entrySet()) {
                    if (parametersMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(parametersMapValue.getKey());
                    jsonGenerator.writeValue(parametersMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (jobDefinition.getContainerProperties() != null) {
                jsonGenerator.writeFieldName("containerProperties");
                ContainerPropertiesJsonMarshaller.getInstance().marshall(jobDefinition.getContainerProperties(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static JobDefinitionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new JobDefinitionJsonMarshaller();
        }
        return instance;
    }
}

