/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.batch.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.batch.model.ContainerOverrides;
import com.amazonaws.services.batch.model.KeyValuePair;
import com.amazonaws.services.batch.model.transform.KeyValuePairJsonMarshaller;
import java.util.List;

public class ContainerOverridesJsonMarshaller {
    private static ContainerOverridesJsonMarshaller instance;

    public void marshall(ContainerOverrides containerOverrides, StructuredJsonGenerator jsonGenerator) {
        if (containerOverrides == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<KeyValuePair> environmentList;
            List<String> commandList;
            jsonGenerator.writeStartObject();
            if (containerOverrides.getVcpus() != null) {
                jsonGenerator.writeFieldName("vcpus").writeValue(containerOverrides.getVcpus());
            }
            if (containerOverrides.getMemory() != null) {
                jsonGenerator.writeFieldName("memory").writeValue(containerOverrides.getMemory());
            }
            if ((commandList = containerOverrides.getCommand()) != null) {
                jsonGenerator.writeFieldName("command");
                jsonGenerator.writeStartArray();
                for (String commandListValue : commandList) {
                    if (commandListValue == null) continue;
                    jsonGenerator.writeValue(commandListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if ((environmentList = containerOverrides.getEnvironment()) != null) {
                jsonGenerator.writeFieldName("environment");
                jsonGenerator.writeStartArray();
                for (KeyValuePair environmentListValue : environmentList) {
                    if (environmentListValue == null) continue;
                    KeyValuePairJsonMarshaller.getInstance().marshall(environmentListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ContainerOverridesJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ContainerOverridesJsonMarshaller();
        }
        return instance;
    }
}

